/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.descontobaixaautomatica;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Map;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class DescontoBaixaAutomaticaDetalheJobListener
extends JobExecutionListenerSupport {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(DescontoBaixaAutomaticaDetalheJobListener.class);
    private final NotificacaoService notificacaoService;
    private final String notificationKey = "notificacaoDescontoBaixaAutomaticaDetalheId";
    private static final Map<NotificationStatus, String> notificationMessage = Map.of(NotificationStatus.STARTED, "Iniciando rotina de concess\u00e3o de desconto do lote %s ", NotificationStatus.COMPLETED, "Finalizado rotina de concess\u00e3o de desconto do lote %s", NotificationStatus.FAILED, "Erro na rotina de concess\u00e3o de desconto do lote %s");

    private String buildIdentificador(JobExecution jobExecution) {
        Long lote = jobExecution.getJobParameters().getLong("lote");
        Long exercicio = jobExecution.getJobParameters().getLong("exercicio");
        return String.format("%s/%s", lote, exercicio);
    }

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        String identificador = this.buildIdentificador(jobExecution);
        Optional notificacaoId = this.notificaInicio(identificador, jobExecution);
        notificacaoId.ifPresent(id -> jobExecution.getExecutionContext().put("notificacaoDescontoBaixaAutomaticaDetalheId", id));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        String identificador = this.buildIdentificador(jobExecution);
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificaFinalSuccess(identificador, jobExecution);
        } else {
            this.notificaFinalFailed(identificador, jobExecution);
        }
    }

    private Optional<UUID> notificaInicio(String identificador, JobExecution jobExecution) {
        return this.notificar(identificador, jobExecution, NotificationStatus.STARTED);
    }

    private void notificaFinalSuccess(String identificador, JobExecution jobExecution) {
        this.notificar(identificador, jobExecution, NotificationStatus.COMPLETED);
    }

    private void notificaFinalFailed(String identificador, JobExecution jobExecution) {
        this.notificar(identificador, jobExecution, NotificationStatus.FAILED);
    }

    private Optional<UUID> notificar(String identificador, JobExecution jobExecution, NotificationStatus status) {
        String message = String.format((String)notificationMessage.get(status), identificador);
        Optional<UUID> notificacaoId = Optional.ofNullable(jobExecution.getExecutionContext().get("notificacaoDescontoBaixaAutomaticaDetalheId")).map(id -> UUID.fromString(String.valueOf(id)));
        return this.notificacaoService.send("Concess\u00e3o Desconto Baixa Automatica", message, jobExecution, notificacaoId, status);
    }

    @Generated
    public DescontoBaixaAutomaticaDetalheJobListener(NotificacaoService notificacaoService) {
        this.notificacaoService = notificacaoService;
    }
}

