/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.consultadebito;

import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.util.Map;
import java.util.Objects;
import javax.sql.DataSource;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcPagingItemReader;
import org.springframework.batch.item.database.support.SqlPagingQueryProviderFactoryBean;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ConsultaDebitoBatchReader
extends JdbcPagingItemReader<Long> {
    public ConsultaDebitoBatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource, ObjectMapper objectMapper) throws Exception {
        this.setFetchSize(10);
        this.setName("debitoConsultaId");
        this.setDataSource(dataSource);
        this.setRowMapper((rs, rowNum) -> rs.getLong("idDebito"));
        this.setQueryProvider(Objects.requireNonNull(this.queryProvider(jobParameters, objectMapper, dataSource).getObject()));
    }

    private SqlPagingQueryProviderFactoryBean queryProvider(Map<String, Object> jobParameters, ObjectMapper objectMapper, DataSource dataSource) throws IOException {
        SqlPagingQueryProviderFactoryBean provider = new SqlPagingQueryProviderFactoryBean();
        FiltroConsultaDebitoDTO filtro = (FiltroConsultaDebitoDTO)objectMapper.readValue((String)jobParameters.get("filtro"), FiltroConsultaDebitoDTO.class);
        Long entidade = (Long)jobParameters.get("entidade");
        provider.setDataSource(dataSource);
        provider.setSelectClause("SELECT DISTINCT IDDEBITO ");
        provider.setFromClause("FROM TRIBDEBITO TD LEFT OUTER JOIN TRIBDEBITOPARCELA TDP ON TD.ENTIDADE = TDP.ENTIDADE AND TD.EXERCICIO = TDP.EXERCICIO AND TD.TIPOCADASTRO = TDP.TIPOCADASTRO AND TD.CADASTROGERAL = TDP.CADASTROGERAL AND TD.GUIARECOLHIMENTO =TDP.GUIARECOLHIMENTO AND TD.SUBDIVIDA = TDP.SUBDIVIDA LEFT OUTER JOIN TRIBDEBITOPARCELARECEITA TDPR ON TDPR.ENTIDADE = TDP.ENTIDADE AND TDPR.EXERCICIO = TDP.EXERCICIO AND TDPR.TIPOCADASTRO = TDP.TIPOCADASTRO AND TDPR.CADASTROGERAL = TDP.CADASTROGERAL AND TDPR.GUIARECOLHIMENTO =TDP.GUIARECOLHIMENTO AND TDPR.SUBDIVIDA = TDP.SUBDIVIDA AND TDPR.PARCELA = TDP.PARCELA LEFT OUTER JOIN TRIBRECEITA RECEITA ON     TDPR.ENTIDADE = RECEITA.ENTIDADE AND     TDPR.EXERCICIO = RECEITA.EXERCICIO AND     TDPR.RECEITA = RECEITA.RECEITA LEFT OUTER JOIN TRIBRECEITATIPO RECEITATIPO ON     RECEITA.TIPORECEITA = RECEITATIPO.TIPORECEITA LEFT OUTER JOIN TRIBSITUACAOPARCELA TSP ON TDP.SITUACAODEBITO = TSP.SITUACAOPARCELA LEFT OUTER JOIN TRIBTIPOSITUACAOPARCELA TTSP ON TTSP.TIPOSITUACAOPARCELA = TSP.TIPOSITUACAOPARCELA LEFT OUTER JOIN TRIBCADASTROGERAL TCG ON TD.TIPOCADASTRO = TCG.TIPOCADASTRO AND TD.CADASTROGERAL = TCG.CADASTROGERAL LEFT OUTER JOIN PESSOA P on TCG.PESSOA = P.PESSOA ");
        provider.setWhereClause(String.format("WHERE TD.CONSTITUIDO = 'S' AND TD.ENTIDADE = %d AND TDPR.VALOR <> 0 %s", entidade, filtro.generateWhere()));
        provider.setSortKey("IDDEBITO");
        provider.setGroupClause(String.format("GROUP BY IDDEBITO %s", filtro.buildHaving()));
        return provider;
    }
}

