/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.cda.simulacao;

import br.com.elotech.tributos.batch.DefaultItemFailureListener;
import br.com.elotech.tributos.batch.cda.simulacao.FiltroValorMinimoCdaBatchProcessor;
import br.com.elotech.tributos.batch.cda.simulacao.FiltroValorMinimoCdaBatchReader;
import br.com.elotech.tributos.batch.cda.simulacao.FiltroValorMinimoCdaBatchWriter;
import br.com.elotech.tributos.batch.cda.simulacao.SimulacaoLoteCdaBatchDecider;
import br.com.elotech.tributos.batch.cda.simulacao.SimulacaoLoteCdaBatchProcessor;
import br.com.elotech.tributos.batch.cda.simulacao.SimulacaoLoteCdaBatchReader;
import br.com.elotech.tributos.batch.cda.simulacao.SimulacaoLoteCdaBatchWriter;
import br.com.elotech.tributos.batch.cda.simulacao.SimulacaoLoteCdaJobListener;
import br.com.elotech.tributos.domain.JobType;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecutionListener;
import org.springframework.batch.core.JobParametersIncrementer;
import org.springframework.batch.core.JobParametersValidator;
import org.springframework.batch.core.Step;
import org.springframework.batch.core.configuration.annotation.JobBuilderFactory;
import org.springframework.batch.core.configuration.annotation.StepBuilderFactory;
import org.springframework.batch.core.job.DefaultJobParametersValidator;
import org.springframework.batch.core.job.builder.FlowJobBuilder;
import org.springframework.batch.core.job.builder.JobBuilder;
import org.springframework.batch.core.job.flow.FlowExecutionStatus;
import org.springframework.batch.core.job.flow.JobExecutionDecider;
import org.springframework.batch.core.launch.support.RunIdIncrementer;
import org.springframework.batch.core.step.builder.AbstractTaskletStepBuilder;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.batch.item.ItemReader;
import org.springframework.batch.item.ItemWriter;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
public class SimulacaoLoteCdaBatchConfig {
    private static final String FILTER_VALOR_MINIMO_CERTIDAO = "filterValorMinimoCertidao";

    @Bean
    @Qualifier(value="simulacaoLoteCdaBatchJob")
    public Job simulacaoLoteCdaBatchJob(JobBuilderFactory jobBuilderFactory, Step simulacaoLoteCdaStep, Step filtroValorMinimoCdaStep, SimulacaoLoteCdaJobListener listener) {
        DefaultJobParametersValidator validator = new DefaultJobParametersValidator();
        validator.setRequiredKeys(new String[]{"idLote", "geracaoLoteCdaDto"});
        return ((FlowJobBuilder)((JobBuilder)((JobBuilder)((JobBuilder)jobBuilderFactory.get(JobType.SIMULACAO_LOTE_CDA.getTipo()).validator((JobParametersValidator)validator)).listener((JobExecutionListener)listener)).incrementer((JobParametersIncrementer)new RunIdIncrementer())).start(simulacaoLoteCdaStep).next(this.simulacaoLoteCdaDecider()).on(FILTER_VALOR_MINIMO_CERTIDAO).to(filtroValorMinimoCdaStep).from(this.simulacaoLoteCdaDecider()).on(FlowExecutionStatus.COMPLETED.getName()).end().build()).build();
    }

    @Bean
    public JobExecutionDecider simulacaoLoteCdaDecider() {
        return new SimulacaoLoteCdaBatchDecider();
    }

    @Bean
    public Step simulacaoLoteCdaStep(StepBuilderFactory stepBuilderFactory, SimulacaoLoteCdaBatchReader reader, SimulacaoLoteCdaBatchProcessor processor, SimulacaoLoteCdaBatchWriter writer) {
        DefaultItemFailureListener defaultItemFailureListener = new DefaultItemFailureListener();
        return ((AbstractTaskletStepBuilder)stepBuilderFactory.get("simulacaoLoteCdaStep").chunk(1000).reader((ItemReader)reader).processor((ItemProcessor)processor).writer((ItemWriter)writer).listener((Object)defaultItemFailureListener).listener((Object)defaultItemFailureListener).listener((Object)defaultItemFailureListener).allowStartIfComplete(Boolean.TRUE.booleanValue())).build();
    }

    @Bean
    public Step filtroValorMinimoCdaStep(StepBuilderFactory stepBuilderFactory, FiltroValorMinimoCdaBatchReader reader, FiltroValorMinimoCdaBatchProcessor processor, FiltroValorMinimoCdaBatchWriter writer) {
        DefaultItemFailureListener defaultItemFailureListener = new DefaultItemFailureListener();
        return ((AbstractTaskletStepBuilder)stepBuilderFactory.get("filtroValorMinimoCdaStep").chunk(1000).reader((ItemReader)reader).processor((ItemProcessor)processor).writer((ItemWriter)writer).listener((Object)defaultItemFailureListener).listener((Object)defaultItemFailureListener).listener((Object)defaultItemFailureListener).allowStartIfComplete(Boolean.TRUE.booleanValue())).build();
    }
}

