/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.alteracaocadastroemmassa;

import br.com.elotech.tributos.batch.alteracaocadastroemmassa.EdicaoEmMassaBatchProcessor;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.dto.CampoEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.repository.BairroRepository;
import br.com.elotech.tributos.repository.LogradouroRepository;
import br.com.elotech.tributos.repository.SituacaoImobiliarioRepository;
import br.com.elotech.tributos.repository.camposdinamicos.RespostaRepository;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Objects;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class EdicaoEmMassaBatchProcessor
implements ItemProcessor<Long, CadastroGeral> {
    private static final Logger LOGGER = LoggerFactory.getLogger(EdicaoEmMassaBatchProcessor.class);
    private StepExecution stepExecution;
    private final EntityManager entityManager;
    private final RespostaRepository respostaRepository;
    private final LogradouroRepository logradouroRepository;
    private final BairroRepository bairroRepository;
    private final SituacaoImobiliarioRepository situacaoImobiliarioRepository;
    private final ObjectMapper objectMapper;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public CadastroGeral process(Long idCadastro) throws Exception {
        LOGGER.info("Edicao de cadastro em massa - Processando cadastro de id: {}. Read Count: {}", (Object)idCadastro, (Object)this.stepExecution.getReadCount());
        JobParameters jobParameters = this.stepExecution.getJobExecution().getJobParameters();
        EdicaoEmMassaFiltroDTO filtro = (EdicaoEmMassaFiltroDTO)this.objectMapper.readValue(jobParameters.getString("filtro"), EdicaoEmMassaFiltroDTO.class);
        CadastroImobiliario cadastro = (CadastroImobiliario)this.entityManager.getReference(CadastroImobiliario.class, (Object)idCadastro);
        if (Objects.nonNull(filtro)) {
            filtro.getCamposValues().forEach(campo -> {
                if (Objects.nonNull(campo.getCampo().getOrigemCampo())) {
                    switch (1.$SwitchMap$br$com$elotech$tributos$dto$CampoEdicaoEmMassa$OrigemCampo[campo.getCampo().getOrigemCampo().ordinal()]) {
                        case 1: {
                            this.logradouroRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setLogradouro(arg_0));
                            break;
                        }
                        case 2: {
                            this.bairroRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setBairro(arg_0));
                            break;
                        }
                        case 3: {
                            this.situacaoImobiliarioRepository.findById((Object)Long.valueOf(campo.getValor())).ifPresent(arg_0 -> ((CadastroImobiliario)cadastro).setSituacaoImobiliario(arg_0));
                            break;
                        }
                        default: {
                            LOGGER.info("Origem do campo n\u00e3o encontrada, para o cadastro de id: {} e campo: {}", (Object)idCadastro, (Object)campo.getCampo().getId());
                            break;
                        }
                    }
                } else {
                    RespostaTerreno resposta = this.respostaRepository.getRespostasTerrenoFilterByCampo(idCadastro, campo.getCampo().getId()).stream().findFirst().orElse(new RespostaTerreno());
                    resposta.setCadastroImobiliario(cadastro);
                    resposta.setCampo(CampoEdicaoEmMassaDTO.toEntity((CampoEdicaoEmMassaDTO)campo.getCampo()));
                    resposta.setValor(campo.getValor());
                    if (!campo.getCampo().getAlternativas().isEmpty()) {
                        resposta.setAlternativa((Alternativa)campo.getCampo().getAlternativas().stream().filter(alt -> alt.getId().equals(Long.valueOf(campo.getValor()))).findFirst().orElse(null));
                    }
                    this.respostaRepository.save((Object)resposta);
                }
            });
        }
        return cadastro;
    }

    @Generated
    public EdicaoEmMassaBatchProcessor(EntityManager entityManager, RespostaRepository respostaRepository, LogradouroRepository logradouroRepository, BairroRepository bairroRepository, SituacaoImobiliarioRepository situacaoImobiliarioRepository, ObjectMapper objectMapper) {
        this.entityManager = entityManager;
        this.respostaRepository = respostaRepository;
        this.logradouroRepository = logradouroRepository;
        this.bairroRepository = bairroRepository;
        this.situacaoImobiliarioRepository = situacaoImobiliarioRepository;
        this.objectMapper = objectMapper;
    }
}

