with contagem1 as (select nrdivida, nranodivida, count(1) as quantidadeRegistroNrDivida from tceinsccreditoda group by 1,2),
contagem2 as (select nranodivida, idtipooperacaocredito, nrcredito, idtiponaturezacredito, idtipocredito, cdcontroleleiato, dtinscricao, nranoinscricao, count(1) as quantidadeRegistroCredito from tceinsccreditoda group by 1,2,3,4,5,6,7,8)
select ticda.idtceinsccreditoda,
       ticda.nranoinscricao,
       ticda.dtinscricao,
       ticda.vlinscricao,
       ticda.idtipooperacaocredito,
       ticda.idtiponaturezacredito,
       ticda.idtipocredito,
       ticda.nrdivida,
       ticda.nranodivida,
       ticda.nrcredito,
       ticda.nranocredito,
       tlc.dtlancamento,
       ticda.nranobase,
	   extract(month from :dataInicial::date) as nrmesbase,
       c1.quantidadeRegistroNrDivida,
       coalesce(c2.quantidadeRegistroCredito, 1) as quantidadeRegistroCredito,
       t.codigo as escopolei,
	   ticda.cdcontroleleiato,
       coalesce(lag(ticda.nrdivida, 1) over (order by idtceinsccreditoda), 0) as nrdividaAnterior
from tceinsccreditoda ticda
         inner join contagem1 c1 on ticda.nrdivida = c1.nrdivida and ticda.nranodivida= c1.nranodivida
         left join contagem2 c2 on ticda.nranodivida = c2.nranodivida and ticda.idtipooperacaocredito = c2.idtipooperacaocredito
         and ticda.nrcredito = c2.nrcredito and ticda.idtiponaturezacredito = c2.idtiponaturezacredito
         and ticda.idtipocredito = c2.idtipocredito and ticda.cdcontroleleiato = c2.cdcontroleleiato
         and ticda.dtinscricao = c2.dtinscricao and ticda.nranoinscricao = c2.nranoinscricao
         left  join cgato cg on cg.entidade = :entidade and cg.idato = ticda.cdControleLeiAto
         left join tipoescopolei t on cg.idtipoescopolei = t.id
         left join tcelanccredito tlc on tlc.nrcredito = ticda.nrcredito and tlc.nranocredito = ticda.nranocredito
where ticda.dtinscricao  between :dataInicial and :dataFinal