SELECT DEBITOPARCELARECEITA.RECEITA                     AS tributo,
       SUM(COALESCE(PAGAMENTODEBITO.VALORPRINCIPAL, 0) + COALESCE(PAGAMENTODEBITO.VALORPAGOMAIOR, 0)) AS valorPrincipal,
       SUM(COALESCE(PAGAMENTODEBITO.VALORJUROS, 0))     AS valorJuros,
       SUM(COALESCE(PAGAMENTODEBITO.VALORMULTA, 0))     AS valorMulta,
       SUM(COALESCE(PAGAMENTODEBITO.VALORCORRECAO, 0))  AS valorCorrecao,
       SUM(COALESCE(PAGAMENTODEBITO.VALORDESCONTO, 0))  AS valorDesconto
FROM TRIBPAGAMENTO PAGAMENTO
         LEFT JOIN TRIBPAGAMENTOBLOQUETO PAGAMENTOBLOQUETO
              ON PAGAMENTO.ENTIDADE = PAGAMENTOBLOQUETO.ENTIDADE AND
                 PAGAMENTO.EXERCICIOPAGAMENTO = PAGAMENTOBLOQUETO.EXERCICIOPAGAMENTO AND
                 PAGAMENTO.PAGAMENTO = PAGAMENTOBLOQUETO.PAGAMENTO
         LEFT JOIN TRIBPAGAMENTODEBITO PAGAMENTODEBITO
              ON PAGAMENTOBLOQUETO.IDPAGAMENTOBLOQUETO = PAGAMENTODEBITO.IDPAGAMENTOBLOQUETO
         LEFT JOIN CONTABANCARIA
              ON PAGAMENTO.ENTIDADE = CONTABANCARIA.ENTIDADE AND
                 PAGAMENTO.CONTABANCARIA = CONTABANCARIA.CONTABANCARIA
         LEFT JOIN TRIBDEBITOPARCELARECEITA DEBITOPARCELARECEITA
              ON PAGAMENTODEBITO.IDDEBITOPARCELARECEITA = DEBITOPARCELARECEITA.IDDEBITOPARCELARECEITA
         LEFT JOIN TRIBRECEITA RECEITA ON RECEITA.ENTIDADE = DEBITOPARCELARECEITA.ENTIDADE AND
                                     RECEITA.EXERCICIO = DEBITOPARCELARECEITA.EXERCICIO AND
                                     RECEITA.RECEITA = DEBITOPARCELARECEITA.RECEITA
         LEFT JOIN TRIBRECEITATIPO TIPORECEITA ON RECEITA.TIPORECEITA = TIPORECEITA.TIPORECEITA
WHERE CONTABANCARIA.INTEGRAARRECADACAO = 'S'
AND PAGAMENTO.DATALANCAMENTO = :dataLancamento
%s
GROUP BY DEBITOPARCELARECEITA.RECEITA