 SELECT
     deb.IDDEBITO,
     dpr.ENTIDADE,
     dpr.EXERCICIO,
     dpr.TIPOCADASTRO,
     dpr.CADASTROGERAL,
     dpr.GUIARECOLHIMENTO as divida,
     dpr.SUBDIVIDA,
     dpr.PARCELA,
     dpr.VALOR,
     p.SITUACAOLEGAL,
     dpr.IDDEBITOPARCELARECEITA AS id,
     dpr.RECEITA as tributo,
     COALESCE(:percentual, 0) AS porcentagem,
     ((dpr.valor * COALESCE(:percentual, 0)) /100) AS valorCancelamento,
     dpr.valor - ((dpr.valor * COALESCE(:percentual, 0)) /100) AS valorFinal
 FROM TRIBDEBITOPARCELARECEITA dpr
 INNER JOIN TRIBDEBITO deb
     on dpr.ENTIDADE = deb.ENTIDADE
     and dpr.EXERCICIO = deb.EXERCICIO
     and dpr.TIPOCADASTRO = deb.TIPOCADASTRO
     and dpr.CADASTROGERAL = deb.CADASTROGERAL
     and dpr.GUIARECOLHIMENTO = deb.GUIARECOLHIMENTO
     and dpr.SUBDIVIDA = deb.SUBDIVIDA
 INNER JOIN TRIBDEBITOPARCELA p
     ON p.entidade = dpr.entidade
     AND p.EXERCICIO = dpr.EXERCICIO
     AND P.TIPOCADASTRO = dpr.TIPOCADASTRO
     AND p.CADASTROGERAL = dpr.CADASTROGERAL
     AND p.GUIARECOLHIMENTO = dpr.GUIARECOLHIMENTO
     AND p.SUBDIVIDA = dpr.SUBDIVIDA
     AND p.PARCELA = dpr.PARCELA
 INNER JOIN TRIBSITUACAOPARCELA s
     ON s.SITUACAOPARCELA = p.SITUACAODEBITO
 INNER JOIN TRIBTIPOSITUACAOPARCELA ts
     ON ts.TIPOSITUACAOPARCELA = s.TIPOSITUACAOPARCELA
WHERE dpr.entidade = :entidade
    AND dpr.TIPOCADASTRO = :tipoCadastro
    AND dpr.RECEITA = :tributo
    AND dpr.VALOR > 0
    AND ts.TIPO = 'A'
    AND p.SITUACAOLEGAL IN (:situacoesLegais)
    $[FILTROS]
ORDER BY dpr.entidade,
 dpr.exercicio,
 dpr.tipoCadastro,
 dpr.cadastroGeral,
 dpr.guiarecolhimento,
 dpr.subdivida,
 dpr.parcela,
 dpr.receita