/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.supersimples;

import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacao;
import java.util.Date;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.stereotype.Component;

@Component
public class ImportacaoSuperSimplesJobStarter {
    private JobLauncher jobLauncher;
    private Job importacaoSuperSimplesJob;

    public ImportacaoSuperSimplesJobStarter(JobLauncher jobLauncher, @Qualifier(value="importacaoSuperSimplesBatchJob") Job importacaoSuperSimplesJob) {
        this.jobLauncher = jobLauncher;
        this.importacaoSuperSimplesJob = importacaoSuperSimplesJob;
    }

    public JobExecution startJob(SuperSimplesSolicitacao superSimplesSolicitacao) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException {
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addLong("idSolicitacao", superSimplesSolicitacao.getId(), true);
        jobParametersBuilder.addLong("idArquivo", superSimplesSolicitacao.getIdArquivo());
        jobParametersBuilder.addDate("date", new Date());
        return this.jobLauncher.run(this.importacaoSuperSimplesJob, jobParametersBuilder.toJobParameters());
    }
}

