/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.simam.validacaoregrasimportacao;

import br.com.elotech.tributos.domain.simam.validacoes.ErrosImportacaoSIMAM;
import br.com.elotech.tributos.dto.simam.validacaoimportacao.EstornoInscricaoDividaAtivaValidacao;
import br.com.elotech.tributos.util.DateUtils;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import java.util.Objects;
import org.springframework.batch.core.StepExecution;
import org.springframework.stereotype.Service;

@Service
public class EstornoInscricaoDividaAtivaValidacaoSimAmService {
    public List<ErrosImportacaoSIMAM> validateEstorno(EstornoInscricaoDividaAtivaValidacao estornoInscricao, StepExecution stepExecution) {
        ArrayList<ErrosImportacaoSIMAM> erros = new ArrayList<ErrosImportacaoSIMAM>();
        LocalDate dataProcessamento = DateUtils.dateToLocalDate((Date)Objects.requireNonNull(stepExecution.getJobExecution().getJobParameters().getDate("dataFinal")));
        this.validaRegistroDuplicado(estornoInscricao, erros);
        this.validaSequenciaValida(estornoInscricao, erros);
        this.validaSeEstornoTemDividaVinculada(estornoInscricao, erros);
        this.validaSeADividaEMunicipal(estornoInscricao, erros);
        this.validaSeADataDoEstornoEMaiorQueInscricaoEMenorQueADataDeProcessamento(estornoInscricao, dataProcessamento, erros);
        this.validaSeOValorDoEstornoEPositivo(estornoInscricao, erros);
        this.validaSeMotivoTemMaisDeVinteCaracteres(estornoInscricao, erros);
        this.validaSeTemEstornoRepetidoParaUmaMesmaInscricao(estornoInscricao, erros);
        this.validaSeEstornoEDeDividaAtual(estornoInscricao, dataProcessamento, erros);
        return erros;
    }

    private void validaRegistroDuplicado(EstornoInscricaoDividaAtivaValidacao estornoInscricao, List<ErrosImportacaoSIMAM> erros) {
        if (estornoInscricao.isDuplicado()) {
            String message = "O conjunto (nrEstorno e nrAnoEstorno) declarado na  tabela (EstornoInscricaoDividaAtiva) apresenta-se com registro duplicado.";
            Long codigoDoErro = 1368L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSequenciaValida(EstornoInscricaoDividaAtivaValidacao estornoInscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!estornoInscricao.isSequenciaValida()) {
            String message = "O N\u00famero e Ano do Estorno (nrEstorno e nrAnoEstorno) declarados na  tabela (EstornoInscricaoDividaAtiva) n\u00e3o pode apresentar quebra da ordem sequencial no ano de trabalho.";
            Long codigoDoErro = 1369L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeEstornoTemDividaVinculada(EstornoInscricaoDividaAtivaValidacao estornoInscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!estornoInscricao.temDividaVinculada()) {
            String message = "A combina\u00e7\u00e3o (nrDivida e nrAnoDivida) declarada na tabela (EstornoInscricaoDividaAtiva) n\u00e3o existe na tabela (InscricaoDividaAtiva).";
            Long codigoDoErro = 1370L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeADividaEMunicipal(EstornoInscricaoDividaAtivaValidacao estornoInscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!estornoInscricao.isEscopoMunicipal()) {
            String message = "O Controle de Lei/Ato (cdControleLeiAto) declarado na tabela (EstornoInscricaoDividaAtiva) n\u00e3o existe na tabela (LeiAto) com (idEscopo) = 22.";
            Long codigoDoErro = 1371L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeADataDoEstornoEMaiorQueInscricaoEMenorQueADataDeProcessamento(EstornoInscricaoDividaAtivaValidacao estornoInscricao, LocalDate dataProcessamento, List<ErrosImportacaoSIMAM> erros) {
        if (!estornoInscricao.isDataEstornoCorreto(dataProcessamento)) {
            String message = "A data do Estorno da Inscri\u00e7\u00e3o em D\u00edvida Ativa (dtEstorno) declarada na tabela (EstornoInscricaoDividaAtiva) n\u00e3o pode ser menor que (dtInscricao) informada na tabela (InscricaoDividaAtiva), bem como n\u00e3o pode ser maior que o m\u00eas/ano de trabalho.";
            Long codigoDoErro = 1372L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeOValorDoEstornoEPositivo(EstornoInscricaoDividaAtivaValidacao estornoInscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!estornoInscricao.isValorPositivo()) {
            String message = "O valor do Estorno da Inscri\u00e7\u00e3o em D\u00edvida Ativa (vlEstorno) declarado na tabela (EstornoInscricaoDividaAtiva) n\u00e3o pode ser negativo.";
            Long codigoDoErro = 1373L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeMotivoTemMaisDeVinteCaracteres(EstornoInscricaoDividaAtivaValidacao estornoInscricao, List<ErrosImportacaoSIMAM> erros) {
        if (!estornoInscricao.isMotivoMaiorQueVinteCaracteres()) {
            String message = "A descri\u00e7\u00e3o do motivo do Estorno da Inscri\u00e7\u00e3o em D\u00edvida Ativa (dsMotivo) declarada na tabela (EstornoInscricaoDividaAtiva) deve possuir no m\u00ednimo 20 (vinte) caracteres.";
            Long codigoDoErro = 1374L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeTemEstornoRepetidoParaUmaMesmaInscricao(EstornoInscricaoDividaAtivaValidacao estornoInscricao, List<ErrosImportacaoSIMAM> erros) {
        if (estornoInscricao.existeEstornoRepetidoParaAInscricao()) {
            String message = "O registro declarado na tabela (EstornoInscricaoDividaAtiva) para o conjunto (nrAnoEstorno, nrDivida, nrAnoDivida, cdControleLeiAto, dtEstorno e m\u00eas da remessa) n\u00e3o pode ser duplicado.";
            Long codigoDoErro = 2237L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }

    private void validaSeEstornoEDeDividaAtual(EstornoInscricaoDividaAtivaValidacao estornoInscricao, LocalDate dataProcessamento, List<ErrosImportacaoSIMAM> erros) {
        if (!estornoInscricao.isEstornoDeUmaInscricaoComDividaDoMesmoAnoDoProcessamento(dataProcessamento)) {
            String message = "O registro declarado na tabela (EstornoInscricaoDividaAtiva) n\u00e3o pode estar vinculado com ano de d\u00edvida (nrAnoDivida) menor que o exerc\u00edcio financeiro de " + dataProcessamento.getYear() + ".";
            Long codigoDoErro = 2248L;
            erros.add(ErrosImportacaoSIMAM.estornoInscricaoDividaAtiva((EstornoInscricaoDividaAtivaValidacao)estornoInscricao, (String)message, (Long)codigoDoErro));
        }
    }
}

