/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.rastreamento;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.fluent.ReportDatasource;
import br.com.elotech.fluent.dataset.loader.DatasetLoader;
import br.com.elotech.fluent.dataset.loader.DatasetLoaders;
import br.com.elotech.fluent.dataset.loader.ReportDataLoader;
import br.com.elotech.fluent.param.Param;
import br.com.elotech.fluent.param.ParamLoader;
import br.com.elotech.report.EloReportFactory;
import br.com.elotech.report.file.ReportFileResolverFactory;
import br.com.elotech.tributos.config.HttpEntityFactory;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoConsultaDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import br.com.elotech.tributos.dto.SituacaoCadastroImobiliarioDTO;
import br.com.elotech.tributos.dto.SituacaoCadastroMobiliarioDTO;
import br.com.elotech.tributos.dto.rastreamento.RastreamentoCadastroImpressaoDTO;
import br.com.elotech.tributos.enums.TipoSituacaoDebitoFintel;
import br.com.elotech.tributos.report.loader.RastreamentoCadastralParamLoader;
import br.com.elotech.tributos.repository.ProprietarioRepository;
import br.com.elotech.tributos.repository.RastreamentoMaringaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.PessoaService;
import br.com.elotech.tributos.service.exception.CadastroNaoEncontradoException;
import br.com.elotech.tributos.service.exception.PessoaNotFoundException;
import br.com.elotech.tributos.service.exception.RastreamentoException;
import br.com.elotech.tributos.service.rastreamento.RastreamentoServiceInterface;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.temporal.TemporalAdjusters;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.core.ParameterizedTypeReference;
import org.springframework.http.HttpMethod;
import org.springframework.stereotype.Service;
import org.springframework.web.client.RestTemplate;

@Service
@Qualifier(value="rastreamentoMaringa")
public class RastreamentoMaringaService
implements RastreamentoServiceInterface<RastreamentoConsultaDTO> {
    private static final Logger LOGGER = LoggerFactory.getLogger(RastreamentoMaringaService.class);
    private final CadastroGeralService cadastroGeralService;
    private final PessoaService pessoaService;
    private final RastreamentoMaringaRepository rastreamentoMaringaRepository;
    private final ParametroGeralService parametroGeralService;
    private final DiaUtilService diaUtilService;
    private final RestTemplate restTemplate;
    private final ProprietarioRepository proprietarioRepository;
    private final RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader;
    private final ReportFileResolverFactory reportFileResolverFactory;
    private final ObjectMapper objectMapper;

    public RastreamentoMaringaService(CadastroGeralService cadastroGeralService, RastreamentoMaringaRepository rastreamentoMaringaRepository, ParametroGeralService parametroGeralService, PessoaService pessoaService, DiaUtilService diaUtilService, RestTemplate restTemplate, ProprietarioRepository proprietarioRepository, RastreamentoCadastralParamLoader rastreamentoCadastralParamLoader, ReportFileResolverFactory reportFileResolverFactory, ObjectMapper objectMapper) {
        this.cadastroGeralService = cadastroGeralService;
        this.rastreamentoMaringaRepository = rastreamentoMaringaRepository;
        this.parametroGeralService = parametroGeralService;
        this.pessoaService = pessoaService;
        this.diaUtilService = diaUtilService;
        this.restTemplate = restTemplate;
        this.proprietarioRepository = proprietarioRepository;
        this.rastreamentoCadastralParamLoader = rastreamentoCadastralParamLoader;
        this.reportFileResolverFactory = reportFileResolverFactory;
        this.objectMapper = objectMapper;
    }

    public byte[] imprimirRastreamento(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) {
        List rastreamentoCadastroImpressaoDTOS = this.getRastreamentoCadastroImpressaoDTOS(rastreamentos, isDetalhado);
        DatasetLoader mainDatasetLoader = DatasetLoaders.fromRecords((List)rastreamentoCadastroImpressaoDTOS, RastreamentoCadastroImpressaoDTO.class);
        ReportDatasource datasource = ReportDatasource.builder().add("main", (ReportDataLoader)mainDatasetLoader).params((ParamLoader)this.rastreamentoCadastralParamLoader).param(Param.of((String)"USUARIO", (Object)SecurityUtils.getUserAise())).build();
        return EloReportFactory.jasper().reportFile(this.reportFileResolverFactory.fromFile("rastreamento-debitos-detalhado.jrxml")).setReportDatasource(datasource).setObjectMapper(this.objectMapper).build().exportToPdf();
    }

    public List<RastreamentoCadastroImpressaoDTO> getRastreamentoCadastroImpressaoDTOS(List<RastreamentoCadastroDTO> rastreamentos, Boolean isDetalhado) {
        return rastreamentos.stream().map(rc -> {
            RastreamentoCadastroImpressaoDTO rastreamentoCadastroImpressaoDTO = RastreamentoCadastroImpressaoDTO.toRastreamentoCadastroImpressaoDTO((RastreamentoCadastroDTO)rc);
            CadastroGeral cadastroGeral = (CadastroGeral)this.cadastroGeralService.findOne((Serializable)rc.getId());
            Pessoa pessoa = (Pessoa)this.pessoaService.findById(rc.getPessoa()).orElseThrow(() -> new PessoaNotFoundException());
            Optional proprietario = this.proprietarioRepository.findByPessoaAndCadastroGeral(pessoa, cadastroGeral);
            rastreamentoCadastroImpressaoDTO.preencheDadosProprietario(proprietario, cadastroGeral.getPessoa());
            if (isDetalhado.booleanValue()) {
                List debitosRastreamento = this.rastreamentoMaringaRepository.loadDebitosRastreamento(cadastroGeral.getId());
                List debitosVencidosRastreamento = debitosRastreamento.stream().filter(arg_0 -> this.checkDebitoRastreamentoVencido(arg_0)).collect(Collectors.toList());
                rastreamentoCadastroImpressaoDTO.setDebitosVencidos(debitosVencidosRastreamento);
                rastreamentoCadastroImpressaoDTO.setTotalValorDebitos(debitosVencidosRastreamento.stream().map(RastreamentoDebitoDTO::getValor).reduce(BigDecimal.ZERO, BigDecimal::add));
            }
            return rastreamentoCadastroImpressaoDTO;
        }).collect(Collectors.toList());
    }

    public Set<RastreamentoCadastroDTO> porCadastro(RastreamentoConsultaDTO param) {
        this.validarCadastro((CadastroGeral)this.cadastroGeralService.findOne((Serializable)param.getIdCadastro()));
        List proprietarios = this.rastreamentoMaringaRepository.loadRastreamentoPorCadastro(param.getIdCadastro(), this.consideraCadastroAvulso(), param.getUtilizaCorresponsavel());
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        return this.calculaSituacoesCadastro(cadastros);
    }

    public Set<RastreamentoCadastroDTO> porContribuinte(RastreamentoConsultaDTO param) {
        Pessoa pessoa = this.pessoaService.findOne(param.getIdContribuinte());
        this.validarPessoa(pessoa);
        Boolean consideraCnpjRaiz = this.consideraCnpjRaiz();
        Boolean consideraCadastroAvulso = this.consideraCadastroAvulso();
        Boolean consideraSocios = this.consideraSocios();
        List proprietarios = this.rastreamentoMaringaRepository.loadRastreamentoPorCpfCnpj(pessoa.getCnpjCpf(), consideraCadastroAvulso, consideraCnpjRaiz, param.getUtilizaCorresponsavel());
        Set cadastros = RastreamentoCadastroDTO.agruparPorCadastro((List)proprietarios);
        if (consideraSocios.booleanValue()) {
            cadastros.forEach(cadastro -> {
                List socios = this.rastreamentoMaringaRepository.buscaSocios(cadastro.getId());
                socios.forEach(socio -> {
                    Set cadastrosSocios = this.rastreamentoMaringaRepository.loadRastreamentoCadastrosSocios(socio.getCpfCnpj(), consideraCnpjRaiz, consideraCadastroAvulso);
                    socio.setCadastrosVinculados(cadastrosSocios.stream().filter(cadastroSocios -> !cadastroSocios.getId().equals(cadastro.getId())).collect(Collectors.toList()));
                });
                cadastro.getProprietarios().addAll(socios);
            });
            cadastros.addAll(this.rastreamentoMaringaRepository.loadRastreamentoCadastrosSocios(pessoa.getCnpjCpf(), consideraCnpjRaiz, consideraCadastroAvulso));
        }
        return this.calculaSituacoesCadastro(cadastros);
    }

    private Set<RastreamentoCadastroDTO> calculaSituacoesCadastro(Set<RastreamentoCadastroDTO> cadastros) {
        Boolean parametroConsideraContencioso = this.consideraContencioso();
        HashMap mapCadastros = new HashMap();
        HashMap cnpjsConsultadosFintel = new HashMap();
        cadastros.forEach(cadastro -> {
            this.atualizaSituacoesCadastro(mapCadastros, cnpjsConsultadosFintel, cadastro, parametroConsideraContencioso);
            cadastro.getProprietarios().forEach(proprietario -> {
                if (Objects.nonNull(proprietario.getCadastrosVinculados())) {
                    proprietario.getCadastrosVinculados().forEach(cadastroVinculado -> this.atualizaSituacoesCadastro(mapCadastros, cnpjsConsultadosFintel, cadastroVinculado, parametroConsideraContencioso));
                }
            });
        });
        return cadastros;
    }

    private void atualizaSituacoesCadastro(Map<Long, RastreamentoCadastroDTO> mapCadastros, Map<String, String> cnpjsConsultadosFintel, RastreamentoCadastroDTO cadastro, Boolean parametroConsideraContencioso) {
        RastreamentoCadastroDTO cadastroMapeado = mapCadastros.computeIfAbsent(cadastro.getId(), c -> this.buscaDebitos(cadastro, parametroConsideraContencioso));
        cadastro.setSituacao(this.getStringDescricao(cadastroMapeado));
        cadastro.setDebitos(cadastroMapeado.getDebitos());
        cadastro.setTipoCertidaoDebitos(cadastroMapeado.getTipoCertidaoDebitos());
        cadastro.setSituacaoSGO(this.getSituacaoFintel(cnpjsConsultadosFintel, cadastroMapeado));
    }

    private String getSituacaoFintel(Map<String, String> cnpjsConsultadosFintel, RastreamentoCadastroDTO cadastroMapeado) {
        String situacaoFintel;
        if (cnpjsConsultadosFintel.containsKey(cadastroMapeado.getCpfCnpj())) {
            return cnpjsConsultadosFintel.get(cadastroMapeado.getCpfCnpj());
        }
        if (TipoCadastro.IMOBILIARIO.getValue().equals(cadastroMapeado.getTipoCadastro())) {
            String situacaoFintel2 = TipoSituacaoDebitoFintel.OK.getDescricao();
            cnpjsConsultadosFintel.put(cadastroMapeado.getCpfCnpj(), situacaoFintel2);
            return situacaoFintel2;
        }
        String urlSgo = this.consideraUrlSgo();
        if ("".equals(urlSgo) || Objects.isNull(urlSgo)) {
            String situacaoFintel3 = TipoSituacaoDebitoFintel.URL_NAO_CONFIGURADA.getDescricao();
            cnpjsConsultadosFintel.put(cadastroMapeado.getCpfCnpj(), situacaoFintel3);
            return situacaoFintel3;
        }
        String urlCompleta = String.format(urlSgo.concat("/%s"), cadastroMapeado.getCpfCnpj());
        String situacao = null;
        try {
            situacao = (String)this.restTemplate.exchange(urlCompleta, HttpMethod.GET, HttpEntityFactory.createJsonHttpEntityWithoutEntity(), (ParameterizedTypeReference)new /* Unavailable Anonymous Inner Class!! */, new Object[0]).getBody();
        }
        catch (Exception ex) {
            String message = String.format("Erro ao consultar a situacao na Fintel para o CNPJ %s", cadastroMapeado.getCpfCnpj());
            LOGGER.error("{} - {}", new Object[]{message, ex.getMessage(), ex});
            return TipoSituacaoDebitoFintel.VAZIO.getDescricao();
        }
        if (Objects.isNull(situacao) || "".equals(situacao) || "N".equals(situacao)) {
            situacaoFintel = TipoSituacaoDebitoFintel.OK.getDescricao();
        } else if ("X".equals(situacao)) {
            situacaoFintel = TipoSituacaoDebitoFintel.POSITIVA_NEGATIVA.getDescricao();
            if (!TipoCadastro.MOBILIARIO.getValue().equals(cadastroMapeado.getTipoCadastro())) {
                situacaoFintel = TipoSituacaoDebitoFintel.VAZIO.getDescricao();
            }
        } else if ("Y".equals(situacao)) {
            situacaoFintel = TipoSituacaoDebitoFintel.ISS_VENCIDO.getDescricao();
        } else {
            situacaoFintel = TipoSituacaoDebitoFintel.OCORRENCIA.getDescricao();
            if (!TipoCadastro.MOBILIARIO.getValue().equals(cadastroMapeado.getTipoCadastro())) {
                situacaoFintel = TipoSituacaoDebitoFintel.VAZIO.getDescricao();
            }
        }
        cnpjsConsultadosFintel.put(cadastroMapeado.getCpfCnpj(), situacaoFintel);
        return situacaoFintel;
    }

    private String getStringDescricao(RastreamentoCadastroDTO cadastroMapeado) {
        if (TipoCadastro.IMOBILIARIO.getValue().equals(cadastroMapeado.getTipoCadastro())) {
            return this.getSituacaoDescricaoImobiliario(cadastroMapeado);
        }
        if (TipoCadastro.MOBILIARIO.getValue().equals(cadastroMapeado.getTipoCadastro())) {
            return this.getSituacaoDescricaoMobiliario(cadastroMapeado);
        }
        return null;
    }

    private String getSituacaoDescricaoMobiliario(RastreamentoCadastroDTO cadastroMapeado) {
        List situacaoCadastroSegmentoDTOS = this.rastreamentoMaringaRepository.loadSituacaoCadastroMobiliario(cadastroMapeado.getId());
        if (Objects.nonNull(situacaoCadastroSegmentoDTOS) && !situacaoCadastroSegmentoDTOS.isEmpty()) {
            String descricaoMobiliario = situacaoCadastroSegmentoDTOS.stream().map(SituacaoCadastroMobiliarioDTO::getSituacaoDescricao).collect(Collectors.joining("/"));
            if (situacaoCadastroSegmentoDTOS.stream().anyMatch(SituacaoCadastroMobiliarioDTO::isPessoaMobiliarioAvulso)) {
                descricaoMobiliario = descricaoMobiliario.concat("(AVULSO)");
            }
            return descricaoMobiliario;
        }
        return "OK";
    }

    private String getSituacaoDescricaoImobiliario(RastreamentoCadastroDTO cadastroMapeado) {
        List situacaoCadastroSegmentoDTOS = this.rastreamentoMaringaRepository.loadSituacaoCadastroImobiliario(cadastroMapeado.getId());
        if (Objects.nonNull(situacaoCadastroSegmentoDTOS) && !situacaoCadastroSegmentoDTOS.isEmpty()) {
            return situacaoCadastroSegmentoDTOS.stream().map(SituacaoCadastroImobiliarioDTO::getSituacaoDescricao).collect(Collectors.joining("/"));
        }
        return "OK";
    }

    private RastreamentoCadastroDTO buscaDebitos(RastreamentoCadastroDTO cadastro, Boolean parametroConsideraContencioso) {
        cadastro.setDebitos(this.rastreamentoMaringaRepository.loadDebitosRastreamento(cadastro.getId()));
        this.calculaSituacaoDebitos(cadastro, parametroConsideraContencioso);
        return cadastro;
    }

    private void calculaSituacaoDebitos(RastreamentoCadastroDTO cadastro, Boolean parametroConsideraContencioso) {
        List debitos = cadastro.getDebitos();
        if (Objects.nonNull(debitos)) {
            boolean hasValorVencido = debitos.stream().anyMatch(arg_0 -> this.checkDebitoRastreamentoVencido(arg_0));
            boolean hasValorAVencer = debitos.stream().anyMatch(arg_0 -> this.checkDebitoRastreamentoAVencer(arg_0));
            boolean todosDebitosVencidosTemContencioso = debitos.stream().filter(debito -> debito.getVencido() != false && BigDecimal.ZERO.compareTo(debito.getValor()) < 0).map(RastreamentoDebitoDTO::getIdContencioso).allMatch(Objects::nonNull);
            if (hasValorVencido) {
                cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA);
                if (parametroConsideraContencioso.booleanValue() && todosDebitosVencidosTemContencioso) {
                    cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA);
                }
            } else if (!hasValorAVencer) {
                cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.NEGATIVA);
            } else {
                cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.POSITIVA_EFEITO_NEGATIVA);
            }
        } else {
            cadastro.setTipoCertidaoDebitos(TipoCertidaoDebitos.NEGATIVA);
        }
    }

    private boolean checkDebitoRastreamentoAVencer(RastreamentoDebitoDTO debito) {
        debito.setDataVencimento(this.diaUtilService.validateDiaUtil(debito.getDataVencimento()));
        debito.setDataVencimentoCotaUnica(Objects.nonNull(debito.getDataVencimentoCotaUnica()) ? debito.getDataVencimentoCotaUnica() : LocalDate.now().with(TemporalAdjusters.firstDayOfYear()));
        return BigDecimal.ZERO.compareTo(debito.getValor()) < 0 && (debito.getAVencer() != false || debito.getVencido() != false && debito.isVencidoCotaUnica() == false);
    }

    private boolean checkDebitoRastreamentoVencido(RastreamentoDebitoDTO debito) {
        debito.setDataVencimento(this.diaUtilService.validateDiaUtil(debito.getDataVencimento()));
        debito.setDataVencimentoCotaUnica(Objects.nonNull(debito.getDataVencimentoCotaUnica()) ? debito.getDataVencimentoCotaUnica() : LocalDate.now().with(TemporalAdjusters.firstDayOfYear()));
        return BigDecimal.ZERO.compareTo(debito.getValor()) < 0 && debito.getVencido() != false && debito.isVencidoCotaUnica() != false;
    }

    private Boolean emiteCertidaoCadastroMobiliario() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.EMITE_CERTIDAO_CAD_MOBILIARIO);
    }

    private void validarCadastro(CadastroGeral cadastro) {
        if (Objects.isNull(cadastro)) {
            throw new CadastroNaoEncontradoException();
        }
        if (TipoCadastro.MOBILIARIO.equals((Object)cadastro.getTipoCadastro()) && !this.emiteCertidaoCadastroMobiliario().booleanValue()) {
            throw RastreamentoException.tipoCadastroInvalido();
        }
    }

    private void validarPessoa(Pessoa pessoa) {
        if (Objects.isNull(pessoa)) {
            throw new PessoaNotFoundException();
        }
    }

    private Boolean consideraCadastroAvulso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_AVULSO_RASTREAMENTO);
    }

    private Boolean consideraCnpjRaiz() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CNPJ_RAIZ_RASTREAMENTO);
    }

    private Boolean consideraSocios() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.VERIFICA_SOCIO_RASTREAMENTO);
    }

    private Boolean consideraContencioso() {
        return this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.CONSIDERA_CONTENCIOSO_CND);
    }

    private String consideraUrlSgo() {
        return this.parametroGeralService.getParamValueAsString(ParametroGeralEnum.URL_SGO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
    }
}

