/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.projeto;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.jpa.support.EloSequenceCache;
import br.com.elotech.core.jpa.support.EloSequenceGenerator;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.projeto.Projeto;
import br.com.elotech.tributos.domain.projeto.ProjetoDebito;
import br.com.elotech.tributos.domain.projeto.ProjetoPK;
import br.com.elotech.tributos.domain.projeto.ProjetoResponsavelPK;
import br.com.elotech.tributos.domain.projeto.TipoObra;
import br.com.elotech.tributos.domain.projeto.TipoProjeto;
import br.com.elotech.tributos.dto.DebitoCarneDTO;
import br.com.elotech.tributos.dto.DebitoIdDTO;
import br.com.elotech.tributos.dto.DebitoManualDTO;
import br.com.elotech.tributos.dto.DebitoManualObservacaoDTO;
import br.com.elotech.tributos.dto.DebitoManualParcelaDTO;
import br.com.elotech.tributos.dto.DebitoManualTributoDTO;
import br.com.elotech.tributos.dto.DebitoProjetoManualDTO;
import br.com.elotech.tributos.dto.EnderecoResumidoResponse;
import br.com.elotech.tributos.dto.GerarParcelasDebitoDTO;
import br.com.elotech.tributos.dto.ImpressaoDTO;
import br.com.elotech.tributos.dto.IntegracaoProjetoIssResponse;
import br.com.elotech.tributos.dto.PessoaDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoDTO;
import br.com.elotech.tributos.dto.projeto.ProjetoRowDTO;
import br.com.elotech.tributos.repository.projeto.ProjetoRepository;
import br.com.elotech.tributos.service.CarneService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.DebitoCarneService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraDebitoService;
import br.com.elotech.tributos.service.exception.projeto.ProjetoNotFoundException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.AgrupaDebitos;
import java.io.Serializable;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Collectors;
import lombok.Generated;
import org.hibernate.SessionFactory;
import org.hibernate.engine.spi.SessionFactoryImplementor;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.security.core.Authentication;
import org.springframework.stereotype.Service;

@Service
public class ProjetoService
extends CrudService<Projeto, ProjetoPK> {
    private final ContextService contextService;
    private final EloSequenceCache eloSequenceCache;
    private final ProjetoRepository projetoRepository;
    private final GeraDebitoService geraDebitoService;
    private final DebitoService debitoService;
    private final DebitoCarneService debitoCarneService;
    private final AisePdfService aisePdfService;
    private final CarneService carneService;
    private static final BigDecimal CEM_PORCENTO = BigDecimal.valueOf(100L);

    protected void beforeSave(Projeto projeto, Authentication authentication) {
        super.beforeSave((EloEntity)projeto, authentication);
        if (Objects.isNull(projeto.getId())) {
            ProjetoPK projetoPK = new ProjetoPK();
            projetoPK.setEntidade(this.contextService.getEntidadePrincipal());
            projetoPK.setExercicio(this.contextService.getExercicioAtual());
            projeto.setId(projetoPK);
            EloSequenceGenerator.attrNextValues((Object)projeto, (SessionFactory)((SessionFactory)this.getEm().getEntityManagerFactory().unwrap(SessionFactoryImplementor.class)), (EloSequenceCache)this.eloSequenceCache);
        }
        projeto.getItens().forEach(item -> {
            if (Objects.isNull(item.getProjeto())) {
                item.setProjeto(projeto);
            }
        });
        AtomicLong sequencia = new AtomicLong(projeto.getNextSequenciaResponsavel());
        projeto.getResponsaveis().forEach(responsavel -> {
            if (Objects.isNull(responsavel.getId())) {
                ProjetoResponsavelPK projetoResponsavelPK = new ProjetoResponsavelPK();
                projetoResponsavelPK.setEntidade(projeto.getId().getEntidade());
                projetoResponsavelPK.setExercicio(projeto.getId().getExercicio());
                projetoResponsavelPK.setProjeto(projeto.getId().getProjeto());
                projetoResponsavelPK.setSequencia(Long.valueOf(sequencia.getAndIncrement()));
                responsavel.setId(projetoResponsavelPK);
                responsavel.setProjeto(projeto);
            }
        });
        projeto.getObservacoes().forEach(observacao -> {
            if (Objects.isNull(observacao.getProjeto())) {
                observacao.setProjeto(projeto);
            }
        });
    }

    public Page<ProjetoRowDTO> findByRsqlProjetoRowDTOS(String search, Pageable pageable) {
        Page projetos = this.findByRsql(search, pageable);
        return projetos.map(ProjetoRowDTO::from);
    }

    public ProjetoDTO findOneProjetoDTO(ProjetoPK id) {
        return this.findById((Serializable)id).map(ProjetoDTO::from).orElseThrow(() -> new ProjetoNotFoundException(id));
    }

    public List<IntegracaoProjetoIssResponse> findProjetoIntegracao(Long idProcesso, Long exercicio) {
        List projetos = this.projetoRepository.findAllProjetosIntegradosByProcessoAndExercicio(idProcesso, exercicio);
        return projetos.stream().map(arg_0 -> this.mapIntegracaoProjetoIssResponse(arg_0)).collect(Collectors.toList());
    }

    public IntegracaoProjetoIssResponse mapIntegracaoProjetoIssResponse(Projeto projeto) {
        IntegracaoProjetoIssResponse response = new IntegracaoProjetoIssResponse();
        response.setResponsavel(this.setResponsavel(projeto));
        response.setEndereco(this.setEndereco(projeto));
        response.setArt(projeto.getArt());
        response.setExercicio(projeto.getId().getExercicio());
        response.setEntidade(projeto.getId().getEntidade());
        response.setProjeto(projeto.getId().getProjeto());
        response.setOpcaoPagamento(projeto.getOpcaoPagamento().getCodigo());
        return response;
    }

    private PessoaDTO setResponsavel(Projeto projeto) {
        PessoaDTO responsavel = new PessoaDTO();
        responsavel.setNome(projeto.getResponsavel().getNome());
        responsavel.setCnpjCpf(projeto.getResponsavel().getCnpjCpf());
        return responsavel;
    }

    private EnderecoResumidoResponse setEndereco(Projeto projeto) {
        EnderecoResumidoResponse endereco = new EnderecoResumidoResponse();
        CadastroGeral cadastroGeral = projeto.getCadastroGeral();
        endereco.setCep(cadastroGeral.getCep());
        endereco.setNumero(cadastroGeral.getNumero());
        endereco.setComplemento(cadastroGeral.getComplemento());
        Optional.of(cadastroGeral.getBairro()).ifPresent(bairro -> endereco.setBairro(bairro.getDescricao()));
        Optional.of(cadastroGeral.getCidade()).ifPresent(cidade -> {
            endereco.setCidade(cidade.getDescricao());
            endereco.setUnidadeFederacao(cidade.getUnidadeFederacao());
        });
        Optional.of(cadastroGeral.getLogradouro()).ifPresent(logradouro -> {
            endereco.setLogradouro(logradouro.getDescricao());
            Optional.of(logradouro.getTipoLogradouro()).ifPresent(tipo -> endereco.setTipoLogradouro(tipo.getDescricao()));
        });
        return endereco;
    }

    public void validateTipoObra(Projeto projeto) {
        if (projeto.getTipoObra() == null) {
            throw new EloValidationException(String.format("N\u00e3o existe um tipo de obra para o projeto %d do exerc\u00edcio %d. Fa\u00e7a o cadastro para continuar.", projeto.getId().getProjeto(), projeto.getId().getExercicio()));
        }
    }

    public void validateArea(Projeto projeto) {
        if (projeto.getArea() == null || projeto.getArea().compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException(String.format("A \u00e1rea do projeto %d do exerc\u00edcio %d \u00e9 inv\u00e1lida. Verifique o cadastro.", projeto.getId().getProjeto(), projeto.getId().getExercicio()));
        }
    }

    public void validateValorTributo(BigDecimal valorTributo) {
        if (valorTributo.compareTo(BigDecimal.ZERO) <= 0) {
            throw new EloValidationException("O valor do tributo deve ser maior que zero!");
        }
    }

    public List<DebitoManualParcelaDTO> simulateDebitoManual(DebitoProjetoManualDTO debitoProjetoManualDTO) {
        Projeto projeto = (Projeto)this.findOne((Serializable)ProjetoPK.from((Long)this.contextService.getEntidadePrincipal(), (Long)debitoProjetoManualDTO.getExercicio(), (Long)debitoProjetoManualDTO.getProjeto()));
        this.validateTipoObra(projeto);
        this.validateArea(projeto);
        BigDecimal valorTributo = this.calculateValorTributo(projeto.getTipoObra(), projeto.getArea());
        this.validateValorTributo(valorTributo);
        List debitoManualTributoDTOS = this.buildDebitoManualTributoDTO(debitoProjetoManualDTO.getTributo().getTributo(), valorTributo);
        GerarParcelasDebitoDTO gerarParcelasDebitoDTO = this.buildGerarParcelasDebitoDTO(debitoManualTributoDTOS, debitoProjetoManualDTO, projeto.getTipoProjeto());
        return this.gerarParcelas(gerarParcelasDebitoDTO);
    }

    public DebitoIdDTO generateDebitoManual(DebitoProjetoManualDTO debitoProjetoManualDTO) {
        Projeto projeto = (Projeto)this.findOne((Serializable)ProjetoPK.from((Long)this.contextService.getEntidadePrincipal(), (Long)debitoProjetoManualDTO.getExercicio(), (Long)debitoProjetoManualDTO.getProjeto()));
        this.validateTipoObra(projeto);
        this.validateArea(projeto);
        BigDecimal valorTributo = this.calculateValorTributo(projeto.getTipoObra(), projeto.getArea());
        this.validateValorTributo(valorTributo);
        List debitoManualTributoDTOS = this.buildDebitoManualTributoDTO(debitoProjetoManualDTO.getTributo().getTributo(), valorTributo);
        GerarParcelasDebitoDTO gerarParcelasDebitoDTO = this.buildGerarParcelasDebitoDTO(debitoManualTributoDTOS, debitoProjetoManualDTO, projeto.getTipoProjeto());
        List debitoManualParcelaDTOS = this.gerarParcelas(gerarParcelasDebitoDTO);
        DebitoManualObservacaoDTO debitoManualObservacaoDTO = this.buildDebitoManualObservacaoDTO(projeto);
        DebitoManualDTO debitoManualDTO = DebitoManualDTO.from((DebitoProjetoManualDTO)debitoProjetoManualDTO, (List)debitoManualParcelaDTOS, (List)debitoManualTributoDTOS, (DebitoManualObservacaoDTO)debitoManualObservacaoDTO, (TipoProjeto)projeto.getTipoProjeto());
        DebitoIdDTO debitoIdDTO = this.geraDebitoService.geraDebitoManual(debitoManualDTO);
        ProjetoDebito projetoDebito = this.buildProjetoDebito(projeto, debitoIdDTO);
        projeto.getDebitos().add(projetoDebito);
        this.projetoRepository.save((Object)projeto);
        return debitoIdDTO;
    }

    public ProjetoDebito buildProjetoDebito(Projeto projeto, DebitoIdDTO debitoIdDTO) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
        ProjetoDebito projetoDebito = new ProjetoDebito();
        projetoDebito.setDebito(debito);
        projetoDebito.setProjeto(projeto);
        projetoDebito.setExercicioDebito(debito.getExercicio());
        projetoDebito.setTipoCadastro(debito.getTipoCadastro());
        projetoDebito.setCadastroGeral(debito.getCadastroGeralId());
        projetoDebito.setDivida(debito.getGuiaRecolhimento());
        projetoDebito.setSubDivida(debito.getSubDivida());
        return projetoDebito;
    }

    public List<DebitoManualTributoDTO> buildDebitoManualTributoDTO(String tributo, BigDecimal valorTributo) {
        DebitoManualTributoDTO tributoDTO = new DebitoManualTributoDTO();
        tributoDTO.setTributo(tributo);
        tributoDTO.setValorTributo(valorTributo);
        ArrayList<DebitoManualTributoDTO> tributoDTOS = new ArrayList<DebitoManualTributoDTO>();
        tributoDTOS.add(tributoDTO);
        return tributoDTOS;
    }

    public GerarParcelasDebitoDTO buildGerarParcelasDebitoDTO(List<DebitoManualTributoDTO> tributoDTOS, DebitoProjetoManualDTO debitoProjetoManualDTO, TipoProjeto tipoProjeto) {
        GerarParcelasDebitoDTO gerarParcelasDebitoDTO = new GerarParcelasDebitoDTO();
        gerarParcelasDebitoDTO.setParcelaInicial(Long.valueOf(1L));
        gerarParcelasDebitoDTO.setQuantidadeParcelas(debitoProjetoManualDTO.getNumeroParcelas());
        gerarParcelasDebitoDTO.setDataVencimentoInicial(debitoProjetoManualDTO.getDataVencimento());
        gerarParcelasDebitoDTO.setTributos(tributoDTOS);
        gerarParcelasDebitoDTO.setPercentualEntrada(Objects.nonNull(tipoProjeto) ? tipoProjeto.getPercentualDeEntrada() : BigDecimal.ZERO);
        return gerarParcelasDebitoDTO;
    }

    public DebitoManualObservacaoDTO buildDebitoManualObservacaoDTO(Projeto projeto) {
        return DebitoManualObservacaoDTO.of((String)String.format("D\u00e9bito gerado pelo projeto %d/%d", projeto.getId().getProjeto(), projeto.getId().getExercicio()));
    }

    public BigDecimal calculateValorTributo(TipoObra tipoObra, BigDecimal area) {
        BigDecimal baseCalculo = tipoObra.getBaseCalculo().divide(CEM_PORCENTO, 4, RoundingMode.HALF_EVEN);
        BigDecimal custoBasico = tipoObra.getCustoBasico();
        BigDecimal aliquota = tipoObra.getAliquota().divide(CEM_PORCENTO, 4, RoundingMode.HALF_EVEN);
        return area.multiply(baseCalculo).multiply(custoBasico).multiply(aliquota).setScale(2, RoundingMode.HALF_EVEN);
    }

    public ImpressaoDTO geraCarneDebitoProjeto(DebitoIdDTO debitoIdDTO) {
        DebitoCarneDTO debitoCarneDTO = this.getDebitoCarneComFormasPagamento(debitoIdDTO);
        return ImpressaoDTO.from((String)this.aisePdfService.fetchCarne(this.carneService.geraCarne(debitoCarneDTO).getNumeroCarne()));
    }

    public DebitoCarneDTO getDebitoCarneComFormasPagamento(DebitoIdDTO debitoIdDTO) {
        Debito debito = (Debito)this.debitoService.findOne((Serializable)debitoIdDTO.getIdDebito());
        DebitoCarneDTO debitoCarneDTO = DebitoCarneDTO.from((Debito)debito);
        List formasPagamento = this.debitoCarneService.findAllDebitoAgrupadoPorFormaPagamentoDisponivelWeb(debitoCarneDTO.getIdDebito());
        debitoCarneDTO.setFormasPagamento(AgrupaDebitos.agrupaDebitosPorDebitoEFormaPagamento((List)formasPagamento));
        return debitoCarneDTO;
    }

    private List<DebitoManualParcelaDTO> gerarParcelas(GerarParcelasDebitoDTO gerarParcelasDebitoDTO) {
        if (gerarParcelasDebitoDTO.getPercentualEntrada().compareTo(BigDecimal.ZERO) > 0 && gerarParcelasDebitoDTO.getQuantidadeParcelas().intValue() - 1 > 0) {
            return this.geraDebitoService.gerarParcelasComPercentualDeEntrada(gerarParcelasDebitoDTO);
        }
        return this.geraDebitoService.gerarParcelas(gerarParcelasDebitoDTO);
    }

    @Generated
    public ProjetoService(ContextService contextService, EloSequenceCache eloSequenceCache, ProjetoRepository projetoRepository, GeraDebitoService geraDebitoService, DebitoService debitoService, DebitoCarneService debitoCarneService, AisePdfService aisePdfService, CarneService carneService) {
        this.contextService = contextService;
        this.eloSequenceCache = eloSequenceCache;
        this.projetoRepository = projetoRepository;
        this.geraDebitoService = geraDebitoService;
        this.debitoService = debitoService;
        this.debitoCarneService = debitoCarneService;
        this.aisePdfService = aisePdfService;
        this.carneService = carneService;
    }
}

