/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogeomais;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralExistsElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralPostElogeoDTO;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroRuralService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.service.integracaogeomais.CadastroRuralElogeo;
import br.com.elotech.tributos.service.integracaogeomais.CadastroRuralElogeoService;
import br.com.elotech.tributos.util.EloRequireNonNull;
import java.io.Serializable;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public abstract class CadastroRuralElogeoServiceAbstract
implements CadastroRuralElogeo {
    private static final Logger LOGGER = LoggerFactory.getLogger(CadastroRuralElogeoService.class);
    protected final CadastroGeralService cadastroGeralService;
    protected final CadastroRuralService cadastroRuralService;
    protected final DistritoService distritoService;
    protected final SetorService setorService;
    protected final BairroService bairroService;
    protected final SetorQuadraService setorQuadraService;
    protected final LogradouroService logradouroService;
    protected final LoteamentoService loteamentoService;
    protected final CondominioService condominioService;

    protected abstract CadastroRuralElogeoDTO entityToGeomaisDTO(CadastroRural var1);

    protected abstract CadastroRural prepareGeomaisToSave(CadastroRural var1, Boolean var2, CadastroRuralPostElogeoDTO var3);

    protected abstract void mergeBoletins(CadastroRuralPostElogeoDTO var1, CadastroRural var2);

    public Page<CadastroRuralElogeoDTO> findAllElogeoDTO(Pageable page, String search) {
        return this.cadastroRuralService.findByRsql(search, page).map(arg_0 -> this.entityToGeomaisDTO(arg_0));
    }

    public CadastroRuralElogeoDTO findByCadastroGeralElogeoDTO(Long cadastroGeral) {
        CadastroRural cadastroRural = (CadastroRural)this.cadastroRuralService.findByCadastroGeral(cadastroGeral).orElseThrow(() -> new EloValidationException("Cadastro Rural n\u00e3o encontrado"));
        return this.entityToGeomaisDTO(cadastroRural);
    }

    public CadastroRuralExistsElogeoDTO exists(Long cadastroGeral) {
        CadastroRuralExistsElogeoDTO cadastroRural = new CadastroRuralExistsElogeoDTO();
        cadastroRural.setCadastroLocalizado(Boolean.valueOf(this.cadastroRuralService.exists(TipoCadastro.RURAL, cadastroGeral)));
        return cadastroRural;
    }

    @Transactional
    public CadastroRuralElogeoDTO saveElogeoDTO(CadastroRuralPostElogeoDTO cadastroRuralPostEloGeoDTO, Boolean novoCadastro, Long cadastroGeral) {
        LOGGER.info("In\u00edcio atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}", (Object)cadastroRuralPostEloGeoDTO.getCodigo(), (Object)cadastroRuralPostEloGeoDTO.getTipo());
        if (!novoCadastro.booleanValue() && !cadastroRuralPostEloGeoDTO.getCodigo().equals(cadastroGeral)) {
            throw new EloValidationException(String.format("C\u00f3digo do Cadastro %d diferente do Request %d.", cadastroGeral, cadastroRuralPostEloGeoDTO.getCodigo()));
        }
        cadastroRuralPostEloGeoDTO.setCodigo(this.cadastroRuralService.validateAndGetCadastroGeralSequence(cadastroRuralPostEloGeoDTO.getCodigo()));
        CadastroRural cadastroRuralToSave = cadastroRuralPostEloGeoDTO.toEntity();
        cadastroRuralToSave.setDistrito((Distrito)this.distritoService.findById((Serializable)((Object)cadastroRuralPostEloGeoDTO.getDistrito().getDistrito())).orElseThrow(() -> new EloValidationException(String.format("Distrito %s n\u00e3o localizado.", cadastroRuralPostEloGeoDTO.getDistrito().getDistrito()))));
        cadastroRuralToSave.setSetor((Setor)EloRequireNonNull.eloRequireNonNull((Object)this.setorService.findByDistritoDistritoAndSetor(cadastroRuralPostEloGeoDTO.getDistrito().getDistrito(), cadastroRuralPostEloGeoDTO.getSetor().getSetor()), (String)String.format("Setor %s n\u00e3o localizado.", cadastroRuralPostEloGeoDTO.getSetor().getSetor())));
        cadastroRuralToSave.setBairro((Bairro)this.bairroService.findByBairroAndCidadeEntidadePrincipal(cadastroRuralPostEloGeoDTO.getBairro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Bairro %s n\u00e3o localizado.", cadastroRuralPostEloGeoDTO.getBairro().getCodigo()))));
        cadastroRuralToSave.setLogradouro((Logradouro)this.logradouroService.findByLogradouroAndCidadeEntidadePrincipal(cadastroRuralPostEloGeoDTO.getLogradouro().getCodigo()).orElseThrow(() -> new EloValidationException(String.format("Logradouro %s n\u00e3o localizado.", cadastroRuralPostEloGeoDTO.getLogradouro().getCodigo()))));
        this.setProprietariosToSave(cadastroRuralPostEloGeoDTO, cadastroRuralToSave);
        CadastroRural prepared = this.prepareGeomaisToSave(cadastroRuralToSave, novoCadastro, cadastroRuralPostEloGeoDTO);
        CadastroRural saved = (CadastroRural)this.cadastroRuralService.save((EloEntity)prepared, null);
        this.mergeBoletins(cadastroRuralPostEloGeoDTO, saved);
        CadastroRuralElogeoDTO cadastroRuralEloGeoDTO = this.entityToGeomaisDTO(saved);
        LOGGER.info("Fim atualiza\u00e7\u00e3o do Cadastro Geral {}, Tipo Cadastro {}", (Object)cadastroRuralPostEloGeoDTO.getCodigo(), (Object)cadastroRuralPostEloGeoDTO.getCodigo());
        return cadastroRuralEloGeoDTO;
    }

    private void setProprietariosToSave(CadastroRuralPostElogeoDTO cadastroRuralPostEloGeoDTO, CadastroRural cadastroRuralToSave) {
        cadastroRuralPostEloGeoDTO.getProprietarios().stream().map(proprietario -> {
            Pessoa pessoa = (Pessoa)EloRequireNonNull.eloRequireNonNull((Object)((Pessoa)this.cadastroRuralService.getEm().find(Pessoa.class, (Object)proprietario.getPessoa().getId())), (String)String.format("Pessoa %s n\u00e3o localizada.", proprietario.getPessoa().getId()));
            Vinculo vinculo = (Vinculo)EloRequireNonNull.eloRequireNonNull((Object)((Vinculo)this.cadastroRuralService.getEm().find(Vinculo.class, (Object)proprietario.getVinculo().getId())), (String)String.format("V\u00ednculo %s n\u00e3o localizado.", proprietario.getVinculo().getId()));
            return proprietario.toEntity(pessoa, vinculo);
        }).forEach(cadastroRuralToSave.getProprietarios()::add);
    }

    @Generated
    public CadastroRuralElogeoServiceAbstract(CadastroGeralService cadastroGeralService, CadastroRuralService cadastroRuralService, DistritoService distritoService, SetorService setorService, BairroService bairroService, SetorQuadraService setorQuadraService, LogradouroService logradouroService, LoteamentoService loteamentoService, CondominioService condominioService) {
        this.cadastroGeralService = cadastroGeralService;
        this.cadastroRuralService = cadastroRuralService;
        this.distritoService = distritoService;
        this.setorService = setorService;
        this.bairroService = bairroService;
        this.setorQuadraService = setorQuadraService;
        this.logradouroService = logradouroService;
        this.loteamentoService = loteamentoService;
        this.condominioService = condominioService;
    }
}

