/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaogeomais;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralPostElogeoDTO;
import br.com.elotech.tributos.service.BairroService;
import br.com.elotech.tributos.service.BoletimRuralService;
import br.com.elotech.tributos.service.CadastroGeralService;
import br.com.elotech.tributos.service.CadastroRuralService;
import br.com.elotech.tributos.service.CondominioService;
import br.com.elotech.tributos.service.DistritoService;
import br.com.elotech.tributos.service.LogradouroService;
import br.com.elotech.tributos.service.LoteamentoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.SetorQuadraService;
import br.com.elotech.tributos.service.SetorService;
import br.com.elotech.tributos.service.integracaogeomais.CadastroRuralElogeoServiceAbstract;
import java.util.List;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

@Service
@Profile(value={"onpremise"})
public class AiseCadastroRuralElogeoService
extends CadastroRuralElogeoServiceAbstract {
    private final BoletimRuralService boletimRuralService;

    public AiseCadastroRuralElogeoService(CadastroGeralService cadastroGeralService, CadastroRuralService cadastroRuralService, DistritoService distritoService, SetorService setorService, BairroService bairroService, SetorQuadraService setorQuadraService, LogradouroService logradouroService, LoteamentoService loteamentoService, CondominioService condominioService, ParametroGeralService parametroGeralService, BoletimRuralService boletimRuralService) {
        super(cadastroGeralService, cadastroRuralService, distritoService, setorService, bairroService, setorQuadraService, logradouroService, loteamentoService, condominioService);
        this.boletimRuralService = boletimRuralService;
    }

    protected CadastroRuralElogeoDTO entityToGeomaisDTO(CadastroRural cadastroRural) {
        List boletimRural = this.boletimRuralService.findByIdCadastroRural(cadastroRural.getId());
        CadastroRuralElogeoDTO cadastroRuralElogeoDTO = CadastroRuralElogeoDTO.from((CadastroRural)cadastroRural, (List)boletimRural);
        return cadastroRuralElogeoDTO;
    }

    protected CadastroRural prepareGeomaisToSave(CadastroRural cadastroRuralToSave, Boolean novoCadastro, CadastroRuralPostElogeoDTO cadastroRuralPostElogeoDTO) {
        if (!novoCadastro.booleanValue() && cadastroRuralToSave.getCadastroGeral() != null) {
            CadastroRural cadastroRuralFound = (CadastroRural)this.cadastroRuralService.findByCadastroGeral(cadastroRuralToSave.getCadastroGeral()).orElseThrow(() -> new EloValidationException("Cadastro Rural n\u00e3o encontrado"));
            return cadastroRuralFound.mergeElogeo(cadastroRuralToSave);
        }
        return cadastroRuralToSave;
    }

    protected void mergeBoletins(CadastroRuralPostElogeoDTO cadastroRuralPostElogeoDTO, CadastroRural saved) {
        this.boletimRuralService.merge(cadastroRuralPostElogeoDTO.getBoletim(), saved.getId());
    }
}

