/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaocontabil;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.outbox.domain.EntityEvent;
import br.com.elotech.outbox.domain.OutboxActions;
import br.com.elotech.outbox.publisher.Publisher;
import br.com.elotech.tributos.domain.integracaocontabil.LoteIntegracaoContabil;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.domain.pagamento.PagamentoLote;
import br.com.elotech.tributos.domain.pagamento.SituacaoPagamentoLote;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincrona;
import br.com.elotech.tributos.domain.tarefaassincrona.TarefaAssincronaExecucao;
import br.com.elotech.tributos.domain.tarefaassincrona.TipoParametro;
import br.com.elotech.tributos.dto.UserSecurityDTO;
import br.com.elotech.tributos.dto.integracaocontabil.IntegracaoContabilPayload;
import br.com.elotech.tributos.dto.integracaocontabil.LoteIntegracaoContabilDTO;
import br.com.elotech.tributos.dto.integracaocontabil.SituacaoIntegracaoContabil;
import br.com.elotech.tributos.dto.integracaocontabil.SolicitacaoIntegracaoDTO;
import br.com.elotech.tributos.dto.integracaocontabil.TipoMovimento;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.PagamentoLoteService;
import br.com.elotech.tributos.service.TarefaAssincronaService;
import br.com.elotech.tributos.service.integracaocontabil.IntegracaoPatrimonialService;
import br.com.elotech.tributos.service.integracaocontabil.LoteIntegracaoContabilService;
import br.com.elotech.tributos.service.integracaocontabil.LoteItemIntegracaoContabilService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.NotImplementedException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.scheduling.annotation.Async;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

@Service
public class IntegracaoContabilService {
    private static final Logger LOGGER = LoggerFactory.getLogger(IntegracaoContabilService.class);
    private static final DateTimeFormatter formatterUserDate = DateTimeFormatter.ofPattern("dd/MM/yyyy");
    private static final String ID_ANO = "%d/%d";
    private final MovimentacaoDiariaService movimentacaoDiariaService;
    private final LoteIntegracaoContabilService loteIntegracaoContabilService;
    private final LoteItemIntegracaoContabilService loteItemIntegracaoContabilService;
    private final PagamentoLoteService pagamentoLoteService;
    private final Publisher publisher;
    private final IntegracaoPatrimonialService integracaoPatrimonialService;
    private final TarefaAssincronaService tarefaAssincronaService;
    private final NotificacaoService notificacaoService;

    public LoteIntegracaoContabilDTO loadInformacoesLote(Long id) {
        LoteIntegracaoContabil lote = (LoteIntegracaoContabil)this.loteIntegracaoContabilService.findById((Serializable)id).orElseThrow(() -> new EloValidationException(String.format("Lote %d n\u00e3o encontrado.", id)));
        List itens = this.loteItemIntegracaoContabilService.findItensIntegracao(id, lote.getTipoLote());
        LoteIntegracaoContabilDTO loteIntegracao = lote.toDTO();
        loteIntegracao.setTipoLote(lote.getTipoLoteParaEnvioContabilidade());
        loteIntegracao.setItens(itens);
        return loteIntegracao;
    }

    @Transactional
    public LoteIntegracaoContabil integrarLote(SolicitacaoIntegracaoDTO solicitacaoIntegracaoDTO) {
        if (TipoMovimento.PAGAMENTO.equals((Object)solicitacaoIntegracaoDTO.getTipo())) {
            PagamentoLote pagamentoLote = this.pagamentoLoteService.findByPagamentoLote(solicitacaoIntegracaoDTO.getEntidade(), solicitacaoIntegracaoDTO.getExercicio(), solicitacaoIntegracaoDTO.getLote());
            if (SituacaoPagamentoLote.ABERTO.equals((Object)pagamentoLote.getSituacao())) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel integrar lote em aberto %d/%d.", pagamentoLote.getId().getLote(), pagamentoLote.getId().getExercicio()));
            }
            LoteIntegracaoContabil loteIntegracaoContabil = this.loteIntegracaoContabilService.findLoteIntegracaoByPagamentoLoteId(pagamentoLote);
            if (Objects.nonNull(loteIntegracaoContabil) && !SituacaoIntegracaoContabil.ESTORNADO_CONTABILIDADE.equals((Object)loteIntegracaoContabil.getSituacaoIntegracaoContabil())) {
                throw new EloValidationException(String.format("N\u00e3o \u00e9 poss\u00edvel integrar lote %d/%d j\u00e1 enviado para a contabilidade.", loteIntegracaoContabil.getLote(), loteIntegracaoContabil.getExercicio()));
            }
            return this.solicitaIntegracaoLotePagamento(pagamentoLote);
        }
        throw new NotImplementedException(String.format("Integra\u00e7\u00e3o para o tipo de movimento %s n\u00e3o implementada.", solicitacaoIntegracaoDTO.getTipo().getDescricao()));
    }

    @Async
    @Transactional
    public void integrarDatasAssincrono(List<LocalDate> datasSelecionadas, UserSecurityDTO userSecurityDTO) {
        this.integrarDatasEmTarefaAssincrona(datasSelecionadas, userSecurityDTO);
    }

    @Transactional
    public void integrarDatasEmTarefaAssincrona(List<LocalDate> datasSelecionadas, UserSecurityDTO userSecurityDTO) {
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.criarTarefaAssincronaIntegracaoContabil(datasSelecionadas);
        Long tarefa = execucao.getTarefaAssincrona().getId();
        String datasString = datasSelecionadas.stream().map(LocalDate::toString).collect(Collectors.joining(", "));
        String detalhe = String.format("Datas selecionadas para integra\u00e7\u00e3o: %s", datasString);
        Optional notificationId = this.notificacaoService.send(String.format("Iniciada a integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), detalhe, execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        this.integrarDatas(datasSelecionadas, execucao, userSecurityDTO, notificationId);
    }

    @Async
    @Transactional
    public void retryIntegrarDatasAssincrono(Long tarefa, UserSecurityDTO userSecurityDTO) {
        this.retryIntegrarDatasEmTarefaAssincrona(tarefa, userSecurityDTO);
    }

    @Transactional
    public void retryIntegrarDatasEmTarefaAssincrona(Long tarefa, UserSecurityDTO userSecurityDTO) {
        TarefaAssincrona tarefaAssincrona = this.tarefaAssincronaService.findOne(tarefa);
        TarefaAssincronaExecucao execucao = this.tarefaAssincronaService.criarNovaExecucao(tarefaAssincrona);
        List datas = tarefaAssincrona.getParametros().stream().filter(parametro -> "DATA_INTEGRACAO".equals(parametro.getChave()) && TipoParametro.DATA.equals((Object)parametro.getTipo())).map(parametro -> DateUtils.stringToLocalDate((String)parametro.getValor())).collect(Collectors.toList());
        String datasString = datas.stream().map(LocalDate::toString).collect(Collectors.joining(", "));
        String detalhe = String.format("Datas selecionadas para integra\u00e7\u00e3o: %s", datasString);
        Optional notificationId = this.notificacaoService.send(String.format("Iniciada nova tentativa da integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), detalhe, execucao.getTarefaAssincrona(), Optional.empty(), userSecurityDTO, NotificationStatus.STARTED);
        this.integrarDatas(datas, execucao, userSecurityDTO, notificationId);
    }

    @Transactional
    public void integrarDatas(List<LocalDate> datasSelecionadas, TarefaAssincronaExecucao execucao, UserSecurityDTO userSecurityDTO, Optional<UUID> notificationId) {
        LOGGER.info("In\u00edcio da integra\u00e7\u00e3o cont\u00e1bil de dias");
        Long tarefa = execucao.getTarefaAssincrona().getId();
        List movimentacoesDiarias = new ArrayList();
        try {
            movimentacoesDiarias = this.movimentacaoDiariaService.verificaSituacaoParaIntegracaoContabil(datasSelecionadas, userSecurityDTO.getPreferredUsername());
            this.solicitaIntegracaoPatrimonial(datasSelecionadas);
            LOGGER.debug("Iniciando integra\u00e7\u00e3o financeira");
            datasSelecionadas.forEach(data -> {
                LOGGER.debug("Iniciando integra\u00e7\u00e3o financeira do dia {}", data);
                this.integrarPagamentos(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de pagamentos");
                this.solicitaIntegracaoEstornoPagamento(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de estornos de pagamentos");
                this.solicitaIntegracaoRestituicao(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o das restitui\u00e7\u00f5es");
                this.solicitaIntegracaoReabilitacaoPagamento(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de reabilita\u00e7\u00e3o de pagamentos");
                this.solicitaIntegracaoLoteEstornoCredito(data);
                LOGGER.debug("Realizada integra\u00e7\u00e3o de estornos de creditos");
            });
            this.movimentacaoDiariaService.integrarData(movimentacoesDiarias);
        }
        catch (Exception exception) {
            LOGGER.error("Erro na integra\u00e7\u00e3o cont\u00e1bil de dias: {}", (Object)exception.getMessage());
            this.movimentacaoDiariaService.updateSituacaoMovimentacoesDiarias(movimentacoesDiarias, SituacaoMovimentacaoDiaria.TRIBUTACAO);
            this.tarefaAssincronaService.marcarExecucaoComErro(execucao, exception.getMessage());
            this.notificacaoService.send(String.format("Ocorreu um erro na integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), exception.getMessage(), execucao.getTarefaAssincrona(), notificationId, userSecurityDTO, NotificationStatus.FAILED);
            return;
        }
        this.tarefaAssincronaService.finalizarExecucao(execucao);
        this.notificacaoService.send(String.format("Finalizada a integra\u00e7\u00e3o cont\u00e1bil de dias da tarefa %s", tarefa), "Todos os dias foram integrados com sucesso", execucao.getTarefaAssincrona(), notificationId, userSecurityDTO, NotificationStatus.COMPLETED);
        LOGGER.info("T\u00e9rmino da integra\u00e7\u00e3o cont\u00e1bil de dias");
    }

    public void republish(Long idLote) {
        LoteIntegracaoContabil lote = (LoteIntegracaoContabil)this.loteIntegracaoContabilService.findById((Serializable)idLote).orElseThrow(() -> new EloValidationException(String.format("Lote %d n\u00e3o encontrado.", idLote)));
        if (!SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.equals((Object)lote.getSituacaoIntegracaoContabil())) {
            throw new EloValidationException(String.format("Apenas lotes com status %s podem ser reenviados.", SituacaoIntegracaoContabil.AGUARDANDO_CONTABILIZACAO.getDescricao()));
        }
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)lote.toPayload());
    }

    private void integrarPagamentos(LocalDate data) {
        LOGGER.info("Integrando pagamentos " + data);
        List lotes = this.pagamentoLoteService.findAllNotIntegradoByDataMovimentoAndSituacao(data);
        String lotesAbertos = lotes.stream().filter(lote -> SituacaoPagamentoLote.ABERTO.equals((Object)lote.getSituacao())).map(lote -> String.format(ID_ANO, lote.getId().getLote(), lote.getId().getExercicio())).collect(Collectors.joining(","));
        if (!lotesAbertos.isEmpty()) {
            throw new EloValidationException(String.format("Data %s possu\u00ed lote(s) em aberto %s.", data.format(formatterUserDate), lotesAbertos));
        }
        lotes.forEach(arg_0 -> this.solicitaIntegracaoLotePagamento(arg_0));
    }

    private LoteIntegracaoContabil solicitaIntegracaoLotePagamento(PagamentoLote pagamentoLote) {
        LoteIntegracaoContabil loteIntegracaoContabil = this.loteIntegracaoContabilService.geraLoteIntegracaoPagamento(pagamentoLote);
        IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
        integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
        integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
        this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
        LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Pagamento) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        return loteIntegracaoContabil;
    }

    private void solicitaIntegracaoEstornoPagamento(LocalDate dataEstorno) {
        LOGGER.info("Integrando estorno de pagamentos " + dataEstorno);
        List lotesIntegracaoContabil = this.loteIntegracaoContabilService.geraIntegracaoEstornoPagamento(dataEstorno);
        lotesIntegracaoContabil.forEach(loteIntegracaoContabil -> {
            IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
            integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
            integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
            LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Estorno Pagamento) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        });
    }

    private void solicitaIntegracaoRestituicao(LocalDate dataRestituicao) {
        LOGGER.info("Integrando restitui\u00e7\u00f5es {}", (Object)dataRestituicao);
        List lotesIntegracaoContabil = this.loteIntegracaoContabilService.geraIntegracaoRestituicao(dataRestituicao);
        lotesIntegracaoContabil.forEach(loteIntegracaoContabil -> {
            IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
            integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
            integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
            LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Restitui\u00e7\u00e3o) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        });
    }

    private void solicitaIntegracaoReabilitacaoPagamento(LocalDate dataReabilitacao) {
        LOGGER.info("Integrando reabilitacao de pagamento " + dataReabilitacao);
        List lotesIntegracaoContabil = this.loteIntegracaoContabilService.geraIntegracaoReabilitacaoPagamento(dataReabilitacao);
        lotesIntegracaoContabil.forEach(loteIntegracaoContabil -> {
            IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
            integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
            integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
            LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Reabilita\u00e7\u00e3o Pagamento) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        });
    }

    private void solicitaIntegracaoLoteEstornoCredito(LocalDate dataEstorno) {
        LOGGER.info("Integrando estorno de credito " + dataEstorno);
        List lotesIntegracaoContabil = this.loteIntegracaoContabilService.geraIntegracaoEstornoCredito(dataEstorno);
        lotesIntegracaoContabil.forEach(loteIntegracaoContabil -> {
            IntegracaoContabilPayload integracaoContabilPayload = new IntegracaoContabilPayload();
            integracaoContabilPayload.setId(loteIntegracaoContabil.getId());
            integracaoContabilPayload.setSituacao(loteIntegracaoContabil.getSituacaoIntegracaoContabil());
            this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoContabilPayload);
            LOGGER.info("Payload de Integra\u00e7\u00e3o Cont\u00e1bil (Estorno Cr\u00e9dito) enviado para publica\u00e7\u00e3o - ID {}", (Object)integracaoContabilPayload.getId());
        });
    }

    private void solicitaIntegracaoPatrimonial(List<LocalDate> datasMovimento) {
        LOGGER.info("Iniciando integracao patrimonial");
        List integracoesPatrimoniais = this.integracaoPatrimonialService.geraIntegracaoPatrimonial(datasMovimento);
        LOGGER.debug("Iniciando envio das mensagens da integra\u00e7\u00e3o patrimonial para a fila");
        integracoesPatrimoniais.forEach(integracaoPatrimonial -> this.publisher.publish(OutboxActions.CREATED, (EntityEvent)integracaoPatrimonial.toPayload()));
        LOGGER.debug("Finalizou envio das mensagens da integra\u00e7\u00e3o patrimonial para a fila");
    }

    @Generated
    public IntegracaoContabilService(MovimentacaoDiariaService movimentacaoDiariaService, LoteIntegracaoContabilService loteIntegracaoContabilService, LoteItemIntegracaoContabilService loteItemIntegracaoContabilService, PagamentoLoteService pagamentoLoteService, Publisher publisher, IntegracaoPatrimonialService integracaoPatrimonialService, TarefaAssincronaService tarefaAssincronaService, NotificacaoService notificacaoService) {
        this.movimentacaoDiariaService = movimentacaoDiariaService;
        this.loteIntegracaoContabilService = loteIntegracaoContabilService;
        this.loteItemIntegracaoContabilService = loteItemIntegracaoContabilService;
        this.pagamentoLoteService = pagamentoLoteService;
        this.publisher = publisher;
        this.integracaoPatrimonialService = integracaoPatrimonialService;
        this.tarefaAssincronaService = tarefaAssincronaService;
        this.notificacaoService = notificacaoService;
    }
}

