/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.integracaoboleto.sicoob;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.exception.RestException;
import br.com.elotech.tributos.domain.Banco;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.enums.IntegracaoTokenOperation;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.impl.exception.ParametroNaoEncontradoException;
import br.com.elotech.tributos.service.integracaoboleto.IntegracaoTokenService;
import br.com.elotech.tributos.util.RestTemplateUtils;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.MediaType;
import org.springframework.stereotype.Service;
import org.springframework.util.LinkedMultiValueMap;
import org.springframework.util.MultiValueMap;

@Service
public class AutenticacaoSicoobService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(AutenticacaoSicoobService.class);
    private final ParametroGeralService parametroGeralService;
    private final ObjectMapper mapper;
    private final List<IntegracaoTokenService> integracaoTokenServices;

    public String getAccessToken(byte[] certificado, String senhaCertificado, String scope) {
        IntegracaoTokenService tokenService = this.getTokenService();
        Optional accessToken = tokenService.getAccessToken(Banco.CODIGO_SICOOB, IntegracaoTokenOperation.BOLETO);
        if (accessToken.isPresent()) {
            return (String)accessToken.get();
        }
        JsonNode response = this.generateNewAccessToken(certificado, senhaCertificado, scope);
        return tokenService.saveIntegracaoToken(Banco.CODIGO_SICOOB, IntegracaoTokenOperation.BOLETO, response);
    }

    private JsonNode generateNewAccessToken(byte[] certificado, String senhaCertificado, String scope) {
        String oauthUrl = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_URL);
        String clientId = this.getParametro(ParametroGeralEnum.BOLETO_SICOOB_OAUTH_CLIENTID);
        HttpHeaders headers = new HttpHeaders();
        headers.setContentType(MediaType.APPLICATION_FORM_URLENCODED);
        LinkedMultiValueMap body = new LinkedMultiValueMap();
        body.add((Object)"grant_type", (Object)"client_credentials");
        body.add((Object)"client_id", (Object)clientId);
        body.add((Object)"scope", (Object)scope);
        HttpEntity httpEntity = new HttpEntity((Object)body, (MultiValueMap)headers);
        try {
            JsonNode response = (JsonNode)RestTemplateUtils.getRestTemplateComCertificado((byte[])certificado, (String)senhaCertificado).exchange(oauthUrl, HttpMethod.POST, httpEntity, JsonNode.class, new Object[0]).getBody();
            if (Objects.isNull(response) || !response.has("access_token")) {
                throw new RestException(HttpStatus.BAD_REQUEST, "N\u00e3o foi poss\u00edvel buscar o token.");
            }
            return response;
        }
        catch (RestException e) {
            JsonNode jsonNode = this.converteErroResposta(e.getMessage());
            if (jsonNode.has("message")) {
                throw new RestException(e.getStatus(), jsonNode.get("message").asText(), (Throwable)e);
            }
            throw e;
        }
        catch (Exception ex) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, ex.getMessage(), (Throwable)ex);
        }
    }

    private String getParametro(ParametroGeralEnum parametroGeralEnum) {
        try {
            String valor = this.parametroGeralService.getParamValueAsString(parametroGeralEnum, ModuloEnum.MODULO_TRIBUTARIO.getValue());
            if (Objects.isNull(valor) || StringUtils.isEmpty((String)valor)) {
                throw new ParametroNaoEncontradoException(parametroGeralEnum.getDescricao());
            }
            return valor;
        }
        catch (ParametroNaoEncontradoException e) {
            throw new RestException(HttpStatus.INTERNAL_SERVER_ERROR, e.getMessage());
        }
    }

    private JsonNode converteErroResposta(String json) {
        try {
            return (JsonNode)this.mapper.readValue(json, JsonNode.class);
        }
        catch (JsonProcessingException e) {
            log.error("Erro ao ler o json do retorno com erro. " + json, (Throwable)e);
            throw new RuntimeException("Erro ao ler o json do retorno com erro do endpoint de Autentica\u00e7\u00e3o do Banco Sicoob. " + json);
        }
    }

    private IntegracaoTokenService getTokenService() {
        return this.integracaoTokenServices.stream().filter(s -> s.accept("JWT")).findFirst().orElseThrow(() -> new EloValidationException("N\u00e3o encontrado service para lidar com o tipo de token JWT"));
    }

    @Generated
    public AutenticacaoSicoobService(ParametroGeralService parametroGeralService, ObjectMapper mapper, List<IntegracaoTokenService> integracaoTokenServices) {
        this.parametroGeralService = parametroGeralService;
        this.mapper = mapper;
        this.integracaoTokenServices = integracaoTokenServices;
    }
}

