/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.batch;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.JobType;
import br.com.elotech.tributos.dto.CamposEdicaoMassa;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.repository.BairroRepository;
import br.com.elotech.tributos.repository.LogradouroRepository;
import br.com.elotech.tributos.repository.SituacaoImobiliarioRepository;
import br.com.elotech.tributos.service.batch.EdicaoEmMassaJobStarter;
import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.List;
import java.util.Objects;
import lombok.Generated;
import org.springframework.batch.core.Job;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParametersBuilder;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.explore.JobExplorer;
import org.springframework.batch.core.launch.JobLauncher;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.stereotype.Service;

@Service
public class EdicaoEmMassaJobStarter {
    private final JobExplorer jobExplorer;
    private final Job edicaoEmMassaBatchJob;
    private final JobLauncher jobLauncher;
    private final ObjectMapper objectMapper;
    private final LogradouroRepository logradouroRepository;
    private final BairroRepository bairroRepository;
    private final SituacaoImobiliarioRepository situacaoImobiliarioRepository;

    public JobExecution startJob(EdicaoEmMassaFiltroDTO filtro) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        if (filtro.getCamposValues().isEmpty()) {
            throw new EloValidationException("Nenhum campo foi informado para a altera\u00e7\u00e3o em massa.");
        }
        String filtroString = this.objectMapper.writeValueAsString((Object)filtro);
        boolean existeJobComMesmosParametros = this.jobExplorer.findRunningJobExecutions(JobType.EDICAO_EM_MASSA.getTipo()).stream().anyMatch(jobExecution -> jobExecution.getJobParameters().getParameters().equals(filtro));
        if (existeJobComMesmosParametros) {
            throw new EloValidationException("J\u00e1 existe um job de altera\u00e7\u00e3o em massa em execu\u00e7\u00e3o com os mesmos par\u00e2metros.");
        }
        this.validateCamposParaEdicao(filtro.getCamposValues());
        JobParametersBuilder jobParametersBuilder = new JobParametersBuilder();
        jobParametersBuilder.addString("filtro", filtroString);
        return this.jobLauncher.run(this.edicaoEmMassaBatchJob, jobParametersBuilder.toJobParameters());
    }

    private void validateCamposParaEdicao(List<CamposEdicaoMassa> campos) {
        campos.forEach(campo -> {
            if (Objects.isNull(campo.getCampo().getOrigemCampo())) {
                return;
            }
            switch (1.$SwitchMap$br$com$elotech$tributos$dto$CampoEdicaoEmMassa$OrigemCampo[campo.getCampo().getOrigemCampo().ordinal()]) {
                case 1: {
                    this.logradouroRepository.findById((Object)Long.valueOf(campo.getValor())).orElseThrow(() -> new EloValidationException(String.format("Logradouro %s n\u00e3o encontrado", campo.getValor())));
                    break;
                }
                case 2: {
                    this.bairroRepository.findById((Object)Long.valueOf(campo.getValor())).orElseThrow(() -> new EloValidationException(String.format("Bairro %s n\u00e3o encontrado", campo.getValor())));
                    break;
                }
                case 3: {
                    this.situacaoImobiliarioRepository.findById((Object)Long.valueOf(campo.getValor())).orElseThrow(() -> new EloValidationException(String.format("Situa\u00e7\u00e3o %s n\u00e3o encontrada", campo.getValor())));
                }
            }
        });
    }

    @Generated
    public EdicaoEmMassaJobStarter(JobExplorer jobExplorer, Job edicaoEmMassaBatchJob, JobLauncher jobLauncher, ObjectMapper objectMapper, LogradouroRepository logradouroRepository, BairroRepository bairroRepository, SituacaoImobiliarioRepository situacaoImobiliarioRepository) {
        this.jobExplorer = jobExplorer;
        this.edicaoEmMassaBatchJob = edicaoEmMassaBatchJob;
        this.jobLauncher = jobLauncher;
        this.objectMapper = objectMapper;
        this.logradouroRepository = logradouroRepository;
        this.bairroRepository = bairroRepository;
        this.situacaoImobiliarioRepository = situacaoImobiliarioRepository;
    }
}

