/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.acrescimo.calculo.multa;

import br.com.elotech.tributos.domain.EntidadeCorrecaoMultaEspecial;
import br.com.elotech.tributos.domain.Feriado;
import br.com.elotech.tributos.domain.MultaDiasCorrecao;
import br.com.elotech.tributos.domain.PeriodoMultaEspecial;
import br.com.elotech.tributos.service.DiaUtilService;
import br.com.elotech.tributos.service.acrescimo.calculo.multa.CalculoMultaEspecialService;
import br.com.elotech.tributos.service.acrescimo.exception.InvalidPeriodoMultaEspecialException;
import br.com.elotech.tributos.util.DateUtils;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Service;

@Service
public class CalculoMultaEspecialService {
    private final DiaUtilService diaUtilService;
    private static final Logger LOG = LoggerFactory.getLogger(CalculoMultaEspecialService.class);

    public CalculoMultaEspecialService(DiaUtilService diaUtilService) {
        this.diaUtilService = diaUtilService;
    }

    public BigDecimal calculaValorMultaEspecial(List<EntidadeCorrecaoMultaEspecial> multas, LocalDate dataVencimento, LocalDate dataPagamento, MultaDiasCorrecao tipoMulta, List<Feriado> feriados) {
        return multas.stream().filter(multa -> !PeriodoMultaEspecial.NENHUM.equals((Object)multa.getPeriodo()) && dataVencimento.compareTo(multa.getId().getDataInicial()) >= 0 && dataVencimento.compareTo(multa.getId().getDataFinal()) <= 0).map(multa -> this.getAliquota(multa, dataVencimento, dataPagamento, tipoMulta, feriados)).reduce(BigDecimal.ZERO, BigDecimal::add);
    }

    private BigDecimal getAliquota(EntidadeCorrecaoMultaEspecial multaEspecial, LocalDate dataVencimento, LocalDate dataPagamento, MultaDiasCorrecao tipoMulta, List<Feriado> feriados) {
        LocalDate dataLimite;
        LocalDate localDate = dataLimite = multaEspecial.getId().getDataFinal().isBefore(dataPagamento) ? multaEspecial.getId().getDataFinal() : dataPagamento;
        if (Objects.isNull(multaEspecial.getPeriodo())) {
            LOG.error("Periodo da multa especial {} est\u00e1 nulo.", (Object)multaEspecial);
            throw new InvalidPeriodoMultaEspecialException("O per\u00edodo de c\u00e1lculo da multa \u00e9 obrigat\u00f3rio.");
        }
        Long quantidadeDiferenca = this.getDiferencaEntreDatas(multaEspecial.getPeriodo(), dataVencimento, dataLimite, tipoMulta, feriados);
        return BigDecimal.valueOf(quantidadeDiferenca).multiply(multaEspecial.getPercentual()).min(multaEspecial.getPercentualLimite());
    }

    private Long getDiferencaEntreDatas(PeriodoMultaEspecial periodo, LocalDate dataVencimento, LocalDate dataLimite, MultaDiasCorrecao tipoMulta, List<Feriado> feriados) {
        switch (1.$SwitchMap$br$com$elotech$tributos$domain$PeriodoMultaEspecial[periodo.ordinal()]) {
            case 1: {
                return this.diaUtilService.countDiasAtraso(dataVencimento, dataLimite, tipoMulta, feriados);
            }
            case 2: {
                return DateUtils.monthsBetweenDelphi((LocalDate)dataVencimento, (LocalDate)dataLimite);
            }
            case 3: {
                return DateUtils.yearsBetweenDelphi((LocalDate)dataVencimento, (LocalDate)dataLimite);
            }
        }
        return 0L;
    }
}

