/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ExercicioMesId;
import br.com.elotech.tributos.domain.MovimentacaoDiariaId;
import br.com.elotech.tributos.domain.exerciciomes.ExercicioMes;
import br.com.elotech.tributos.domain.exerciciomes.SituacaoExercicioMes;
import br.com.elotech.tributos.domain.movimentacaodiaria.MovimentacaoDiaria;
import br.com.elotech.tributos.domain.movimentacaodiaria.SituacaoMovimentacaoDiaria;
import br.com.elotech.tributos.service.ExercicioMesService;
import br.com.elotech.tributos.service.MovimentacaoDiariaService;
import br.com.elotech.tributos.util.DateUtils;
import java.io.Serializable;
import java.time.LocalDate;
import org.springframework.stereotype.Service;

@Service
public class ValidaDataMovimentacaoService {
    private final ExercicioMesService exercicioMesService;
    private final MovimentacaoDiariaService movimentacaoDiariaService;

    public ValidaDataMovimentacaoService(ExercicioMesService exercicioMesService, MovimentacaoDiariaService movimentacaoDiariaService) {
        this.exercicioMesService = exercicioMesService;
        this.movimentacaoDiariaService = movimentacaoDiariaService;
    }

    public void verificaMesFechadoTributacao(ExercicioMesId exercicioMesId) {
        ExercicioMes exercicioMes = this.exercicioMesService.findById((Serializable)exercicioMesId).orElseGet(() -> {
            ExercicioMes created = new ExercicioMes();
            created.setId(exercicioMesId);
            created.setSituacao(SituacaoExercicioMes.ABERTO);
            return (ExercicioMes)this.exercicioMesService.save((EloEntity)created, null);
        });
        if (!SituacaoExercicioMes.ABERTO.equals((Object)exercicioMes.getSituacao())) {
            throw new EloValidationException(String.format("O m\u00eas %s j\u00e1 foi fechado pela tributa\u00e7\u00e3o. N\u00e3o ser\u00e1 poss\u00edvel realizar a opera\u00e7\u00e3o sem antes reabrir o m\u00eas.", exercicioMesId.getMes()));
        }
    }

    public void verificaMovimentacaoDiaria(MovimentacaoDiariaId movimentacaoDiariaId) {
        MovimentacaoDiaria movimentacaoDiaria = this.movimentacaoDiariaService.findOrCreateMovimentacaoDiaria(movimentacaoDiariaId);
        if (SituacaoMovimentacaoDiaria.CONTABILIDADE.equals((Object)movimentacaoDiaria.getSituacao())) {
            throw new EloValidationException(String.format("A movimenta\u00e7\u00e3o da data %s j\u00e1 foi fechada pela contabilidade. N\u00e3o ser\u00e1 poss\u00edvel realizar a opera\u00e7\u00e3o sem antes estornar a integra\u00e7\u00e3o.", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)movimentacaoDiariaId.getData())));
        }
        if (SituacaoMovimentacaoDiaria.TRIBUTACAO.equals((Object)movimentacaoDiaria.getSituacao())) {
            throw new EloValidationException(String.format("A movimenta\u00e7\u00e3o da data %s j\u00e1 foi fechada pela tributa\u00e7\u00e3o. N\u00e3o ser\u00e1 poss\u00edvel realizar a opera\u00e7\u00e3o sem antes fazer uma reabertura.", DateUtils.localDateToStringFormatoBrasileiro((LocalDate)movimentacaoDiariaId.getData())));
        }
    }

    public void validaMesEDia(Long entidade, LocalDate data) {
        ExercicioMesId exercicioMesId = new ExercicioMesId();
        exercicioMesId.setEntidade(entidade);
        exercicioMesId.setExercicio(Long.valueOf(data.getYear()));
        exercicioMesId.setMes(Long.valueOf(data.getMonthValue()));
        this.verificaMesFechadoTributacao(exercicioMesId);
        MovimentacaoDiariaId movimentacaoDiariaId = new MovimentacaoDiariaId();
        movimentacaoDiariaId.setData(data);
        movimentacaoDiariaId.setEntidade(entidade);
        this.verificaMovimentacaoDiaria(movimentacaoDiariaId);
    }
}

