/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.contabilidade.client.TipoTributoFeignClient;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.Tributo;
import br.com.elotech.tributos.dto.UpdateTributoDTO;
import br.com.elotech.tributos.repository.TributoRepository;
import br.com.elotech.tributos.service.ContextService;
import java.util.Objects;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class TributoService
extends CrudService<Tributo, Long> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(TributoService.class);
    private Optional<TipoTributoFeignClient> tipoTributoFeignClient;
    private final TributoRepository tributoRepository;
    private final ContextService contextService;

    public Tributo findByEntidadeAndExercicioAndTributo(Long entidade, Long exercicio, String tributo) {
        return this.tributoRepository.findByEntidadeAndExercicioAndTributo(entidade, exercicio, tributo);
    }

    public Page<Tributo> findTributoByExercicioAtualAndRsql(String search, Pageable pageable) {
        search = String.format("exercicio==%d %s", this.contextService.getExercicioAtual(), search.isEmpty() ? "" : "and " + search);
        return this.findByRsql(search, pageable);
    }

    public Tributo updateTributo(UpdateTributoDTO updateTributoDTO) {
        Tributo tributo = (Tributo)this.tributoRepository.findOne((Object)updateTributoDTO.getId());
        if (Objects.isNull(tributo)) {
            throw new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar tributo de id: %d", updateTributoDTO.getId()));
        }
        if (!Objects.equals(updateTributoDTO.getDescricao(), tributo.getDescricao())) {
            this.sincronizarDescricaoContabilidade(tributo.getTributo(), updateTributoDTO.getDescricao());
        }
        return (Tributo)this.tributoRepository.save((Object)Tributo.from((UpdateTributoDTO)updateTributoDTO));
    }

    public void sincronizarDescricaoContabilidade(String codigo, String descricao) {
        try {
            this.tipoTributoFeignClient.ifPresent(tipoTributoFeignClient -> tipoTributoFeignClient.updateDescricao(codigo, descricao));
        }
        catch (Exception e) {
            log.error("Erro ao atualizar descri\u00e7\u00e3o do tributo no modulo contabilidade: {}", (Object)e.getMessage());
        }
    }

    @Generated
    public TributoService(Optional<TipoTributoFeignClient> tipoTributoFeignClient, TributoRepository tributoRepository, ContextService contextService) {
        this.tipoTributoFeignClient = tipoTributoFeignClient;
        this.tributoRepository = tributoRepository;
        this.contextService = contextService;
    }
}

