/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.arquivos.client.ArquivoClient;
import br.com.elotech.arquivos.domain.Arquivo;
import br.com.elotech.arquivos.domain.request.ArquivoDownloadRequest;
import br.com.elotech.arquivos.domain.request.ArquivoNovoRequest;
import br.com.elotech.arquivos.domain.request.ArquivoRemocaoRequest;
import br.com.elotech.arquivos.domain.support.ContentType;
import br.com.elotech.arquivos.domain.support.Tenant;
import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.multitenant.filter.TenantContextHolder;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessa;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.ObservacaoRestritivaDTO;
import br.com.elotech.tributos.dto.ProtestoRemessaItemDTO;
import br.com.elotech.tributos.dto.ProtestoRemessaResumoDTO;
import br.com.elotech.tributos.dto.RetornoRemessaHeaderDTO;
import br.com.elotech.tributos.enums.SituacaoProtesto;
import br.com.elotech.tributos.enums.SituacaoProtestoTipoRemessa;
import br.com.elotech.tributos.repository.ProtestoRemessaRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.CadastroGeralObservacaoService;
import br.com.elotech.tributos.service.ContextService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.ProtestoRemessaItemService;
import br.com.elotech.tributos.service.ProtestoService;
import br.com.elotech.tributos.service.integracaoprotestocra.IntegracaoProtestoCraService;
import br.com.elotech.tributos.service.resolvers.ResolversHandler;
import com.amazonaws.AmazonServiceException;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import javax.persistence.EntityExistsException;
import javax.servlet.http.HttpServletResponse;
import lombok.Generated;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;
import org.springframework.web.multipart.MultipartFile;

@Service
public class ProtestoRemessaService
extends CrudService<ProtestoRemessa, Long> {
    private final ContextService contextService;
    private final ProtestoRemessaRepository protestoRemessaRepository;
    private final ProtestoRemessaItemService processoRemessaItemService;
    private final ResolversHandler resolversHandler;
    private final CadastroGeralObservacaoService cadastroGeralObservacaoService;
    private final ParametroGeralService parametroGeralService;
    private final IntegracaoProtestoCraService integracaoProtestoCraService;
    private final ProtestoService protestoService;

    public ProtestoRemessa createAndSave() {
        Long exercicioAtual = this.contextService.getExercicioAtual();
        Long entidadePrincipal = this.contextService.getEntidadePrincipal();
        ProtestoRemessa protestoRemessa = new ProtestoRemessa();
        protestoRemessa.setEntidade(entidadePrincipal);
        protestoRemessa.setExercicio(exercicioAtual);
        protestoRemessa.setUsuario(SecurityUtils.getUserName());
        protestoRemessa.setTipoRemessa(SituacaoProtestoTipoRemessa.R);
        return (ProtestoRemessa)this.protestoRemessaRepository.save((Object)protestoRemessa);
    }

    public Long getQtdRemessaPorData(LocalDate data, SituacaoProtestoTipoRemessa tipoRemessa) {
        return this.protestoRemessaRepository.getQtdRemessaPorData(data, tipoRemessa);
    }

    public ProtestoRemessaResumoDTO getProtestoRemessaResumo(Long id) {
        ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaRepository.findById((Object)id).orElseThrow(() -> new EntityExistsException(String.format("Remessa de protesto com ID %s n\u00e3o encontrada", id)));
        List protestoRemessaItens = this.processoRemessaItemService.findByProtestoRemessaAndBuildProtestoRemessaItemDTO(protestoRemessa);
        List observacoes = this.findObservacoesByProtestoRemessaItens(protestoRemessaItens);
        return new ProtestoRemessaResumoDTO(protestoRemessa, protestoRemessaItens, observacoes);
    }

    public List<ObservacaoRestritivaDTO> findObservacoesByProtestoRemessaItens(List<ProtestoRemessaItemDTO> protestoRemessaItens) {
        return protestoRemessaItens.stream().filter(item -> item.getCadastroGeral() != null).map(item -> this.cadastroGeralObservacaoService.findObsRestritiva(item.getCadastroGeral())).filter(ObservacaoRestritivaDTO::getExisteRestricao).collect(Collectors.toList());
    }

    public void downloadArquivo(HttpServletResponse response, Long idProtesto) throws IOException {
        ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaRepository.findById((Object)idProtesto).orElseThrow(() -> new EntityExistsException(String.format("Protesto de Remessa com ID %s n\u00e3o encontrado para realizar download de arquivo de envio.", idProtesto)));
        if (protestoRemessa.getArqenvArquivo() == null) {
            throw new EloValidationException(String.format("Arquivo de envio da remessa com ID %s n\u00e3o encontrado", idProtesto));
        }
        response.setHeader("Content-Disposition", "attachment; filename=" + protestoRemessa.getArqenvArquivonome());
        response.setHeader("Content-Type", "application/xml");
        response.setHeader("Content-Length", String.valueOf(protestoRemessa.getArqenvArquivo().length));
        response.getOutputStream().write(protestoRemessa.getArqenvArquivo());
    }

    public String getUrlArquivoEnvioRemessa(String idArquivo) {
        ArquivoDownloadRequest arquivoDownloadRequest = ArquivoDownloadRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + idArquivo));
        return this.resolveArquivoClient().gerarUrlParaGet(arquivoDownloadRequest).getUrlAssinada();
    }

    public ArquivoClient resolveArquivoClient() {
        return this.resolversHandler.getArquivoClientMinio();
    }

    @Transactional
    public void removeArquivoOnS3(Long idProtesto, UUID idArquivo) {
        Boolean utilizaWebService = this.parametroGeralService.getParamValueAsBoolean(ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO, ModuloEnum.MODULO_TRIBUTARIO.getValue());
        if (Boolean.TRUE.equals(utilizaWebService)) {
            throw new IllegalArgumentException("Param\u00eatro de protesto UTILIZAWEBSERVICEPROTESTO deve estar ativado para deletar arquivos em Web Service.");
        }
        ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaRepository.findByIdProtestoAndIdArquivo(idProtesto, idArquivo).orElseThrow(() -> new EntityExistsException(String.format("Remessa de protesto com ID %s e arquivo ID %s n\u00e3o encontrada", idProtesto, idArquivo)));
        if (Objects.nonNull(protestoRemessa.getArqenvIdArquivo())) {
            ArquivoRemocaoRequest arquivoRemocaoRequest = ArquivoRemocaoRequest.create((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (String)("oxy_tributos/" + protestoRemessa.getArqenvIdArquivo()));
            this.deleteArquivo(arquivoRemocaoRequest);
            this.updateSituacaoProtestoEmProtesto(protestoRemessa);
            this.updateArquivoInfoEmProtestoRemessa(protestoRemessa);
        }
    }

    private void updateArquivoInfoEmProtestoRemessa(ProtestoRemessa protestoRemessa) {
        protestoRemessa.setArqenvIdArquivo(null);
        protestoRemessa.setArqenvData(null);
        protestoRemessa.setArqenvArquivonome(null);
        protestoRemessa.setArqenvUsuario(null);
        protestoRemessa.setArqenvArquivo(null);
        protestoRemessa.setArqrecArquivo(null);
        protestoRemessa.setArqrecArquivonome(null);
        protestoRemessa.setArqrecData(null);
        protestoRemessa.setArqrecUsuario(null);
        this.protestoRemessaRepository.save((Object)protestoRemessa);
    }

    private void updateSituacaoProtestoEmProtesto(ProtestoRemessa protestoRemessa) {
        List<Protesto> protestos = this.processoRemessaItemService.findByProtestoRemessa(protestoRemessa).stream().map(ProtestoRemessaItem::getProtesto).collect(Collectors.toList());
        protestos.forEach(protesto -> protesto.setSituacao(SituacaoProtesto.AGUARDANDO_GERAR_ARQUIVO));
        this.protestoService.saveAll(protestos);
    }

    private void deleteArquivo(ArquivoRemocaoRequest arquivoRemocaoRequest) {
        try {
            this.resolveArquivoClient().removerArquivo(arquivoRemocaoRequest);
        }
        catch (Exception e) {
            throw new AmazonServiceException("Erro ao deletar arquivo de protesto. " + e.getMessage());
        }
    }

    public ProtestoRemessaResumoDTO createArquivoOnS3(Long idProtesto, LocalDate dataEmissaoPersonalizada) {
        ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaRepository.findById((Object)idProtesto).orElseThrow(() -> new EntityExistsException(String.format("Protesto de Remessa com ID %s n\u00e3o encontrado para realizar download de arquivo de envio.", idProtesto)));
        if (protestoRemessa.getArqenvIdArquivo() != null) {
            throw new IllegalArgumentException(String.format("Arquivo de envio da remessa com ID %s j\u00e1 foi gerado.", idProtesto));
        }
        this.integracaoProtestoCraService.gerarArquivoTxtRemessa(protestoRemessa, dataEmissaoPersonalizada);
        return this.getProtestoRemessaResumo(idProtesto);
    }

    public void importarArquivoRetorno(MultipartFile file, Long id) throws IOException {
        ProtestoRemessa protestoRemessa = (ProtestoRemessa)this.protestoRemessaRepository.findById((Object)id).orElseThrow(() -> new EntityExistsException(String.format("Protesto de Remessa com ID %s n\u00e3o encontrado para importar arquivo de retorno.", id)));
        this.validarCabecalhoArquivoRetorno(file, protestoRemessa);
        this.uploadArquivoRetorno(protestoRemessa, file);
    }

    public void validarCabecalhoArquivoRetorno(MultipartFile file, ProtestoRemessa protestoRemessa) {
        RetornoRemessaHeaderDTO retornoRemessaHeaderDTO = this.buildRetornoRemessaHeaderDTO(file);
        this.validarIdentificacaoArquivoRetorno(retornoRemessaHeaderDTO.getIdentificacaoRegistro());
        this.validarDataMovimentoArquivoRetorno(retornoRemessaHeaderDTO.getDataMovimento());
        long quantidadeRegistrosArquivo = this.getQuantidadeRegistrosArquivoRetorno(retornoRemessaHeaderDTO.getQuantidadeRegistrosRemessa());
        long quantidadeRemessaItens = this.getQuantidadeRemessaItens(protestoRemessa);
        this.validarQuantidadeRegistrosArquivoRetorno(quantidadeRemessaItens, quantidadeRegistrosArquivo);
    }

    private void validarIdentificacaoArquivoRetorno(String identificacaoRegistro) {
        if (!Objects.equals("0", identificacaoRegistro)) {
            throw new IllegalArgumentException("Cabe\u00e7alho inv\u00e1lido no arquivo.");
        }
    }

    private void validarDataMovimentoArquivoRetorno(String dataMovimento) {
        if (!this.isDataMovimentoValida(dataMovimento)) {
            throw new IllegalArgumentException("A data do movimento est\u00e1 inv\u00e1lida.");
        }
    }

    private long getQuantidadeRegistrosArquivoRetorno(String quantidadeRegistrosRemessa) {
        try {
            return Long.parseLong(quantidadeRegistrosRemessa);
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("A quantidade de registros remessa n\u00e3o \u00e9 um n\u00famero v\u00e1lido.");
        }
    }

    private long getQuantidadeRemessaItens(ProtestoRemessa protestoRemessa) {
        List itens = this.processoRemessaItemService.findByProtestoRemessa(protestoRemessa);
        return itens.size();
    }

    private void validarQuantidadeRegistrosArquivoRetorno(long quantidadeRemessaItens, long quantidadeRegistrosArquivo) {
        if (quantidadeRemessaItens != quantidadeRegistrosArquivo) {
            throw new IllegalArgumentException(String.format("A quantidade de registros no arquivo (%d) n\u00e3o corresponde \u00e0 quantidade de registros esperada (%d) para a respectiva remessa.", quantidadeRegistrosArquivo, quantidadeRemessaItens));
        }
    }

    private boolean isDataMovimentoValida(String dataMovimentoStr) {
        SimpleDateFormat dateFormat = new SimpleDateFormat("ddMMyyyy");
        dateFormat.setLenient(false);
        try {
            dateFormat.parse(dataMovimentoStr);
            return true;
        }
        catch (ParseException e) {
            return false;
        }
    }

    public RetornoRemessaHeaderDTO buildRetornoRemessaHeaderDTO(MultipartFile file) {
        RetornoRemessaHeaderDTO retornoRemessaHeaderDTO;
        BufferedReader reader = new BufferedReader(new InputStreamReader(file.getInputStream()));
        try {
            retornoRemessaHeaderDTO = new RetornoRemessaHeaderDTO(reader.readLine());
        }
        catch (Throwable throwable) {
            try {
                try {
                    reader.close();
                }
                catch (Throwable throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
            catch (IOException ex) {
                throw new RuntimeException("Erro ao ler o cabe\u00e7alho do arquivo retorno.", ex);
            }
        }
        reader.close();
        return retornoRemessaHeaderDTO;
    }

    public void uploadArquivoRetorno(ProtestoRemessa protestoRemessa, MultipartFile file) throws IOException {
        Arquivo arquivo = this.resolveArquivoClient().criarArquivo(this.buildNovoArquivoRetorno(file));
        protestoRemessa.setArqrecData(LocalDate.now());
        protestoRemessa.setArqrecUsuario(SecurityUtils.getUserAise());
        protestoRemessa.setArqrecArquivonome(file.getOriginalFilename());
        protestoRemessa.setArqrecIdArquivo(arquivo.getId());
        this.protestoRemessaRepository.save((Object)protestoRemessa);
    }

    private ArquivoNovoRequest buildNovoArquivoRetorno(MultipartFile file) throws IOException {
        return ArquivoNovoRequest.builder((Tenant)Tenant.create((String)TenantContextHolder.getCurrentTenantId()), (Modulo)Modulo.OXY_TRIBUTOS).fileName(file.getOriginalFilename()).content(file.getInputStream()).contentType(ContentType.APPLICATION_PDF).build();
    }

    @Generated
    public ProtestoRemessaService(ContextService contextService, ProtestoRemessaRepository protestoRemessaRepository, ProtestoRemessaItemService processoRemessaItemService, ResolversHandler resolversHandler, CadastroGeralObservacaoService cadastroGeralObservacaoService, ParametroGeralService parametroGeralService, IntegracaoProtestoCraService integracaoProtestoCraService, ProtestoService protestoService) {
        this.contextService = contextService;
        this.protestoRemessaRepository = protestoRemessaRepository;
        this.processoRemessaItemService = processoRemessaItemService;
        this.resolversHandler = resolversHandler;
        this.cadastroGeralObservacaoService = cadastroGeralObservacaoService;
        this.parametroGeralService = parametroGeralService;
        this.integracaoProtestoCraService = integracaoProtestoCraService;
        this.protestoService = protestoService;
    }
}

