/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.enumerable.common.ModuloEnum;
import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.repository.ParametroGeralRepository;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.springframework.stereotype.Service;

@Service
public class ParametroProtestoService {
    private final ParametroGeralRepository parametroGeralRepository;

    public List<ParametroGeral> findByParametrosProtestos() {
        List parametroGeral = this.parametroGeralRepository.findByModuloAndParametroIn(ModuloEnum.MODULO_TRIBUTARIO.getValue(), this.getValuesParametrosProtesto());
        if (parametroGeral.isEmpty()) {
            throw new EloValidationException("N\u00e3o encontrado par\u00e2metros do protesto.");
        }
        return parametroGeral;
    }

    public List<ParametroGeral> update(List<ParametroGeral> parametros) {
        parametros.forEach(parametro -> {
            if (!this.getValuesParametrosProtesto().contains(parametro.getParametro())) {
                throw new EloValidationException(String.format("O par\u00e2metro %s n\u00e3o faz parte dos par\u00e2metros do protesto.", parametro.getParametro()));
            }
        });
        return this.parametroGeralRepository.saveAll(parametros);
    }

    private List<String> getValuesParametrosProtesto() {
        return Arrays.asList(ParametroGeralEnum.CODIGO_CONVENIO_PROTESTO.getValue(), ParametroGeralEnum.QTD_MAX_REMESSA_DIA_PROTESTO.getValue(), ParametroGeralEnum.SENHA_WEB_SERVICE_PROTESTO.getValue(), ParametroGeralEnum.URL_WEB_SERVICE_PROTESTO.getValue(), ParametroGeralEnum.USUARIO_WEB_SERVICE_PROTESTO.getValue(), ParametroGeralEnum.VENCIMENTO_BLOQUETO_REMESSA_PROTESTO.getValue(), ParametroGeralEnum.DIAS_BLOQ_DEB_PROTESTO.getValue(), ParametroGeralEnum.BLOQUEIA_PROTESTO_BOLETO_A_VENCER.getValue(), ParametroGeralEnum.UTILIZA_WEBSERVICE_PROTESTO.getValue(), ParametroGeralEnum.PERMITE_INFORMAR_DATA_EMISSAO_CDA.getValue());
    }

    @Generated
    public ParametroProtestoService(ParametroGeralRepository parametroGeralRepository) {
        this.parametroGeralRepository = parametroGeralRepository;
    }
}

