/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.tributos.dto.CadastroGeralEdicaoEmMassaDTO;
import br.com.elotech.tributos.dto.EdicaoEmMassaFiltroDTO;
import br.com.elotech.tributos.repository.EdicaoEmMassaRepository;
import br.com.elotech.tributos.service.batch.EdicaoEmMassaJobStarter;
import com.fasterxml.jackson.core.JsonProcessingException;
import lombok.Generated;
import org.springframework.batch.core.JobParametersInvalidException;
import org.springframework.batch.core.repository.JobExecutionAlreadyRunningException;
import org.springframework.batch.core.repository.JobInstanceAlreadyCompleteException;
import org.springframework.batch.core.repository.JobRestartException;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class EdicaoEmMassaService {
    private final EdicaoEmMassaRepository edicaoEmMassaRepository;
    private final EdicaoEmMassaJobStarter edicaoEmMassaJobStarter;

    public Page<CadastroGeralEdicaoEmMassaDTO> findCadastrosWithFilter(EdicaoEmMassaFiltroDTO filtro, Pageable pageable) {
        String sql = this.edicaoEmMassaRepository.generateSql(filtro);
        Long total = this.edicaoEmMassaRepository.getTotalCadastrosWithFilter(sql);
        return new PageImpl(this.edicaoEmMassaRepository.findCadastrosWithFilter(filtro, pageable), pageable, total.longValue());
    }

    public void updateCadastros(EdicaoEmMassaFiltroDTO filtro) throws JobInstanceAlreadyCompleteException, JobExecutionAlreadyRunningException, JobParametersInvalidException, JobRestartException, JsonProcessingException {
        this.edicaoEmMassaJobStarter.startJob(filtro);
    }

    @Generated
    public EdicaoEmMassaService(EdicaoEmMassaRepository edicaoEmMassaRepository, EdicaoEmMassaJobStarter edicaoEmMassaJobStarter) {
        this.edicaoEmMassaRepository = edicaoEmMassaRepository;
        this.edicaoEmMassaJobStarter = edicaoEmMassaJobStarter;
    }
}

