/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.CadastroGeral;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoVinculo;
import br.com.elotech.tributos.domain.Vinculo;
import br.com.elotech.tributos.domain.mobiliario.CadastroMobiliario;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocial;
import br.com.elotech.tributos.domain.mobiliario.ContratoSocialPessoa;
import br.com.elotech.tributos.dto.ContratoSocialDTO;
import br.com.elotech.tributos.repository.ContratoSocialRepository;
import br.com.elotech.tributos.repository.mobiliario.CadastroMobiliarioRepository;
import br.com.elotech.tributos.service.CadastroMobiliarioService;
import br.com.elotech.tributos.service.VinculoService;
import java.math.BigDecimal;
import java.util.HashMap;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.springframework.stereotype.Service;

@Service
public class ContratoSocialService {
    private final ContratoSocialRepository contratoSocialRepository;
    private final CadastroMobiliarioRepository cadastroMobiliarioRepository;
    private final CadastroMobiliarioService cadastroMobiliarioService;
    private final VinculoService vinculoService;

    public ContratoSocialService(ContratoSocialRepository contratoSocialRepository, CadastroMobiliarioRepository cadastroMobiliarioRepository, CadastroMobiliarioService cadastroMobiliarioService, VinculoService vinculoService) {
        this.contratoSocialRepository = contratoSocialRepository;
        this.cadastroMobiliarioRepository = cadastroMobiliarioRepository;
        this.cadastroMobiliarioService = cadastroMobiliarioService;
        this.vinculoService = vinculoService;
    }

    public ContratoSocial findById(Long id) {
        return (ContratoSocial)this.contratoSocialRepository.findById((Object)id).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o contrato social com o id: %d.", id)));
    }

    public ContratoSocialDTO save(ContratoSocialDTO contratoSocialDTO) {
        ContratoSocial contratoSocial = this.getContratoSocialEntityAndValidate(contratoSocialDTO);
        contratoSocial = (ContratoSocial)this.contratoSocialRepository.save((Object)contratoSocial);
        this.updateProprietariosDoCadastroMobiliario(contratoSocial.getCadastroMobiliario(), contratoSocial.getPessoas());
        return ContratoSocialDTO.from((ContratoSocial)contratoSocial);
    }

    public ContratoSocialDTO update(ContratoSocialDTO contratoSocialDTO) {
        if (!this.contratoSocialRepository.isContratoAtual(contratoSocialDTO.getCadastroMobiliario(), contratoSocialDTO.getSequencia()).booleanValue()) {
            throw new EloValidationException("Edi\u00e7\u00e3o permitida apenas para o contrato social atual.");
        }
        ContratoSocial contratoSocialToMerge = this.getContratoSocialEntityAndValidate(contratoSocialDTO);
        ContratoSocial contratoSocialFound = this.findById(contratoSocialToMerge.getId());
        ContratoSocial contratoSocialSalvo = (ContratoSocial)this.contratoSocialRepository.save((Object)contratoSocialFound.merge(contratoSocialToMerge));
        this.updateProprietariosDoCadastroMobiliario(contratoSocialSalvo.getCadastroMobiliario(), contratoSocialSalvo.getPessoas());
        return ContratoSocialDTO.from((ContratoSocial)contratoSocialSalvo);
    }

    private ContratoSocial getContratoSocialEntityAndValidate(ContratoSocialDTO contratoSocialDTO) {
        ContratoSocial contratoSocial = contratoSocialDTO.toEntity();
        CadastroMobiliario cadastroMobiliario = (CadastroMobiliario)this.cadastroMobiliarioRepository.findById((Object)contratoSocialDTO.getCadastroMobiliario()).orElseThrow(() -> new EloValidationException(String.format("N\u00e3o foi poss\u00edvel encontrar o cadastro mobili\u00e1rio com o id: %d.", contratoSocialDTO.getCadastroMobiliario())));
        contratoSocial.setCadastroMobiliario(cadastroMobiliario);
        if (Objects.isNull(contratoSocial.getSequencia())) {
            contratoSocial.setSequencia(this.contratoSocialRepository.findProximaSequencia(cadastroMobiliario.getId()));
        }
        if (contratoSocial.getPessoas().stream().noneMatch(ContratoSocialPessoa::getResponsavel)) {
            throw new EloValidationException("\u00c9 obrigat\u00f3rio ter ao menos um respons\u00e1vel principal vinculado ao contrato social.");
        }
        if (BigDecimal.valueOf(100L).compareTo(contratoSocial.getTotalPercentualSocios()) > 0) {
            throw new EloValidationException("O total da soma dos percentuais dos s\u00f3cios deve ser 100%.");
        }
        return contratoSocial;
    }

    public void updateProprietariosDoCadastroMobiliario(CadastroMobiliario cadastroMobiliario, List<ContratoSocialPessoa> socios) {
        Vinculo vinculo = this.vinculoService.findVinculoByTipoVinculo(TipoVinculo.SOCIO);
        HashMap proprietarioByPessoa = new HashMap();
        cadastroMobiliario.getProprietarios().forEach(p -> proprietarioByPessoa.put(p.getIdPessoa(), p.getId()));
        socios.forEach(s -> proprietarioByPessoa.putIfAbsent(s.getPessoa().getId(), null));
        List proprietarios = socios.stream().map(socio -> {
            Proprietario entity = new Proprietario();
            entity.setId((Long)proprietarioByPessoa.get(socio.getPessoa().getId()));
            entity.setPessoa(socio.getPessoa());
            entity.setPrincipal(socio.getResponsavel());
            entity.setPercentual(socio.getPercentualCapital());
            entity.setVinculo(vinculo);
            entity.setCadastroGeral((CadastroGeral)cadastroMobiliario);
            return entity;
        }).collect(Collectors.toList());
        this.cadastroMobiliarioService.atualizaProprietarios(cadastroMobiliario, proprietarios);
    }
}

