/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service;

import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.tributos.domain.ModeloResposta;
import br.com.elotech.tributos.domain.rural.BoletimRural;
import br.com.elotech.tributos.dto.integracaogeomais.BoletimGeomaisDTO;
import br.com.elotech.tributos.repository.rural.BoletimRuralRepository;
import br.com.elotech.tributos.util.EloRequireNonNull;
import br.com.elotech.tributos.util.ListUtils;
import java.util.ArrayList;
import java.util.List;
import org.springframework.stereotype.Service;

@Service
public class BoletimRuralService
extends CrudService<BoletimRural, Long> {
    private final BoletimRuralRepository boletimRuralRepository;

    public BoletimRuralService(BoletimRuralRepository boletimRuralRepository) {
        this.boletimRuralRepository = boletimRuralRepository;
    }

    public List<BoletimRural> findByIdCadastroRural(Long idCadastroRural) {
        return this.boletimRuralRepository.findByIdCadastroRural(idCadastroRural);
    }

    public void merge(List<BoletimGeomaisDTO> respostas, Long idCadastroRural) {
        List boletimSalvo = this.findByIdCadastroRural(idCadastroRural);
        ArrayList boletimAlterado = new ArrayList();
        respostas.stream().map(respostaBoletim -> {
            ModeloResposta modeloResposta = (ModeloResposta)EloRequireNonNull.eloRequireNonNull((Object)((ModeloResposta)this.getEm().find(ModeloResposta.class, (Object)respostaBoletim.getResposta().getId())), (String)String.format("Modelo Resposta %s do Boletim n\u00e3o encontrado.", respostaBoletim.getResposta().getId()));
            return respostaBoletim.toEntityRural(idCadastroRural, modeloResposta);
        }).forEach(boletimAlterado::add);
        List merged = ListUtils.merge((List)boletimSalvo, boletimAlterado, boletimRural -> boletimRural.getModeloResposta().getModeloCampo(), BoletimRural::merge);
        this.boletimRuralRepository.saveAll((Iterable)merged);
    }
}

