/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralExistsElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroRuralPostElogeoDTO;
import br.com.elotech.tributos.service.integracaogeomais.CadastroRuralElogeo;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/cadastro/rural"})
public class CadastroRuralElogeoResource {
    private final CadastroRuralElogeo CadastroRuralElogeo;

    public CadastroRuralElogeoResource(CadastroRuralElogeo cadastroRuralElogeo) {
        this.CadastroRuralElogeo = cadastroRuralElogeo;
    }

    @ApiOperation(value="Retorna uma lista de todos os cadastros rurais")
    @GetMapping
    public ResponseEntity<Page<CadastroRuralElogeoDTO>> findAllDTO(Pageable page, @RequestParam(value="search", defaultValue="", required=false) String search) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.findAllElogeoDTO(page, search));
    }

    @ApiOperation(value="Retorna um cadastro Rural em espec\u00edfico")
    @GetMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroRuralElogeoDTO> findByCadastroGeralGeomaisDTO(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.findByCadastroGeralElogeoDTO(cadastroGeral));
    }

    @ApiOperation(value="Retorna se um cadastro rural em espec\u00edfico existe")
    @GetMapping(value={"/{cadastroGeral}/exists"})
    public ResponseEntity<CadastroRuralExistsElogeoDTO> exists(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.exists(cadastroGeral));
    }

    @ApiOperation(value="Altera um cadastro rural existente")
    @PutMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroRuralElogeoDTO> update(@PathVariable Long cadastroGeral, @RequestBody @Valid CadastroRuralPostElogeoDTO cadastroRuralPostEloGeoDTO) {
        return ResponseEntity.ok((Object)this.CadastroRuralElogeo.saveElogeoDTO(cadastroRuralPostEloGeoDTO, Boolean.FALSE, cadastroGeral));
    }

    @ApiOperation(value="Grava um novo cadastro rural")
    @PostMapping
    public ResponseEntity<CadastroRuralElogeoDTO> save(@RequestBody @Valid CadastroRuralPostElogeoDTO cadastroRuralPostEloGeoDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.CadastroRuralElogeo.saveElogeoDTO(cadastroRuralPostEloGeoDTO, Boolean.TRUE, null));
    }
}

