/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource.integracaogeomais;

import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralElogeoSearchDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralExistsElogeoDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CadastroGeralPostElogeoDTO;
import br.com.elotech.tributos.service.integracaogeomais.CadastroImobiliarioElogeo;
import io.swagger.annotations.ApiOperation;
import java.net.URI;
import javax.validation.Valid;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/elogeo/cadastro"})
public class CadastroGeralElogeoResource {
    private final CadastroImobiliarioElogeo cadastroImobiliarioElogeo;

    public CadastroGeralElogeoResource(CadastroImobiliarioElogeo cadastroImobiliarioElogeo) {
        this.cadastroImobiliarioElogeo = cadastroImobiliarioElogeo;
    }

    @ApiOperation(value="Retorna uma lista de todos os cadastros imobili\u00e1rios")
    @GetMapping
    public ResponseEntity<Page<CadastroGeralElogeoDTO>> findAllDTO(Pageable page, @RequestParam(value="search", defaultValue="", required=false) String search) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeo.findAllElogeoDTO(page, search));
    }

    @ApiOperation(value="Retorna um cadastro imobili\u00e1rio em espec\u00edfico")
    @GetMapping(value={"/imobiliario/{cadastroGeral}"})
    public ResponseEntity<CadastroGeralElogeoDTO> findByCadastroGeralGeomaisDTO(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeo.findByCadastroGeralElogeoDTO(cadastroGeral));
    }

    @ApiOperation(value="Altera um cadastro imobili\u00e1rio existente")
    @PutMapping(value={"/{cadastroGeral}"})
    public ResponseEntity<CadastroGeralElogeoDTO> update(@PathVariable Long cadastroGeral, @RequestBody @Valid CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeo.saveElogeoDTO(cadastroGeralPostElogeoDTO, Boolean.FALSE, cadastroGeral));
    }

    @ApiOperation(value="Grava um novo cadastro imobili\u00e1rio")
    @PostMapping
    public ResponseEntity<CadastroGeralElogeoDTO> save(@RequestBody @Valid CadastroGeralPostElogeoDTO cadastroGeralPostElogeoDTO) {
        return ResponseEntity.created((URI)URI.create("")).body((Object)this.cadastroImobiliarioElogeo.saveElogeoDTO(cadastroGeralPostElogeoDTO, Boolean.TRUE, null));
    }

    @ApiOperation(value="Retorna se um cadastro imobili\u00e1rio em espec\u00edfico existe")
    @GetMapping(value={"/imobiliario/{cadastroGeral}/exists"})
    public ResponseEntity<CadastroGeralExistsElogeoDTO> exists(@PathVariable Long cadastroGeral) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeo.exists(cadastroGeral));
    }

    @ApiOperation(value="Faz uma pesquisa espec\u00edfica pelos campos distrito, setor, quadra, lote, unidade, data de inclus\u00e3o e data de altera\u00e7\u00e3o")
    @GetMapping(value={"/imobiliario/pesquisa"})
    public ResponseEntity<Page<CadastroGeralElogeoDTO>> findByRSQL(@Valid CadastroGeralElogeoSearchDTO request, Pageable pageable) {
        return ResponseEntity.ok((Object)this.cadastroImobiliarioElogeo.findByRSQL(request.toRsqlSearch(), pageable));
    }
}

