/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.core.exception.RestException;
import br.com.elotech.core.resource.support.ReadOnlyResource;
import br.com.elotech.tributos.domain.relatorio.Relatorio;
import br.com.elotech.tributos.domain.relatorio.RelatorioPK;
import br.com.elotech.tributos.domain.relatorio.TipoRelatorio;
import br.com.elotech.tributos.dto.ImprimirRelatorioDTO;
import br.com.elotech.tributos.service.ws.AiseRelatorioService;
import java.io.IOException;
import java.io.Serializable;
import javax.servlet.http.HttpServletResponse;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.server.ResponseStatusException;

@RestController
@RequestMapping(value={"/api/relatorios"})
public class RelatorioResource
extends ReadOnlyResource<Relatorio, RelatorioPK> {
    private final AiseRelatorioService aiseRelatorioService;

    public RelatorioResource(AiseRelatorioService aiseRelatorioService) {
        this.aiseRelatorioService = aiseRelatorioService;
    }

    @GetMapping(value={"/pk/{modulo}/{tiporelatorio}/{relatorio}"})
    public ResponseEntity<Relatorio> findOne(@PathVariable(value="modulo") String modulo, @PathVariable(value="tiporelatorio") TipoRelatorio tipoRelatorio, @PathVariable(value="relatorio") Integer relatorio) {
        Relatorio entity = this.findRelatorio(modulo, tipoRelatorio, relatorio);
        return ResponseEntity.ok((Object)entity);
    }

    private Relatorio findRelatorio(String modulo, TipoRelatorio tipoRelatorio, Integer relatorio) {
        RelatorioPK pk = new RelatorioPK();
        pk.setModulo(modulo);
        pk.setTipoRelatorio(tipoRelatorio);
        pk.setRelatorio(relatorio);
        Relatorio entity = (Relatorio)this.getService().findOne((Serializable)pk);
        if (entity == null) {
            throw RestException.notFound();
        }
        return entity;
    }

    public AiseRelatorioService getAiseRelatorioService() {
        return this.aiseRelatorioService;
    }

    @PostMapping(value={"/imprimir-relatorio-generico"})
    public void imprimirRelatorioGenerico(@RequestBody ImprimirRelatorioDTO relatorioDTO, HttpServletResponse response) throws IOException {
        byte[] arquivo = this.getAiseRelatorioService().imprimirRelatorioGenerico(relatorioDTO);
        if (arquivo == null) {
            throw new ResponseStatusException(HttpStatus.BAD_REQUEST, "O relat\u00f3rio est\u00e1 inv\u00e1lido");
        }
        response.setHeader("Cache-Control", "no-cache, no-store, max-age=0, must-revalidate");
        response.setHeader("Expires", "0");
        response.setHeader("Pragma", "no-cache");
        response.setContentType("application/pdf");
        response.setContentLength(arquivo.length);
        response.getOutputStream().write(arquivo);
    }
}

