/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.resource;

import br.com.elotech.tributos.domain.DividaGrupoVencimento;
import br.com.elotech.tributos.domain.DividaGrupoVencimentoId;
import br.com.elotech.tributos.service.DividaGrupoVencimentoService;
import java.util.List;
import javax.validation.Valid;
import org.springframework.http.ResponseEntity;
import org.springframework.web.bind.annotation.DeleteMapping;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.PathVariable;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.PutMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/api/grupo-vencimento"})
public class DividaGrupoVencimentoResource {
    private final DividaGrupoVencimentoService dividaGrupoVencimentoService;

    public DividaGrupoVencimentoResource(DividaGrupoVencimentoService dividaGrupoVencimentoService) {
        this.dividaGrupoVencimentoService = dividaGrupoVencimentoService;
    }

    @GetMapping(path={"/por-divida/{idDivida}"})
    public ResponseEntity<List<DividaGrupoVencimento>> findGruposVencimento(@PathVariable Long idDivida) {
        return ResponseEntity.ok((Object)this.dividaGrupoVencimentoService.findByDividaId(idDivida));
    }

    @PostMapping(path={"/{idDivida}"})
    public ResponseEntity<DividaGrupoVencimento> save(@PathVariable Long idDivida, @RequestBody @Valid DividaGrupoVencimento dividaGrupoVencimento) {
        return ResponseEntity.ok((Object)this.dividaGrupoVencimentoService.save(idDivida, dividaGrupoVencimento));
    }

    @PutMapping(path={"/update"})
    public ResponseEntity<DividaGrupoVencimento> update(@RequestBody @Valid DividaGrupoVencimento dividaGrupoVencimento) {
        return ResponseEntity.ok((Object)this.dividaGrupoVencimentoService.update(dividaGrupoVencimento));
    }

    @DeleteMapping(value={"/{entidade}/{exercicio}/{divida}/{grupoVencimento}"})
    public ResponseEntity<Void> delete(@PathVariable Long entidade, @PathVariable Long exercicio, @PathVariable Long divida, @PathVariable Long grupoVencimento) {
        DividaGrupoVencimentoId id = DividaGrupoVencimentoId.builder().entidade(entidade).exercicio(exercicio).divida(divida).grupoVencimento(grupoVencimento).build();
        this.dividaGrupoVencimentoService.delete(id);
        return ResponseEntity.ok().build();
    }
}

