/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.repository.simam;

import br.com.elotech.core.rsql.RsqlUtils;
import br.com.elotech.core.rsql.sql.SqlWhere;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.simam.DebitoAnaliticoRequestDTO;
import br.com.elotech.tributos.dto.simam.DebitoAnaliticoSimAmDTO;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.persistence.EntityManager;
import javax.persistence.Query;
import liquibase.util.StringUtils;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.PageImpl;
import org.springframework.data.domain.Pageable;
import org.springframework.data.domain.Sort;
import org.springframework.stereotype.Repository;

@Repository
public class ConferenciaAnaliticaSimAmRepository {
    private final Map<Integer, String> sqlResource = new HashMap();
    private final EntityManager entityManager;
    private final String IGNORE_LINE = "TRUE";

    public ConferenciaAnaliticaSimAmRepository(EntityManager entityManager) {
        this.entityManager = entityManager;
        this.createSqlResource();
    }

    public Page<DebitoAnaliticoSimAmDTO> getDebitosAnalitico(DebitoAnaliticoRequestDTO request, Pageable pageable) {
        Long total = this.getQuantidadeTotalDeDebitos(request);
        List debitos = this.getDebitos(request, pageable);
        return new PageImpl(debitos, pageable, total.longValue());
    }

    private List<DebitoAnaliticoSimAmDTO> getDebitos(DebitoAnaliticoRequestDTO request, Pageable pageable) {
        Query query = this.entityManager.createNativeQuery(this.getSql(request, pageable));
        this.applyParameters(query, request);
        this.applyPagination(query, pageable);
        return query.getResultList().stream().map(DebitoAnaliticoSimAmDTO::new).collect(Collectors.toList());
    }

    private Long getQuantidadeTotalDeDebitos(DebitoAnaliticoRequestDTO request) {
        Query countQuery = this.entityManager.createNativeQuery(this.getCountSql(request, Pageable.unpaged()));
        this.applyParameters(countQuery, request);
        return Long.valueOf(countQuery.getSingleResult().toString());
    }

    private void applyParameters(Query query, DebitoAnaliticoRequestDTO request) {
        query.setParameter("dataInicial", (Object)request.getDataInicial()).setParameter("dataFinal", (Object)request.getDataFinal());
        this.buildWhereClause(request).getParams().forEach((arg_0, arg_1) -> ((Query)query).setParameter(arg_0, arg_1));
    }

    private void applyPagination(Query query, Pageable pageable) {
        int firstElementAt = pageable.getPageNumber() * pageable.getPageSize();
        query.setFirstResult(firstElementAt);
        query.setMaxResults(pageable.getPageSize());
    }

    private String getSql(DebitoAnaliticoRequestDTO request, Pageable pageable) {
        return this.getArquivo(request).replace(":whereParam", this.buildWhereClause(request).getWhere()).replace(":comDiferencaParam", this.buildHavingClause(request)).replace(":sortParam", this.buildOrderBy(pageable.getSortOr(Sort.by((String[])new String[]{"iddebito"}))));
    }

    private String getArquivo(DebitoAnaliticoRequestDTO request) {
        return FileUtils.readResourceAsString((String)((String)this.sqlResource.get(request.getIdArquivo())));
    }

    private String getCountSql(DebitoAnaliticoRequestDTO requestDTO, Pageable pageable) {
        return String.format(" WITH debitosanaliticos AS ( %s \n)\n SELECT COUNT(*) FROM debitosanaliticos ", this.getSql(requestDTO, pageable));
    }

    private String buildHavingClause(DebitoAnaliticoRequestDTO request) {
        return request.isComDiferenca() ? "SUM(valorArquivo) - SUM(valorIntegrado) <> 0" : "TRUE";
    }

    private SqlWhere buildWhereClause(DebitoAnaliticoRequestDTO request) {
        String searchInfoRsqlFormat = request.getSearchInfo();
        return !StringUtils.isEmpty((String)searchInfoRsqlFormat) ? this.tranformRsqlToSql(searchInfoRsqlFormat) : SqlWhere.of((String)"TRUE");
    }

    private String buildOrderBy(Sort sort) {
        String[] campoOrdem = sort.toString().split(":");
        return String.format("%s %s", campoOrdem[0], campoOrdem[1]);
    }

    private SqlWhere tranformRsqlToSql(String searchInfoRsqlFormat) {
        return RsqlUtils.transformToSql((String)searchInfoRsqlFormat, DebitoAnaliticoSimAmDTO.class);
    }

    private void createSqlResource() {
        this.sqlResource.put(1, "sql/simam/conferenciaanalitica/LancamentoDeCreditoAnalitico.sql");
        this.sqlResource.put(2, "sql/simam/conferenciaanalitica/EstornoLancamentoDeCreditoAnalitico.sql");
        this.sqlResource.put(3, "sql/simam/conferenciaanalitica/AtualizacaoMonetariaDeCreditoAnalitico.sql");
        this.sqlResource.put(4, "sql/simam/conferenciaanalitica/EstornoAtualizacaoMonetariaDeCreditoAnalitico.sql");
        this.sqlResource.put(5, "sql/simam/conferenciaanalitica/DeducaoDeCreditoAnalitico.sql");
        this.sqlResource.put(6, "sql/simam/conferenciaanalitica/EstornoDeducaoDeCreditoAnalitico.sql");
        this.sqlResource.put(7, "sql/simam/conferenciaanalitica/InscricaoDeCreditoEmDividaAtivaAnalitico.sql");
        this.sqlResource.put(8, "sql/simam/conferenciaanalitica/EstornoInscricaoDeCreditoEmDividaAtivaAnalitico.sql");
        this.sqlResource.put(9, "sql/simam/conferenciaanalitica/AtualizacaoMonetariaDeCreditoEmDividaAtivaAnalitico.sql");
        this.sqlResource.put(10, "sql/simam/conferenciaanalitica/EstornoAtualizacaoMonetariaDeCreditoEmDividaAtivaAnalitico.sql");
        this.sqlResource.put(11, "sql/simam/conferenciaanalitica/DeducaoDeCreditoEmDividaAtivaAnalitico.sql");
        this.sqlResource.put(12, "sql/simam/conferenciaanalitica/EstornoDeducaoDeCreditoEmDividaAtivaAnalitico.sql");
        this.sqlResource.put(13, "sql/simam/conferenciaanalitica/ArrecadacaoPorTipoDeCreditoAnalitico.sql");
        this.sqlResource.put(14, "sql/simam/conferenciaanalitica/EstornoArrecadacaoPorTipoDeCreditoAnalitico.sql");
    }
}

