/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.rastreamento;

import br.com.elotech.fluent.dataset.DatasetRecord;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Proprietario;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCertidaoDebitos;
import br.com.elotech.tributos.dto.RastreamentoCadastroDTO;
import br.com.elotech.tributos.dto.RastreamentoDebitoDTO;
import java.math.BigDecimal;
import java.util.List;
import java.util.Optional;
import lombok.Generated;

public class RastreamentoCadastroImpressaoDTO
implements DatasetRecord {
    private static final String PROPRIETARIO = "PROPRIETARIO";
    private Long idCadastro;
    private Long tipoCadastro;
    private Long cadastroGeral;
    private Long id;
    private String cpfCnpj;
    private Long pessoa;
    private String nome;
    private String tipoPessoa;
    private String vinculoDescricao;
    private Boolean principal;
    private String situacao;
    private TipoCertidaoDebitos tipoCertidaoDebitos;
    private String situacaoSGO;
    private Boolean recursoAdministrativo;
    private BigDecimal totalValorDebitos;
    private List<RastreamentoDebitoDTO> debitosVencidos;

    public static RastreamentoCadastroImpressaoDTO toRastreamentoCadastroImpressaoDTO(RastreamentoCadastroDTO cadastro) {
        RastreamentoCadastroImpressaoDTO cadastroImpressao = new RastreamentoCadastroImpressaoDTO();
        cadastroImpressao.setId(cadastro.getId());
        cadastroImpressao.setIdCadastro(cadastro.getIdCadastro());
        cadastroImpressao.setTipoCadastro(cadastro.getTipoCadastro());
        cadastroImpressao.setCadastroGeral(cadastro.getCadastroGeral());
        cadastroImpressao.setCpfCnpj(cadastro.getCpfCnpj());
        cadastroImpressao.setSituacao(cadastro.getSituacao());
        cadastroImpressao.setTipoCertidaoDebitos(cadastro.getTipoCertidaoDebitos());
        cadastroImpressao.setSituacaoSGO(cadastro.getSituacaoSGO());
        cadastroImpressao.setRecursoAdministrativo(cadastro.isRecursoAdministrativo());
        return cadastroImpressao;
    }

    public void preencheDadosProprietario(Optional<Proprietario> proprietario, Pessoa pessoa) {
        if (proprietario.isPresent()) {
            Optional.ofNullable(proprietario.get().getPessoa().getId()).ifPresent(arg_0 -> this.setPessoa(arg_0));
            Optional.ofNullable(proprietario.get().getPessoa().getNome()).ifPresent(arg_0 -> this.setNome(arg_0));
            Optional.ofNullable(proprietario.get().getPessoa().getTipoPessoa()).ifPresent(tp -> this.setTipoPessoa(tp.getDescricao()));
            Optional.ofNullable(proprietario.get().getPrincipal()).ifPresent(arg_0 -> this.setPrincipal(arg_0));
            String vinculoDesc = Optional.ofNullable(proprietario.get().getVinculo()).map(vinculo -> TipoCadastro.IMOBILIARIO.getValue().equals(this.tipoCadastro) ? vinculo.getDescricao() : PROPRIETARIO).orElse(PROPRIETARIO);
            this.setVinculoDescricao(vinculoDesc);
            return;
        }
        this.setVinculoDescricao(PROPRIETARIO);
        this.setPrincipal(Boolean.TRUE);
        this.setPessoa(pessoa.getId());
        this.setNome(pessoa.getNome());
        Optional.ofNullable(pessoa.getTipoPessoa()).ifPresent(tp -> this.setTipoPessoa(tp.getDescricao()));
    }

    @Generated
    public RastreamentoCadastroImpressaoDTO() {
    }

    @Generated
    public Long getIdCadastro() {
        return this.idCadastro;
    }

    @Generated
    public Long getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public Long getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public String getCpfCnpj() {
        return this.cpfCnpj;
    }

    @Generated
    public Long getPessoa() {
        return this.pessoa;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getVinculoDescricao() {
        return this.vinculoDescricao;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public TipoCertidaoDebitos getTipoCertidaoDebitos() {
        return this.tipoCertidaoDebitos;
    }

    @Generated
    public String getSituacaoSGO() {
        return this.situacaoSGO;
    }

    @Generated
    public Boolean getRecursoAdministrativo() {
        return this.recursoAdministrativo;
    }

    @Generated
    public BigDecimal getTotalValorDebitos() {
        return this.totalValorDebitos;
    }

    @Generated
    public List<RastreamentoDebitoDTO> getDebitosVencidos() {
        return this.debitosVencidos;
    }

    @Generated
    public void setIdCadastro(Long idCadastro) {
        this.idCadastro = idCadastro;
    }

    @Generated
    public void setTipoCadastro(Long tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(Long cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCpfCnpj(String cpfCnpj) {
        this.cpfCnpj = cpfCnpj;
    }

    @Generated
    public void setPessoa(Long pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setTipoPessoa(String tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setVinculoDescricao(String vinculoDescricao) {
        this.vinculoDescricao = vinculoDescricao;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setTipoCertidaoDebitos(TipoCertidaoDebitos tipoCertidaoDebitos) {
        this.tipoCertidaoDebitos = tipoCertidaoDebitos;
    }

    @Generated
    public void setSituacaoSGO(String situacaoSGO) {
        this.situacaoSGO = situacaoSGO;
    }

    @Generated
    public void setRecursoAdministrativo(Boolean recursoAdministrativo) {
        this.recursoAdministrativo = recursoAdministrativo;
    }

    @Generated
    public void setTotalValorDebitos(BigDecimal totalValorDebitos) {
        this.totalValorDebitos = totalValorDebitos;
    }

    @Generated
    public void setDebitosVencidos(List<RastreamentoDebitoDTO> debitosVencidos) {
        this.debitosVencidos = debitosVencidos;
    }

    @Generated
    public String toString() {
        return "RastreamentoCadastroImpressaoDTO(idCadastro=" + this.getIdCadastro() + ", tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", id=" + this.getId() + ", cpfCnpj=" + this.getCpfCnpj() + ", pessoa=" + this.getPessoa() + ", nome=" + this.getNome() + ", tipoPessoa=" + this.getTipoPessoa() + ", vinculoDescricao=" + this.getVinculoDescricao() + ", principal=" + this.getPrincipal() + ", situacao=" + this.getSituacao() + ", tipoCertidaoDebitos=" + this.getTipoCertidaoDebitos() + ", situacaoSGO=" + this.getSituacaoSGO() + ", recursoAdministrativo=" + this.getRecursoAdministrativo() + ", totalValorDebitos=" + this.getTotalValorDebitos() + ", debitosVencidos=" + this.getDebitosVencidos() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof RastreamentoCadastroImpressaoDTO)) {
            return false;
        }
        RastreamentoCadastroImpressaoDTO other = (RastreamentoCadastroImpressaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof RastreamentoCadastroImpressaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

