/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaoprotestocra;

import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Documento;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.UnidadeFederacao;
import br.com.elotech.tributos.domain.protesto.Protesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.dto.EntidadeDTO;
import br.com.elotech.tributos.dto.integracaoprotestocra.CraComarcaTransacaoDTO;
import br.com.elotech.tributos.util.StringUtils;
import java.math.BigDecimal;
import java.time.format.DateTimeFormatter;
import java.util.Optional;
import javax.xml.bind.annotation.XmlAccessType;
import javax.xml.bind.annotation.XmlAccessorType;
import javax.xml.bind.annotation.XmlAttribute;
import lombok.Generated;

/*
 * Exception performing whole class analysis ignored.
 */
@XmlAccessorType(value=XmlAccessType.FIELD)
public class CraComarcaTransacaoDTO {
    @XmlAttribute(name="t01")
    private String idTransacao;
    @XmlAttribute(name="t02")
    private String codApresentante;
    @XmlAttribute(name="t03")
    private String codCedenteTitulo;
    @XmlAttribute(name="t04")
    private String nomeCedente;
    @XmlAttribute(name="t05")
    private String nomeSacador;
    @XmlAttribute(name="t06")
    private String numCnpjSacador;
    @XmlAttribute(name="t07")
    private String enderecoSacador;
    @XmlAttribute(name="t08")
    private String cepSacador;
    @XmlAttribute(name="t09")
    private String cidadeSacador;
    @XmlAttribute(name="t10")
    private String ufSacador;
    @XmlAttribute(name="t11")
    private Long nossoNumero;
    @XmlAttribute(name="t12")
    private String especieTitulo;
    @XmlAttribute(name="t13")
    private String numTitulo;
    @XmlAttribute(name="t14")
    private String dataEmissaoTitulo;
    @XmlAttribute(name="t15")
    private String dataVencimentoTitulo;
    @XmlAttribute(name="t16")
    private String tipoMoeda;
    @XmlAttribute(name="t17")
    private BigDecimal valorTitulo;
    @XmlAttribute(name="t18")
    private BigDecimal saldoTitulo;
    @XmlAttribute(name="t19")
    private String pracaPagamento;
    @XmlAttribute(name="t20")
    private String tipoEndosso;
    @XmlAttribute(name="t21")
    private String infoAceite;
    @XmlAttribute(name="t22")
    private Long sequencialDevedoresNoMesmoTitulo;
    @XmlAttribute(name="t23")
    private String nomeDevedor;
    @XmlAttribute(name="t24")
    private String tipoDocumentoDevedor;
    @XmlAttribute(name="t25")
    private String numDocumentoDevedor;
    @XmlAttribute(name="t26")
    private String rg;
    @XmlAttribute(name="t27")
    private String enderecoDevedor;
    @XmlAttribute(name="t28")
    private String cepDevedor;
    @XmlAttribute(name="t29")
    private String cidadeDevedor;
    @XmlAttribute(name="t30")
    private String ufDevedor;
    @XmlAttribute(name="t31")
    private String codCartorio;
    @XmlAttribute(name="t32")
    private String numProtocoloCartorio;
    @XmlAttribute(name="t33")
    private String tipoOcorrencia;
    @XmlAttribute(name="t34")
    private String dataProtocolo;
    @XmlAttribute(name="t35")
    private String valorCustasCartorio;
    @XmlAttribute(name="t36")
    private String declaracaoPortador;
    @XmlAttribute(name="t37")
    private String dataOcorrencia;
    @XmlAttribute(name="t38")
    private String codIrregularidade;
    @XmlAttribute(name="t39")
    private String bairroDevedor;
    @XmlAttribute(name="t40")
    private String valorCustasCartorioDistribuidor;
    @XmlAttribute(name="t41")
    private String registroDistribuicao;
    @XmlAttribute(name="t42")
    private String valorGravacaoEletronicaEDemaisDespesas;
    @XmlAttribute(name="t43")
    private String numOperacaoBanco;
    @XmlAttribute(name="t44")
    private String numContratoBanco;
    @XmlAttribute(name="t45")
    private String numParcelaContrato;
    @XmlAttribute(name="t46")
    private String tipoLetraCambio;
    @XmlAttribute(name="t47")
    private String complementoCodIrregularidade;
    @XmlAttribute(name="t48")
    private String protestoPorMotivoFalencia;
    @XmlAttribute(name="t49")
    private String instrumentoDeProtesto;
    @XmlAttribute(name="t50")
    private String valorDemaisDespesas;
    @XmlAttribute(name="t51")
    private String imagemDocumentos;
    @XmlAttribute(name="t52")
    private Long sequencialRegistro;

    public static CraComarcaTransacaoDTO from(ProtestoRemessaItem protestoRemessaItem, String imagemDocumentos, String codApresentante, String pracaPagamento, EntidadeDTO entidade, String dataVencimentoTitulo, Long sequencialDevedoresNoMesmoTitulo, Long sequencialRegistro) {
        Optional<Protesto> protesto = Optional.ofNullable(protestoRemessaItem.getProtesto());
        Optional<Documento> documento = protesto.map(Protesto::getDocumento);
        Optional<Pessoa> pessoa = documento.map(Documento::getPessoa);
        Optional<EnderecoPessoa> endereco = pessoa.map(Pessoa::getEnderecoPrincipal);
        Optional<Logradouro> logradouro = endereco.map(EnderecoPessoa::getLogradouro);
        Optional<Cidade> cidade = endereco.map(EnderecoPessoa::getCidade);
        Optional<UnidadeFederacao> uf = endereco.map(EnderecoPessoa::getUnidadeFederacao);
        Optional<Bairro> bairro = endereco.map(EnderecoPessoa::getBairro);
        return CraComarcaTransacaoDTO.builder().codApresentante(codApresentante).nomeCedente(StringUtils.retiraAcentos((String)Optional.ofNullable(entidade.getNome()).orElse(""))).nomeSacador(StringUtils.retiraAcentos((String)Optional.ofNullable(entidade.getNome()).orElse(""))).numCnpjSacador(Optional.ofNullable(entidade.getCnpj()).map(cnpj -> cnpj.replaceAll("\\D", "")).orElse("")).enderecoSacador(StringUtils.retiraAcentos((String)String.format("%s %s", Optional.ofNullable(entidade.getLogradouro()).orElse(""), Optional.ofNullable(entidade.getNumero()).orElse("")).trim())).cepSacador(Optional.ofNullable(entidade.getCep()).map(cep -> cep.replaceAll("\\D", "")).orElse("")).cidadeSacador(StringUtils.retiraAcentos((String)Optional.ofNullable(entidade.getCidade()).orElse(""))).ufSacador(Optional.ofNullable(entidade.getUnidadeFederacao()).orElse("")).nossoNumero(protestoRemessaItem.getId()).numTitulo(String.format("%d%d", protestoRemessaItem.getExercicioDocumento(), protestoRemessaItem.getDocumento())).dataEmissaoTitulo(protesto.map(Protesto::getDataEmissao).map(dataEmissao -> dataEmissao.format(DateTimeFormatter.ofPattern("ddMMyyyy"))).orElse("")).dataVencimentoTitulo(dataVencimentoTitulo).valorTitulo(documento.map(Documento::getValorTotalDividaAtivas).orElse(BigDecimal.ZERO)).saldoTitulo(documento.map(Documento::getValorTotalDividaAtivas).orElse(BigDecimal.ZERO)).pracaPagamento(StringUtils.retiraAcentos((String)pracaPagamento)).sequencialDevedoresNoMesmoTitulo(sequencialDevedoresNoMesmoTitulo).nomeDevedor(StringUtils.retiraAcentos((String)pessoa.map(Pessoa::getNome).orElse(""))).tipoDocumentoDevedor(TipoPessoa.JURIDICA.equals(pessoa.map(Pessoa::getTipoPessoa).orElse(null)) ? "001" : "002").numDocumentoDevedor(documento.map(Documento::getCnpjCpf).orElse("")).enderecoDevedor(StringUtils.retiraAcentos((String)String.format("%s %s %s %s", logradouro.map(Logradouro::getTipoLogradouroDescricao).orElse("").trim(), logradouro.map(Logradouro::getDescricao).orElse("").trim(), endereco.map(EnderecoPessoa::getNumero).orElse("").trim(), endereco.map(EnderecoPessoa::getComplemento).orElse("").trim()))).cepDevedor(endereco.map(EnderecoPessoa::getCep).map(Object::toString).orElse("")).cidadeDevedor(StringUtils.retiraAcentos((String)cidade.map(Cidade::getDescricao).orElse(""))).ufDevedor(uf.map(UnidadeFederacao::getUnidadeFederacao).orElse("")).bairroDevedor(StringUtils.retiraAcentos((String)bairro.map(Bairro::getDescricao).orElse(""))).imagemDocumentos(imagemDocumentos).sequencialRegistro(sequencialRegistro).build();
    }

    @Generated
    private static String $default$idTransacao() {
        return "1";
    }

    @Generated
    private static String $default$codCedenteTitulo() {
        return "0";
    }

    @Generated
    private static String $default$especieTitulo() {
        return "CDA";
    }

    @Generated
    private static String $default$tipoMoeda() {
        return "001";
    }

    @Generated
    private static String $default$tipoEndosso() {
        return "";
    }

    @Generated
    private static String $default$infoAceite() {
        return "";
    }

    @Generated
    private static String $default$rg() {
        return "";
    }

    @Generated
    private static String $default$codCartorio() {
        return "0";
    }

    @Generated
    private static String $default$numProtocoloCartorio() {
        return "0";
    }

    @Generated
    private static String $default$tipoOcorrencia() {
        return "";
    }

    @Generated
    private static String $default$dataProtocolo() {
        return "0";
    }

    @Generated
    private static String $default$valorCustasCartorio() {
        return "0";
    }

    @Generated
    private static String $default$declaracaoPortador() {
        return "I";
    }

    @Generated
    private static String $default$dataOcorrencia() {
        return "0";
    }

    @Generated
    private static String $default$codIrregularidade() {
        return "";
    }

    @Generated
    private static String $default$valorCustasCartorioDistribuidor() {
        return "0";
    }

    @Generated
    private static String $default$registroDistribuicao() {
        return "0";
    }

    @Generated
    private static String $default$valorGravacaoEletronicaEDemaisDespesas() {
        return "0";
    }

    @Generated
    private static String $default$numOperacaoBanco() {
        return "0";
    }

    @Generated
    private static String $default$numContratoBanco() {
        return "0";
    }

    @Generated
    private static String $default$numParcelaContrato() {
        return "0";
    }

    @Generated
    private static String $default$tipoLetraCambio() {
        return "0";
    }

    @Generated
    private static String $default$complementoCodIrregularidade() {
        return "";
    }

    @Generated
    private static String $default$protestoPorMotivoFalencia() {
        return "";
    }

    @Generated
    private static String $default$instrumentoDeProtesto() {
        return "";
    }

    @Generated
    private static String $default$valorDemaisDespesas() {
        return "0";
    }

    @Generated
    public static CraComarcaTransacaoDTOBuilder builder() {
        return new CraComarcaTransacaoDTOBuilder();
    }

    @Generated
    public String getIdTransacao() {
        return this.idTransacao;
    }

    @Generated
    public String getCodApresentante() {
        return this.codApresentante;
    }

    @Generated
    public String getCodCedenteTitulo() {
        return this.codCedenteTitulo;
    }

    @Generated
    public String getNomeCedente() {
        return this.nomeCedente;
    }

    @Generated
    public String getNomeSacador() {
        return this.nomeSacador;
    }

    @Generated
    public String getNumCnpjSacador() {
        return this.numCnpjSacador;
    }

    @Generated
    public String getEnderecoSacador() {
        return this.enderecoSacador;
    }

    @Generated
    public String getCepSacador() {
        return this.cepSacador;
    }

    @Generated
    public String getCidadeSacador() {
        return this.cidadeSacador;
    }

    @Generated
    public String getUfSacador() {
        return this.ufSacador;
    }

    @Generated
    public Long getNossoNumero() {
        return this.nossoNumero;
    }

    @Generated
    public String getEspecieTitulo() {
        return this.especieTitulo;
    }

    @Generated
    public String getNumTitulo() {
        return this.numTitulo;
    }

    @Generated
    public String getDataEmissaoTitulo() {
        return this.dataEmissaoTitulo;
    }

    @Generated
    public String getDataVencimentoTitulo() {
        return this.dataVencimentoTitulo;
    }

    @Generated
    public String getTipoMoeda() {
        return this.tipoMoeda;
    }

    @Generated
    public BigDecimal getValorTitulo() {
        return this.valorTitulo;
    }

    @Generated
    public BigDecimal getSaldoTitulo() {
        return this.saldoTitulo;
    }

    @Generated
    public String getPracaPagamento() {
        return this.pracaPagamento;
    }

    @Generated
    public String getTipoEndosso() {
        return this.tipoEndosso;
    }

    @Generated
    public String getInfoAceite() {
        return this.infoAceite;
    }

    @Generated
    public Long getSequencialDevedoresNoMesmoTitulo() {
        return this.sequencialDevedoresNoMesmoTitulo;
    }

    @Generated
    public String getNomeDevedor() {
        return this.nomeDevedor;
    }

    @Generated
    public String getTipoDocumentoDevedor() {
        return this.tipoDocumentoDevedor;
    }

    @Generated
    public String getNumDocumentoDevedor() {
        return this.numDocumentoDevedor;
    }

    @Generated
    public String getRg() {
        return this.rg;
    }

    @Generated
    public String getEnderecoDevedor() {
        return this.enderecoDevedor;
    }

    @Generated
    public String getCepDevedor() {
        return this.cepDevedor;
    }

    @Generated
    public String getCidadeDevedor() {
        return this.cidadeDevedor;
    }

    @Generated
    public String getUfDevedor() {
        return this.ufDevedor;
    }

    @Generated
    public String getCodCartorio() {
        return this.codCartorio;
    }

    @Generated
    public String getNumProtocoloCartorio() {
        return this.numProtocoloCartorio;
    }

    @Generated
    public String getTipoOcorrencia() {
        return this.tipoOcorrencia;
    }

    @Generated
    public String getDataProtocolo() {
        return this.dataProtocolo;
    }

    @Generated
    public String getValorCustasCartorio() {
        return this.valorCustasCartorio;
    }

    @Generated
    public String getDeclaracaoPortador() {
        return this.declaracaoPortador;
    }

    @Generated
    public String getDataOcorrencia() {
        return this.dataOcorrencia;
    }

    @Generated
    public String getCodIrregularidade() {
        return this.codIrregularidade;
    }

    @Generated
    public String getBairroDevedor() {
        return this.bairroDevedor;
    }

    @Generated
    public String getValorCustasCartorioDistribuidor() {
        return this.valorCustasCartorioDistribuidor;
    }

    @Generated
    public String getRegistroDistribuicao() {
        return this.registroDistribuicao;
    }

    @Generated
    public String getValorGravacaoEletronicaEDemaisDespesas() {
        return this.valorGravacaoEletronicaEDemaisDespesas;
    }

    @Generated
    public String getNumOperacaoBanco() {
        return this.numOperacaoBanco;
    }

    @Generated
    public String getNumContratoBanco() {
        return this.numContratoBanco;
    }

    @Generated
    public String getNumParcelaContrato() {
        return this.numParcelaContrato;
    }

    @Generated
    public String getTipoLetraCambio() {
        return this.tipoLetraCambio;
    }

    @Generated
    public String getComplementoCodIrregularidade() {
        return this.complementoCodIrregularidade;
    }

    @Generated
    public String getProtestoPorMotivoFalencia() {
        return this.protestoPorMotivoFalencia;
    }

    @Generated
    public String getInstrumentoDeProtesto() {
        return this.instrumentoDeProtesto;
    }

    @Generated
    public String getValorDemaisDespesas() {
        return this.valorDemaisDespesas;
    }

    @Generated
    public String getImagemDocumentos() {
        return this.imagemDocumentos;
    }

    @Generated
    public Long getSequencialRegistro() {
        return this.sequencialRegistro;
    }

    @Generated
    public void setIdTransacao(String idTransacao) {
        this.idTransacao = idTransacao;
    }

    @Generated
    public void setCodApresentante(String codApresentante) {
        this.codApresentante = codApresentante;
    }

    @Generated
    public void setCodCedenteTitulo(String codCedenteTitulo) {
        this.codCedenteTitulo = codCedenteTitulo;
    }

    @Generated
    public void setNomeCedente(String nomeCedente) {
        this.nomeCedente = nomeCedente;
    }

    @Generated
    public void setNomeSacador(String nomeSacador) {
        this.nomeSacador = nomeSacador;
    }

    @Generated
    public void setNumCnpjSacador(String numCnpjSacador) {
        this.numCnpjSacador = numCnpjSacador;
    }

    @Generated
    public void setEnderecoSacador(String enderecoSacador) {
        this.enderecoSacador = enderecoSacador;
    }

    @Generated
    public void setCepSacador(String cepSacador) {
        this.cepSacador = cepSacador;
    }

    @Generated
    public void setCidadeSacador(String cidadeSacador) {
        this.cidadeSacador = cidadeSacador;
    }

    @Generated
    public void setUfSacador(String ufSacador) {
        this.ufSacador = ufSacador;
    }

    @Generated
    public void setNossoNumero(Long nossoNumero) {
        this.nossoNumero = nossoNumero;
    }

    @Generated
    public void setEspecieTitulo(String especieTitulo) {
        this.especieTitulo = especieTitulo;
    }

    @Generated
    public void setNumTitulo(String numTitulo) {
        this.numTitulo = numTitulo;
    }

    @Generated
    public void setDataEmissaoTitulo(String dataEmissaoTitulo) {
        this.dataEmissaoTitulo = dataEmissaoTitulo;
    }

    @Generated
    public void setDataVencimentoTitulo(String dataVencimentoTitulo) {
        this.dataVencimentoTitulo = dataVencimentoTitulo;
    }

    @Generated
    public void setTipoMoeda(String tipoMoeda) {
        this.tipoMoeda = tipoMoeda;
    }

    @Generated
    public void setValorTitulo(BigDecimal valorTitulo) {
        this.valorTitulo = valorTitulo;
    }

    @Generated
    public void setSaldoTitulo(BigDecimal saldoTitulo) {
        this.saldoTitulo = saldoTitulo;
    }

    @Generated
    public void setPracaPagamento(String pracaPagamento) {
        this.pracaPagamento = pracaPagamento;
    }

    @Generated
    public void setTipoEndosso(String tipoEndosso) {
        this.tipoEndosso = tipoEndosso;
    }

    @Generated
    public void setInfoAceite(String infoAceite) {
        this.infoAceite = infoAceite;
    }

    @Generated
    public void setSequencialDevedoresNoMesmoTitulo(Long sequencialDevedoresNoMesmoTitulo) {
        this.sequencialDevedoresNoMesmoTitulo = sequencialDevedoresNoMesmoTitulo;
    }

    @Generated
    public void setNomeDevedor(String nomeDevedor) {
        this.nomeDevedor = nomeDevedor;
    }

    @Generated
    public void setTipoDocumentoDevedor(String tipoDocumentoDevedor) {
        this.tipoDocumentoDevedor = tipoDocumentoDevedor;
    }

    @Generated
    public void setNumDocumentoDevedor(String numDocumentoDevedor) {
        this.numDocumentoDevedor = numDocumentoDevedor;
    }

    @Generated
    public void setRg(String rg) {
        this.rg = rg;
    }

    @Generated
    public void setEnderecoDevedor(String enderecoDevedor) {
        this.enderecoDevedor = enderecoDevedor;
    }

    @Generated
    public void setCepDevedor(String cepDevedor) {
        this.cepDevedor = cepDevedor;
    }

    @Generated
    public void setCidadeDevedor(String cidadeDevedor) {
        this.cidadeDevedor = cidadeDevedor;
    }

    @Generated
    public void setUfDevedor(String ufDevedor) {
        this.ufDevedor = ufDevedor;
    }

    @Generated
    public void setCodCartorio(String codCartorio) {
        this.codCartorio = codCartorio;
    }

    @Generated
    public void setNumProtocoloCartorio(String numProtocoloCartorio) {
        this.numProtocoloCartorio = numProtocoloCartorio;
    }

    @Generated
    public void setTipoOcorrencia(String tipoOcorrencia) {
        this.tipoOcorrencia = tipoOcorrencia;
    }

    @Generated
    public void setDataProtocolo(String dataProtocolo) {
        this.dataProtocolo = dataProtocolo;
    }

    @Generated
    public void setValorCustasCartorio(String valorCustasCartorio) {
        this.valorCustasCartorio = valorCustasCartorio;
    }

    @Generated
    public void setDeclaracaoPortador(String declaracaoPortador) {
        this.declaracaoPortador = declaracaoPortador;
    }

    @Generated
    public void setDataOcorrencia(String dataOcorrencia) {
        this.dataOcorrencia = dataOcorrencia;
    }

    @Generated
    public void setCodIrregularidade(String codIrregularidade) {
        this.codIrregularidade = codIrregularidade;
    }

    @Generated
    public void setBairroDevedor(String bairroDevedor) {
        this.bairroDevedor = bairroDevedor;
    }

    @Generated
    public void setValorCustasCartorioDistribuidor(String valorCustasCartorioDistribuidor) {
        this.valorCustasCartorioDistribuidor = valorCustasCartorioDistribuidor;
    }

    @Generated
    public void setRegistroDistribuicao(String registroDistribuicao) {
        this.registroDistribuicao = registroDistribuicao;
    }

    @Generated
    public void setValorGravacaoEletronicaEDemaisDespesas(String valorGravacaoEletronicaEDemaisDespesas) {
        this.valorGravacaoEletronicaEDemaisDespesas = valorGravacaoEletronicaEDemaisDespesas;
    }

    @Generated
    public void setNumOperacaoBanco(String numOperacaoBanco) {
        this.numOperacaoBanco = numOperacaoBanco;
    }

    @Generated
    public void setNumContratoBanco(String numContratoBanco) {
        this.numContratoBanco = numContratoBanco;
    }

    @Generated
    public void setNumParcelaContrato(String numParcelaContrato) {
        this.numParcelaContrato = numParcelaContrato;
    }

    @Generated
    public void setTipoLetraCambio(String tipoLetraCambio) {
        this.tipoLetraCambio = tipoLetraCambio;
    }

    @Generated
    public void setComplementoCodIrregularidade(String complementoCodIrregularidade) {
        this.complementoCodIrregularidade = complementoCodIrregularidade;
    }

    @Generated
    public void setProtestoPorMotivoFalencia(String protestoPorMotivoFalencia) {
        this.protestoPorMotivoFalencia = protestoPorMotivoFalencia;
    }

    @Generated
    public void setInstrumentoDeProtesto(String instrumentoDeProtesto) {
        this.instrumentoDeProtesto = instrumentoDeProtesto;
    }

    @Generated
    public void setValorDemaisDespesas(String valorDemaisDespesas) {
        this.valorDemaisDespesas = valorDemaisDespesas;
    }

    @Generated
    public void setImagemDocumentos(String imagemDocumentos) {
        this.imagemDocumentos = imagemDocumentos;
    }

    @Generated
    public void setSequencialRegistro(Long sequencialRegistro) {
        this.sequencialRegistro = sequencialRegistro;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CraComarcaTransacaoDTO)) {
            return false;
        }
        CraComarcaTransacaoDTO other = (CraComarcaTransacaoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$nossoNumero = this.getNossoNumero();
        Long other$nossoNumero = other.getNossoNumero();
        if (this$nossoNumero == null ? other$nossoNumero != null : !((Object)this$nossoNumero).equals(other$nossoNumero)) {
            return false;
        }
        Long this$sequencialDevedoresNoMesmoTitulo = this.getSequencialDevedoresNoMesmoTitulo();
        Long other$sequencialDevedoresNoMesmoTitulo = other.getSequencialDevedoresNoMesmoTitulo();
        if (this$sequencialDevedoresNoMesmoTitulo == null ? other$sequencialDevedoresNoMesmoTitulo != null : !((Object)this$sequencialDevedoresNoMesmoTitulo).equals(other$sequencialDevedoresNoMesmoTitulo)) {
            return false;
        }
        Long this$sequencialRegistro = this.getSequencialRegistro();
        Long other$sequencialRegistro = other.getSequencialRegistro();
        if (this$sequencialRegistro == null ? other$sequencialRegistro != null : !((Object)this$sequencialRegistro).equals(other$sequencialRegistro)) {
            return false;
        }
        String this$idTransacao = this.getIdTransacao();
        String other$idTransacao = other.getIdTransacao();
        if (this$idTransacao == null ? other$idTransacao != null : !this$idTransacao.equals(other$idTransacao)) {
            return false;
        }
        String this$codApresentante = this.getCodApresentante();
        String other$codApresentante = other.getCodApresentante();
        if (this$codApresentante == null ? other$codApresentante != null : !this$codApresentante.equals(other$codApresentante)) {
            return false;
        }
        String this$codCedenteTitulo = this.getCodCedenteTitulo();
        String other$codCedenteTitulo = other.getCodCedenteTitulo();
        if (this$codCedenteTitulo == null ? other$codCedenteTitulo != null : !this$codCedenteTitulo.equals(other$codCedenteTitulo)) {
            return false;
        }
        String this$nomeCedente = this.getNomeCedente();
        String other$nomeCedente = other.getNomeCedente();
        if (this$nomeCedente == null ? other$nomeCedente != null : !this$nomeCedente.equals(other$nomeCedente)) {
            return false;
        }
        String this$nomeSacador = this.getNomeSacador();
        String other$nomeSacador = other.getNomeSacador();
        if (this$nomeSacador == null ? other$nomeSacador != null : !this$nomeSacador.equals(other$nomeSacador)) {
            return false;
        }
        String this$numCnpjSacador = this.getNumCnpjSacador();
        String other$numCnpjSacador = other.getNumCnpjSacador();
        if (this$numCnpjSacador == null ? other$numCnpjSacador != null : !this$numCnpjSacador.equals(other$numCnpjSacador)) {
            return false;
        }
        String this$enderecoSacador = this.getEnderecoSacador();
        String other$enderecoSacador = other.getEnderecoSacador();
        if (this$enderecoSacador == null ? other$enderecoSacador != null : !this$enderecoSacador.equals(other$enderecoSacador)) {
            return false;
        }
        String this$cepSacador = this.getCepSacador();
        String other$cepSacador = other.getCepSacador();
        if (this$cepSacador == null ? other$cepSacador != null : !this$cepSacador.equals(other$cepSacador)) {
            return false;
        }
        String this$cidadeSacador = this.getCidadeSacador();
        String other$cidadeSacador = other.getCidadeSacador();
        if (this$cidadeSacador == null ? other$cidadeSacador != null : !this$cidadeSacador.equals(other$cidadeSacador)) {
            return false;
        }
        String this$ufSacador = this.getUfSacador();
        String other$ufSacador = other.getUfSacador();
        if (this$ufSacador == null ? other$ufSacador != null : !this$ufSacador.equals(other$ufSacador)) {
            return false;
        }
        String this$especieTitulo = this.getEspecieTitulo();
        String other$especieTitulo = other.getEspecieTitulo();
        if (this$especieTitulo == null ? other$especieTitulo != null : !this$especieTitulo.equals(other$especieTitulo)) {
            return false;
        }
        String this$numTitulo = this.getNumTitulo();
        String other$numTitulo = other.getNumTitulo();
        if (this$numTitulo == null ? other$numTitulo != null : !this$numTitulo.equals(other$numTitulo)) {
            return false;
        }
        String this$dataEmissaoTitulo = this.getDataEmissaoTitulo();
        String other$dataEmissaoTitulo = other.getDataEmissaoTitulo();
        if (this$dataEmissaoTitulo == null ? other$dataEmissaoTitulo != null : !this$dataEmissaoTitulo.equals(other$dataEmissaoTitulo)) {
            return false;
        }
        String this$dataVencimentoTitulo = this.getDataVencimentoTitulo();
        String other$dataVencimentoTitulo = other.getDataVencimentoTitulo();
        if (this$dataVencimentoTitulo == null ? other$dataVencimentoTitulo != null : !this$dataVencimentoTitulo.equals(other$dataVencimentoTitulo)) {
            return false;
        }
        String this$tipoMoeda = this.getTipoMoeda();
        String other$tipoMoeda = other.getTipoMoeda();
        if (this$tipoMoeda == null ? other$tipoMoeda != null : !this$tipoMoeda.equals(other$tipoMoeda)) {
            return false;
        }
        BigDecimal this$valorTitulo = this.getValorTitulo();
        BigDecimal other$valorTitulo = other.getValorTitulo();
        if (this$valorTitulo == null ? other$valorTitulo != null : !((Object)this$valorTitulo).equals(other$valorTitulo)) {
            return false;
        }
        BigDecimal this$saldoTitulo = this.getSaldoTitulo();
        BigDecimal other$saldoTitulo = other.getSaldoTitulo();
        if (this$saldoTitulo == null ? other$saldoTitulo != null : !((Object)this$saldoTitulo).equals(other$saldoTitulo)) {
            return false;
        }
        String this$pracaPagamento = this.getPracaPagamento();
        String other$pracaPagamento = other.getPracaPagamento();
        if (this$pracaPagamento == null ? other$pracaPagamento != null : !this$pracaPagamento.equals(other$pracaPagamento)) {
            return false;
        }
        String this$tipoEndosso = this.getTipoEndosso();
        String other$tipoEndosso = other.getTipoEndosso();
        if (this$tipoEndosso == null ? other$tipoEndosso != null : !this$tipoEndosso.equals(other$tipoEndosso)) {
            return false;
        }
        String this$infoAceite = this.getInfoAceite();
        String other$infoAceite = other.getInfoAceite();
        if (this$infoAceite == null ? other$infoAceite != null : !this$infoAceite.equals(other$infoAceite)) {
            return false;
        }
        String this$nomeDevedor = this.getNomeDevedor();
        String other$nomeDevedor = other.getNomeDevedor();
        if (this$nomeDevedor == null ? other$nomeDevedor != null : !this$nomeDevedor.equals(other$nomeDevedor)) {
            return false;
        }
        String this$tipoDocumentoDevedor = this.getTipoDocumentoDevedor();
        String other$tipoDocumentoDevedor = other.getTipoDocumentoDevedor();
        if (this$tipoDocumentoDevedor == null ? other$tipoDocumentoDevedor != null : !this$tipoDocumentoDevedor.equals(other$tipoDocumentoDevedor)) {
            return false;
        }
        String this$numDocumentoDevedor = this.getNumDocumentoDevedor();
        String other$numDocumentoDevedor = other.getNumDocumentoDevedor();
        if (this$numDocumentoDevedor == null ? other$numDocumentoDevedor != null : !this$numDocumentoDevedor.equals(other$numDocumentoDevedor)) {
            return false;
        }
        String this$rg = this.getRg();
        String other$rg = other.getRg();
        if (this$rg == null ? other$rg != null : !this$rg.equals(other$rg)) {
            return false;
        }
        String this$enderecoDevedor = this.getEnderecoDevedor();
        String other$enderecoDevedor = other.getEnderecoDevedor();
        if (this$enderecoDevedor == null ? other$enderecoDevedor != null : !this$enderecoDevedor.equals(other$enderecoDevedor)) {
            return false;
        }
        String this$cepDevedor = this.getCepDevedor();
        String other$cepDevedor = other.getCepDevedor();
        if (this$cepDevedor == null ? other$cepDevedor != null : !this$cepDevedor.equals(other$cepDevedor)) {
            return false;
        }
        String this$cidadeDevedor = this.getCidadeDevedor();
        String other$cidadeDevedor = other.getCidadeDevedor();
        if (this$cidadeDevedor == null ? other$cidadeDevedor != null : !this$cidadeDevedor.equals(other$cidadeDevedor)) {
            return false;
        }
        String this$ufDevedor = this.getUfDevedor();
        String other$ufDevedor = other.getUfDevedor();
        if (this$ufDevedor == null ? other$ufDevedor != null : !this$ufDevedor.equals(other$ufDevedor)) {
            return false;
        }
        String this$codCartorio = this.getCodCartorio();
        String other$codCartorio = other.getCodCartorio();
        if (this$codCartorio == null ? other$codCartorio != null : !this$codCartorio.equals(other$codCartorio)) {
            return false;
        }
        String this$numProtocoloCartorio = this.getNumProtocoloCartorio();
        String other$numProtocoloCartorio = other.getNumProtocoloCartorio();
        if (this$numProtocoloCartorio == null ? other$numProtocoloCartorio != null : !this$numProtocoloCartorio.equals(other$numProtocoloCartorio)) {
            return false;
        }
        String this$tipoOcorrencia = this.getTipoOcorrencia();
        String other$tipoOcorrencia = other.getTipoOcorrencia();
        if (this$tipoOcorrencia == null ? other$tipoOcorrencia != null : !this$tipoOcorrencia.equals(other$tipoOcorrencia)) {
            return false;
        }
        String this$dataProtocolo = this.getDataProtocolo();
        String other$dataProtocolo = other.getDataProtocolo();
        if (this$dataProtocolo == null ? other$dataProtocolo != null : !this$dataProtocolo.equals(other$dataProtocolo)) {
            return false;
        }
        String this$valorCustasCartorio = this.getValorCustasCartorio();
        String other$valorCustasCartorio = other.getValorCustasCartorio();
        if (this$valorCustasCartorio == null ? other$valorCustasCartorio != null : !this$valorCustasCartorio.equals(other$valorCustasCartorio)) {
            return false;
        }
        String this$declaracaoPortador = this.getDeclaracaoPortador();
        String other$declaracaoPortador = other.getDeclaracaoPortador();
        if (this$declaracaoPortador == null ? other$declaracaoPortador != null : !this$declaracaoPortador.equals(other$declaracaoPortador)) {
            return false;
        }
        String this$dataOcorrencia = this.getDataOcorrencia();
        String other$dataOcorrencia = other.getDataOcorrencia();
        if (this$dataOcorrencia == null ? other$dataOcorrencia != null : !this$dataOcorrencia.equals(other$dataOcorrencia)) {
            return false;
        }
        String this$codIrregularidade = this.getCodIrregularidade();
        String other$codIrregularidade = other.getCodIrregularidade();
        if (this$codIrregularidade == null ? other$codIrregularidade != null : !this$codIrregularidade.equals(other$codIrregularidade)) {
            return false;
        }
        String this$bairroDevedor = this.getBairroDevedor();
        String other$bairroDevedor = other.getBairroDevedor();
        if (this$bairroDevedor == null ? other$bairroDevedor != null : !this$bairroDevedor.equals(other$bairroDevedor)) {
            return false;
        }
        String this$valorCustasCartorioDistribuidor = this.getValorCustasCartorioDistribuidor();
        String other$valorCustasCartorioDistribuidor = other.getValorCustasCartorioDistribuidor();
        if (this$valorCustasCartorioDistribuidor == null ? other$valorCustasCartorioDistribuidor != null : !this$valorCustasCartorioDistribuidor.equals(other$valorCustasCartorioDistribuidor)) {
            return false;
        }
        String this$registroDistribuicao = this.getRegistroDistribuicao();
        String other$registroDistribuicao = other.getRegistroDistribuicao();
        if (this$registroDistribuicao == null ? other$registroDistribuicao != null : !this$registroDistribuicao.equals(other$registroDistribuicao)) {
            return false;
        }
        String this$valorGravacaoEletronicaEDemaisDespesas = this.getValorGravacaoEletronicaEDemaisDespesas();
        String other$valorGravacaoEletronicaEDemaisDespesas = other.getValorGravacaoEletronicaEDemaisDespesas();
        if (this$valorGravacaoEletronicaEDemaisDespesas == null ? other$valorGravacaoEletronicaEDemaisDespesas != null : !this$valorGravacaoEletronicaEDemaisDespesas.equals(other$valorGravacaoEletronicaEDemaisDespesas)) {
            return false;
        }
        String this$numOperacaoBanco = this.getNumOperacaoBanco();
        String other$numOperacaoBanco = other.getNumOperacaoBanco();
        if (this$numOperacaoBanco == null ? other$numOperacaoBanco != null : !this$numOperacaoBanco.equals(other$numOperacaoBanco)) {
            return false;
        }
        String this$numContratoBanco = this.getNumContratoBanco();
        String other$numContratoBanco = other.getNumContratoBanco();
        if (this$numContratoBanco == null ? other$numContratoBanco != null : !this$numContratoBanco.equals(other$numContratoBanco)) {
            return false;
        }
        String this$numParcelaContrato = this.getNumParcelaContrato();
        String other$numParcelaContrato = other.getNumParcelaContrato();
        if (this$numParcelaContrato == null ? other$numParcelaContrato != null : !this$numParcelaContrato.equals(other$numParcelaContrato)) {
            return false;
        }
        String this$tipoLetraCambio = this.getTipoLetraCambio();
        String other$tipoLetraCambio = other.getTipoLetraCambio();
        if (this$tipoLetraCambio == null ? other$tipoLetraCambio != null : !this$tipoLetraCambio.equals(other$tipoLetraCambio)) {
            return false;
        }
        String this$complementoCodIrregularidade = this.getComplementoCodIrregularidade();
        String other$complementoCodIrregularidade = other.getComplementoCodIrregularidade();
        if (this$complementoCodIrregularidade == null ? other$complementoCodIrregularidade != null : !this$complementoCodIrregularidade.equals(other$complementoCodIrregularidade)) {
            return false;
        }
        String this$protestoPorMotivoFalencia = this.getProtestoPorMotivoFalencia();
        String other$protestoPorMotivoFalencia = other.getProtestoPorMotivoFalencia();
        if (this$protestoPorMotivoFalencia == null ? other$protestoPorMotivoFalencia != null : !this$protestoPorMotivoFalencia.equals(other$protestoPorMotivoFalencia)) {
            return false;
        }
        String this$instrumentoDeProtesto = this.getInstrumentoDeProtesto();
        String other$instrumentoDeProtesto = other.getInstrumentoDeProtesto();
        if (this$instrumentoDeProtesto == null ? other$instrumentoDeProtesto != null : !this$instrumentoDeProtesto.equals(other$instrumentoDeProtesto)) {
            return false;
        }
        String this$valorDemaisDespesas = this.getValorDemaisDespesas();
        String other$valorDemaisDespesas = other.getValorDemaisDespesas();
        if (this$valorDemaisDespesas == null ? other$valorDemaisDespesas != null : !this$valorDemaisDespesas.equals(other$valorDemaisDespesas)) {
            return false;
        }
        String this$imagemDocumentos = this.getImagemDocumentos();
        String other$imagemDocumentos = other.getImagemDocumentos();
        return !(this$imagemDocumentos == null ? other$imagemDocumentos != null : !this$imagemDocumentos.equals(other$imagemDocumentos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CraComarcaTransacaoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $nossoNumero = this.getNossoNumero();
        result = result * 59 + ($nossoNumero == null ? 43 : ((Object)$nossoNumero).hashCode());
        Long $sequencialDevedoresNoMesmoTitulo = this.getSequencialDevedoresNoMesmoTitulo();
        result = result * 59 + ($sequencialDevedoresNoMesmoTitulo == null ? 43 : ((Object)$sequencialDevedoresNoMesmoTitulo).hashCode());
        Long $sequencialRegistro = this.getSequencialRegistro();
        result = result * 59 + ($sequencialRegistro == null ? 43 : ((Object)$sequencialRegistro).hashCode());
        String $idTransacao = this.getIdTransacao();
        result = result * 59 + ($idTransacao == null ? 43 : $idTransacao.hashCode());
        String $codApresentante = this.getCodApresentante();
        result = result * 59 + ($codApresentante == null ? 43 : $codApresentante.hashCode());
        String $codCedenteTitulo = this.getCodCedenteTitulo();
        result = result * 59 + ($codCedenteTitulo == null ? 43 : $codCedenteTitulo.hashCode());
        String $nomeCedente = this.getNomeCedente();
        result = result * 59 + ($nomeCedente == null ? 43 : $nomeCedente.hashCode());
        String $nomeSacador = this.getNomeSacador();
        result = result * 59 + ($nomeSacador == null ? 43 : $nomeSacador.hashCode());
        String $numCnpjSacador = this.getNumCnpjSacador();
        result = result * 59 + ($numCnpjSacador == null ? 43 : $numCnpjSacador.hashCode());
        String $enderecoSacador = this.getEnderecoSacador();
        result = result * 59 + ($enderecoSacador == null ? 43 : $enderecoSacador.hashCode());
        String $cepSacador = this.getCepSacador();
        result = result * 59 + ($cepSacador == null ? 43 : $cepSacador.hashCode());
        String $cidadeSacador = this.getCidadeSacador();
        result = result * 59 + ($cidadeSacador == null ? 43 : $cidadeSacador.hashCode());
        String $ufSacador = this.getUfSacador();
        result = result * 59 + ($ufSacador == null ? 43 : $ufSacador.hashCode());
        String $especieTitulo = this.getEspecieTitulo();
        result = result * 59 + ($especieTitulo == null ? 43 : $especieTitulo.hashCode());
        String $numTitulo = this.getNumTitulo();
        result = result * 59 + ($numTitulo == null ? 43 : $numTitulo.hashCode());
        String $dataEmissaoTitulo = this.getDataEmissaoTitulo();
        result = result * 59 + ($dataEmissaoTitulo == null ? 43 : $dataEmissaoTitulo.hashCode());
        String $dataVencimentoTitulo = this.getDataVencimentoTitulo();
        result = result * 59 + ($dataVencimentoTitulo == null ? 43 : $dataVencimentoTitulo.hashCode());
        String $tipoMoeda = this.getTipoMoeda();
        result = result * 59 + ($tipoMoeda == null ? 43 : $tipoMoeda.hashCode());
        BigDecimal $valorTitulo = this.getValorTitulo();
        result = result * 59 + ($valorTitulo == null ? 43 : ((Object)$valorTitulo).hashCode());
        BigDecimal $saldoTitulo = this.getSaldoTitulo();
        result = result * 59 + ($saldoTitulo == null ? 43 : ((Object)$saldoTitulo).hashCode());
        String $pracaPagamento = this.getPracaPagamento();
        result = result * 59 + ($pracaPagamento == null ? 43 : $pracaPagamento.hashCode());
        String $tipoEndosso = this.getTipoEndosso();
        result = result * 59 + ($tipoEndosso == null ? 43 : $tipoEndosso.hashCode());
        String $infoAceite = this.getInfoAceite();
        result = result * 59 + ($infoAceite == null ? 43 : $infoAceite.hashCode());
        String $nomeDevedor = this.getNomeDevedor();
        result = result * 59 + ($nomeDevedor == null ? 43 : $nomeDevedor.hashCode());
        String $tipoDocumentoDevedor = this.getTipoDocumentoDevedor();
        result = result * 59 + ($tipoDocumentoDevedor == null ? 43 : $tipoDocumentoDevedor.hashCode());
        String $numDocumentoDevedor = this.getNumDocumentoDevedor();
        result = result * 59 + ($numDocumentoDevedor == null ? 43 : $numDocumentoDevedor.hashCode());
        String $rg = this.getRg();
        result = result * 59 + ($rg == null ? 43 : $rg.hashCode());
        String $enderecoDevedor = this.getEnderecoDevedor();
        result = result * 59 + ($enderecoDevedor == null ? 43 : $enderecoDevedor.hashCode());
        String $cepDevedor = this.getCepDevedor();
        result = result * 59 + ($cepDevedor == null ? 43 : $cepDevedor.hashCode());
        String $cidadeDevedor = this.getCidadeDevedor();
        result = result * 59 + ($cidadeDevedor == null ? 43 : $cidadeDevedor.hashCode());
        String $ufDevedor = this.getUfDevedor();
        result = result * 59 + ($ufDevedor == null ? 43 : $ufDevedor.hashCode());
        String $codCartorio = this.getCodCartorio();
        result = result * 59 + ($codCartorio == null ? 43 : $codCartorio.hashCode());
        String $numProtocoloCartorio = this.getNumProtocoloCartorio();
        result = result * 59 + ($numProtocoloCartorio == null ? 43 : $numProtocoloCartorio.hashCode());
        String $tipoOcorrencia = this.getTipoOcorrencia();
        result = result * 59 + ($tipoOcorrencia == null ? 43 : $tipoOcorrencia.hashCode());
        String $dataProtocolo = this.getDataProtocolo();
        result = result * 59 + ($dataProtocolo == null ? 43 : $dataProtocolo.hashCode());
        String $valorCustasCartorio = this.getValorCustasCartorio();
        result = result * 59 + ($valorCustasCartorio == null ? 43 : $valorCustasCartorio.hashCode());
        String $declaracaoPortador = this.getDeclaracaoPortador();
        result = result * 59 + ($declaracaoPortador == null ? 43 : $declaracaoPortador.hashCode());
        String $dataOcorrencia = this.getDataOcorrencia();
        result = result * 59 + ($dataOcorrencia == null ? 43 : $dataOcorrencia.hashCode());
        String $codIrregularidade = this.getCodIrregularidade();
        result = result * 59 + ($codIrregularidade == null ? 43 : $codIrregularidade.hashCode());
        String $bairroDevedor = this.getBairroDevedor();
        result = result * 59 + ($bairroDevedor == null ? 43 : $bairroDevedor.hashCode());
        String $valorCustasCartorioDistribuidor = this.getValorCustasCartorioDistribuidor();
        result = result * 59 + ($valorCustasCartorioDistribuidor == null ? 43 : $valorCustasCartorioDistribuidor.hashCode());
        String $registroDistribuicao = this.getRegistroDistribuicao();
        result = result * 59 + ($registroDistribuicao == null ? 43 : $registroDistribuicao.hashCode());
        String $valorGravacaoEletronicaEDemaisDespesas = this.getValorGravacaoEletronicaEDemaisDespesas();
        result = result * 59 + ($valorGravacaoEletronicaEDemaisDespesas == null ? 43 : $valorGravacaoEletronicaEDemaisDespesas.hashCode());
        String $numOperacaoBanco = this.getNumOperacaoBanco();
        result = result * 59 + ($numOperacaoBanco == null ? 43 : $numOperacaoBanco.hashCode());
        String $numContratoBanco = this.getNumContratoBanco();
        result = result * 59 + ($numContratoBanco == null ? 43 : $numContratoBanco.hashCode());
        String $numParcelaContrato = this.getNumParcelaContrato();
        result = result * 59 + ($numParcelaContrato == null ? 43 : $numParcelaContrato.hashCode());
        String $tipoLetraCambio = this.getTipoLetraCambio();
        result = result * 59 + ($tipoLetraCambio == null ? 43 : $tipoLetraCambio.hashCode());
        String $complementoCodIrregularidade = this.getComplementoCodIrregularidade();
        result = result * 59 + ($complementoCodIrregularidade == null ? 43 : $complementoCodIrregularidade.hashCode());
        String $protestoPorMotivoFalencia = this.getProtestoPorMotivoFalencia();
        result = result * 59 + ($protestoPorMotivoFalencia == null ? 43 : $protestoPorMotivoFalencia.hashCode());
        String $instrumentoDeProtesto = this.getInstrumentoDeProtesto();
        result = result * 59 + ($instrumentoDeProtesto == null ? 43 : $instrumentoDeProtesto.hashCode());
        String $valorDemaisDespesas = this.getValorDemaisDespesas();
        result = result * 59 + ($valorDemaisDespesas == null ? 43 : $valorDemaisDespesas.hashCode());
        String $imagemDocumentos = this.getImagemDocumentos();
        result = result * 59 + ($imagemDocumentos == null ? 43 : $imagemDocumentos.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CraComarcaTransacaoDTO(idTransacao=" + this.getIdTransacao() + ", codApresentante=" + this.getCodApresentante() + ", codCedenteTitulo=" + this.getCodCedenteTitulo() + ", nomeCedente=" + this.getNomeCedente() + ", nomeSacador=" + this.getNomeSacador() + ", numCnpjSacador=" + this.getNumCnpjSacador() + ", enderecoSacador=" + this.getEnderecoSacador() + ", cepSacador=" + this.getCepSacador() + ", cidadeSacador=" + this.getCidadeSacador() + ", ufSacador=" + this.getUfSacador() + ", nossoNumero=" + this.getNossoNumero() + ", especieTitulo=" + this.getEspecieTitulo() + ", numTitulo=" + this.getNumTitulo() + ", dataEmissaoTitulo=" + this.getDataEmissaoTitulo() + ", dataVencimentoTitulo=" + this.getDataVencimentoTitulo() + ", tipoMoeda=" + this.getTipoMoeda() + ", valorTitulo=" + this.getValorTitulo() + ", saldoTitulo=" + this.getSaldoTitulo() + ", pracaPagamento=" + this.getPracaPagamento() + ", tipoEndosso=" + this.getTipoEndosso() + ", infoAceite=" + this.getInfoAceite() + ", sequencialDevedoresNoMesmoTitulo=" + this.getSequencialDevedoresNoMesmoTitulo() + ", nomeDevedor=" + this.getNomeDevedor() + ", tipoDocumentoDevedor=" + this.getTipoDocumentoDevedor() + ", numDocumentoDevedor=" + this.getNumDocumentoDevedor() + ", rg=" + this.getRg() + ", enderecoDevedor=" + this.getEnderecoDevedor() + ", cepDevedor=" + this.getCepDevedor() + ", cidadeDevedor=" + this.getCidadeDevedor() + ", ufDevedor=" + this.getUfDevedor() + ", codCartorio=" + this.getCodCartorio() + ", numProtocoloCartorio=" + this.getNumProtocoloCartorio() + ", tipoOcorrencia=" + this.getTipoOcorrencia() + ", dataProtocolo=" + this.getDataProtocolo() + ", valorCustasCartorio=" + this.getValorCustasCartorio() + ", declaracaoPortador=" + this.getDeclaracaoPortador() + ", dataOcorrencia=" + this.getDataOcorrencia() + ", codIrregularidade=" + this.getCodIrregularidade() + ", bairroDevedor=" + this.getBairroDevedor() + ", valorCustasCartorioDistribuidor=" + this.getValorCustasCartorioDistribuidor() + ", registroDistribuicao=" + this.getRegistroDistribuicao() + ", valorGravacaoEletronicaEDemaisDespesas=" + this.getValorGravacaoEletronicaEDemaisDespesas() + ", numOperacaoBanco=" + this.getNumOperacaoBanco() + ", numContratoBanco=" + this.getNumContratoBanco() + ", numParcelaContrato=" + this.getNumParcelaContrato() + ", tipoLetraCambio=" + this.getTipoLetraCambio() + ", complementoCodIrregularidade=" + this.getComplementoCodIrregularidade() + ", protestoPorMotivoFalencia=" + this.getProtestoPorMotivoFalencia() + ", instrumentoDeProtesto=" + this.getInstrumentoDeProtesto() + ", valorDemaisDespesas=" + this.getValorDemaisDespesas() + ", imagemDocumentos=" + this.getImagemDocumentos() + ", sequencialRegistro=" + this.getSequencialRegistro() + ")";
    }

    @Generated
    public CraComarcaTransacaoDTO() {
        this.idTransacao = CraComarcaTransacaoDTO.$default$idTransacao();
        this.codCedenteTitulo = CraComarcaTransacaoDTO.$default$codCedenteTitulo();
        this.especieTitulo = CraComarcaTransacaoDTO.$default$especieTitulo();
        this.tipoMoeda = CraComarcaTransacaoDTO.$default$tipoMoeda();
        this.tipoEndosso = CraComarcaTransacaoDTO.$default$tipoEndosso();
        this.infoAceite = CraComarcaTransacaoDTO.$default$infoAceite();
        this.rg = CraComarcaTransacaoDTO.$default$rg();
        this.codCartorio = CraComarcaTransacaoDTO.$default$codCartorio();
        this.numProtocoloCartorio = CraComarcaTransacaoDTO.$default$numProtocoloCartorio();
        this.tipoOcorrencia = CraComarcaTransacaoDTO.$default$tipoOcorrencia();
        this.dataProtocolo = CraComarcaTransacaoDTO.$default$dataProtocolo();
        this.valorCustasCartorio = CraComarcaTransacaoDTO.$default$valorCustasCartorio();
        this.declaracaoPortador = CraComarcaTransacaoDTO.$default$declaracaoPortador();
        this.dataOcorrencia = CraComarcaTransacaoDTO.$default$dataOcorrencia();
        this.codIrregularidade = CraComarcaTransacaoDTO.$default$codIrregularidade();
        this.valorCustasCartorioDistribuidor = CraComarcaTransacaoDTO.$default$valorCustasCartorioDistribuidor();
        this.registroDistribuicao = CraComarcaTransacaoDTO.$default$registroDistribuicao();
        this.valorGravacaoEletronicaEDemaisDespesas = CraComarcaTransacaoDTO.$default$valorGravacaoEletronicaEDemaisDespesas();
        this.numOperacaoBanco = CraComarcaTransacaoDTO.$default$numOperacaoBanco();
        this.numContratoBanco = CraComarcaTransacaoDTO.$default$numContratoBanco();
        this.numParcelaContrato = CraComarcaTransacaoDTO.$default$numParcelaContrato();
        this.tipoLetraCambio = CraComarcaTransacaoDTO.$default$tipoLetraCambio();
        this.complementoCodIrregularidade = CraComarcaTransacaoDTO.$default$complementoCodIrregularidade();
        this.protestoPorMotivoFalencia = CraComarcaTransacaoDTO.$default$protestoPorMotivoFalencia();
        this.instrumentoDeProtesto = CraComarcaTransacaoDTO.$default$instrumentoDeProtesto();
        this.valorDemaisDespesas = CraComarcaTransacaoDTO.$default$valorDemaisDespesas();
    }

    @Generated
    public CraComarcaTransacaoDTO(String idTransacao, String codApresentante, String codCedenteTitulo, String nomeCedente, String nomeSacador, String numCnpjSacador, String enderecoSacador, String cepSacador, String cidadeSacador, String ufSacador, Long nossoNumero, String especieTitulo, String numTitulo, String dataEmissaoTitulo, String dataVencimentoTitulo, String tipoMoeda, BigDecimal valorTitulo, BigDecimal saldoTitulo, String pracaPagamento, String tipoEndosso, String infoAceite, Long sequencialDevedoresNoMesmoTitulo, String nomeDevedor, String tipoDocumentoDevedor, String numDocumentoDevedor, String rg, String enderecoDevedor, String cepDevedor, String cidadeDevedor, String ufDevedor, String codCartorio, String numProtocoloCartorio, String tipoOcorrencia, String dataProtocolo, String valorCustasCartorio, String declaracaoPortador, String dataOcorrencia, String codIrregularidade, String bairroDevedor, String valorCustasCartorioDistribuidor, String registroDistribuicao, String valorGravacaoEletronicaEDemaisDespesas, String numOperacaoBanco, String numContratoBanco, String numParcelaContrato, String tipoLetraCambio, String complementoCodIrregularidade, String protestoPorMotivoFalencia, String instrumentoDeProtesto, String valorDemaisDespesas, String imagemDocumentos, Long sequencialRegistro) {
        this.idTransacao = idTransacao;
        this.codApresentante = codApresentante;
        this.codCedenteTitulo = codCedenteTitulo;
        this.nomeCedente = nomeCedente;
        this.nomeSacador = nomeSacador;
        this.numCnpjSacador = numCnpjSacador;
        this.enderecoSacador = enderecoSacador;
        this.cepSacador = cepSacador;
        this.cidadeSacador = cidadeSacador;
        this.ufSacador = ufSacador;
        this.nossoNumero = nossoNumero;
        this.especieTitulo = especieTitulo;
        this.numTitulo = numTitulo;
        this.dataEmissaoTitulo = dataEmissaoTitulo;
        this.dataVencimentoTitulo = dataVencimentoTitulo;
        this.tipoMoeda = tipoMoeda;
        this.valorTitulo = valorTitulo;
        this.saldoTitulo = saldoTitulo;
        this.pracaPagamento = pracaPagamento;
        this.tipoEndosso = tipoEndosso;
        this.infoAceite = infoAceite;
        this.sequencialDevedoresNoMesmoTitulo = sequencialDevedoresNoMesmoTitulo;
        this.nomeDevedor = nomeDevedor;
        this.tipoDocumentoDevedor = tipoDocumentoDevedor;
        this.numDocumentoDevedor = numDocumentoDevedor;
        this.rg = rg;
        this.enderecoDevedor = enderecoDevedor;
        this.cepDevedor = cepDevedor;
        this.cidadeDevedor = cidadeDevedor;
        this.ufDevedor = ufDevedor;
        this.codCartorio = codCartorio;
        this.numProtocoloCartorio = numProtocoloCartorio;
        this.tipoOcorrencia = tipoOcorrencia;
        this.dataProtocolo = dataProtocolo;
        this.valorCustasCartorio = valorCustasCartorio;
        this.declaracaoPortador = declaracaoPortador;
        this.dataOcorrencia = dataOcorrencia;
        this.codIrregularidade = codIrregularidade;
        this.bairroDevedor = bairroDevedor;
        this.valorCustasCartorioDistribuidor = valorCustasCartorioDistribuidor;
        this.registroDistribuicao = registroDistribuicao;
        this.valorGravacaoEletronicaEDemaisDespesas = valorGravacaoEletronicaEDemaisDespesas;
        this.numOperacaoBanco = numOperacaoBanco;
        this.numContratoBanco = numContratoBanco;
        this.numParcelaContrato = numParcelaContrato;
        this.tipoLetraCambio = tipoLetraCambio;
        this.complementoCodIrregularidade = complementoCodIrregularidade;
        this.protestoPorMotivoFalencia = protestoPorMotivoFalencia;
        this.instrumentoDeProtesto = instrumentoDeProtesto;
        this.valorDemaisDespesas = valorDemaisDespesas;
        this.imagemDocumentos = imagemDocumentos;
        this.sequencialRegistro = sequencialRegistro;
    }
}

