/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaogeomais;

import br.com.elotech.tributos.domain.Bairro;
import br.com.elotech.tributos.domain.Cidade;
import br.com.elotech.tributos.domain.Distrito;
import br.com.elotech.tributos.domain.Logradouro;
import br.com.elotech.tributos.domain.Pessoa;
import br.com.elotech.tributos.domain.Setor;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoCondicaoPessoaImovel;
import br.com.elotech.tributos.domain.TipoOrigemInscricao;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.rural.BoletimRural;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.camposdinamicos.RespostaDTO;
import br.com.elotech.tributos.dto.integracaogeomais.BairroGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.BoletimGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.CidadeGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.DistritoGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.LogradouroGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.PessoaGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.ProprietarioGeomaisDTO;
import br.com.elotech.tributos.dto.integracaogeomais.SetorGeomaisDTO;
import br.com.elotech.tributos.util.BooleanToStringUtils;
import com.fasterxml.jackson.annotation.JsonIgnoreProperties;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class CadastroRuralElogeoDTO {
    private Long id;
    private TipoCadastro tipo = TipoCadastro.RURAL;
    private Long codigo;
    private Long cadastroGeralAnterior;
    private String endereco;
    private String lote;
    private String matricula;
    private Long oficio;
    private Boolean resideImovel;
    private Long numeroImovelReceita;
    private String codigoIncra;
    private String nomePropriedade;
    private BigDecimal quantidadeAlqueires = BigDecimal.ZERO;
    private BigDecimal quantidadeHectares = BigDecimal.ZERO;
    private BigDecimal valorTerreno = BigDecimal.ZERO;
    private BigDecimal areaArrendada = BigDecimal.ZERO;
    private BigDecimal areaCultivo = BigDecimal.ZERO;
    private BigDecimal areaPasto = BigDecimal.ZERO;
    private BigDecimal areaTotal = BigDecimal.ZERO;
    private BigDecimal areaTotalConstruida = BigDecimal.ZERO;
    private TipoOrigemInscricao origemInscricao;
    private TipoCondicaoPessoaImovel condicaoPessoaImovel;
    private String numero;
    private String complemento;
    private Long cep;
    private LocalDate dataInclusao;
    private LocalDate dataAlteracao;
    private String exclusaoLogica;
    private String englobado;
    private String correspondenciaLocal;
    private PessoaGeomaisDTO pessoa;
    private LogradouroGeomaisDTO logradouro;
    private BairroGeomaisDTO bairro;
    private CidadeGeomaisDTO cidade;
    private DistritoGeomaisDTO distrito;
    @JsonIgnoreProperties(value={"quadras"})
    private SetorGeomaisDTO setor;
    private List<ProprietarioGeomaisDTO> proprietarios = new ArrayList();
    @NotNull
    @Valid
    private List<BoletimGeomaisDTO> boletim = new ArrayList();

    public static CadastroRuralElogeoDTO from(CadastroRural cadastroRuralEntity, List<BoletimRural> boletimRural) {
        CadastroRuralElogeoDTO cadastroRuralElogeoDTO = new CadastroRuralElogeoDTO();
        cadastroRuralElogeoDTO.setId(cadastroRuralEntity.getId());
        Optional.ofNullable(cadastroRuralEntity.getCadastroGeral()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCodigo(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCadastroGeralAnterior()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCadastroGeralAnterior(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getEndereco()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setEndereco(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getPessoa()).ifPresent(pessoa -> cadastroRuralElogeoDTO.setPessoa(PessoaGeomaisDTO.from((Pessoa)pessoa)));
        Optional.ofNullable(cadastroRuralEntity.getLogradouro()).ifPresent(logradouro -> cadastroRuralElogeoDTO.setLogradouro(LogradouroGeomaisDTO.from((Logradouro)logradouro)));
        Optional.ofNullable(cadastroRuralEntity.getDistrito()).ifPresent(distrito -> cadastroRuralElogeoDTO.setDistrito(DistritoGeomaisDTO.from((Distrito)distrito)));
        Optional.ofNullable(cadastroRuralEntity.getSetor()).ifPresent(setor -> cadastroRuralElogeoDTO.setSetor(SetorGeomaisDTO.from((Setor)setor)));
        Optional.ofNullable(cadastroRuralEntity.getBairro()).ifPresent(bairro -> cadastroRuralElogeoDTO.setBairro(BairroGeomaisDTO.from((Bairro)bairro)));
        Optional.ofNullable(cadastroRuralEntity.getCidade()).ifPresent(cidade -> cadastroRuralElogeoDTO.setCidade(CidadeGeomaisDTO.from((Cidade)cidade)));
        Optional.ofNullable(cadastroRuralEntity.getLote()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setLote(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getMatricula()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setMatricula(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getOficio()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setOficio(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getResideImovel()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setResideImovel(arg_0));
        cadastroRuralElogeoDTO.setProprietarios(cadastroRuralEntity.getProprietarios().stream().map(ProprietarioGeomaisDTO::from).collect(Collectors.toList()));
        cadastroRuralElogeoDTO.setBoletim(boletimRural.stream().map(BoletimGeomaisDTO::from).collect(Collectors.toList()));
        Optional.ofNullable(cadastroRuralEntity.getNumeroImovelReceita()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setNumeroImovelReceita(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCodigoIncra()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCodigoIncra(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getNomePropriedade()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setNomePropriedade(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getQuantidadeAlqueires()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setQuantidadeAlqueires(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getQuantidadeHectares()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setQuantidadeHectares(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaTotal()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaTotal(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaArrendada()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaArrendada(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaCultivo()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaCultivo(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaPasto()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaPasto(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getValorTerreno()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setValorTerreno(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaTotalConstruida()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaTotalConstruida(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getOrigemInscricao()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setOrigemInscricao(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCondicaoPessoaImovel()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCondicaoPessoaImovel(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getNumero()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setNumero(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getComplemento()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setComplemento(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCep()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCep(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getDataInclusao()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setDataInclusao(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getDataAlteracao()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setDataAlteracao(arg_0));
        Optional.ofNullable(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroRuralEntity.getExclusaoLogica())).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setExclusaoLogica(arg_0));
        Optional.ofNullable(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroRuralEntity.getCorrespondenciaLocal())).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCorrespondenciaLocal(arg_0));
        Optional.ofNullable(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroRuralEntity.getEnglobado())).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setEnglobado(arg_0));
        return cadastroRuralElogeoDTO;
    }

    public static CadastroRuralElogeoDTO oxyFrom(CadastroRural cadastroRuralEntity, List<RespostaDTO> respostas) {
        CadastroRuralElogeoDTO cadastroRuralElogeoDTO = new CadastroRuralElogeoDTO();
        cadastroRuralElogeoDTO.setId(cadastroRuralEntity.getId());
        Optional.ofNullable(cadastroRuralEntity.getCadastroGeral()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCodigo(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCadastroGeralAnterior()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCadastroGeralAnterior(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getEndereco()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setEndereco(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getPessoa()).ifPresent(pessoa -> cadastroRuralElogeoDTO.setPessoa(PessoaGeomaisDTO.from((Pessoa)pessoa)));
        Optional.ofNullable(cadastroRuralEntity.getLogradouro()).ifPresent(logradouro -> cadastroRuralElogeoDTO.setLogradouro(LogradouroGeomaisDTO.from((Logradouro)logradouro)));
        Optional.ofNullable(cadastroRuralEntity.getDistrito()).ifPresent(distrito -> cadastroRuralElogeoDTO.setDistrito(DistritoGeomaisDTO.from((Distrito)distrito)));
        Optional.ofNullable(cadastroRuralEntity.getSetor()).ifPresent(setor -> cadastroRuralElogeoDTO.setSetor(SetorGeomaisDTO.from((Setor)setor)));
        Optional.ofNullable(cadastroRuralEntity.getBairro()).ifPresent(bairro -> cadastroRuralElogeoDTO.setBairro(BairroGeomaisDTO.from((Bairro)bairro)));
        Optional.ofNullable(cadastroRuralEntity.getCidade()).ifPresent(cidade -> cadastroRuralElogeoDTO.setCidade(CidadeGeomaisDTO.from((Cidade)cidade)));
        Optional.ofNullable(cadastroRuralEntity.getLote()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setLote(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getMatricula()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setMatricula(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getOficio()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setOficio(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getResideImovel()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setResideImovel(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getProprietarios().stream().map(ProprietarioGeomaisDTO::from).collect(Collectors.toList())).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setProprietarios(arg_0));
        cadastroRuralElogeoDTO.setBoletim((List)Optional.ofNullable(respostas).filter(respostasList -> !respostasList.isEmpty()).map(respostasList -> respostasList.stream().filter(Objects::nonNull).map(respostaDTO -> {
            if (respostaDTO != null && respostaDTO.getResposta() != null) {
                return BoletimGeomaisDTO.from((Resposta)respostaDTO.getResposta());
            }
            return null;
        }).filter(Objects::nonNull).collect(Collectors.toList())).orElse(null));
        Optional.ofNullable(cadastroRuralEntity.getNumeroImovelReceita()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setNumeroImovelReceita(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCodigoIncra()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCodigoIncra(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getNomePropriedade()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setNomePropriedade(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getQuantidadeAlqueires()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setQuantidadeAlqueires(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getQuantidadeHectares()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setQuantidadeHectares(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaTotal()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaTotal(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaArrendada()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaArrendada(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaCultivo()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaCultivo(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaPasto()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaPasto(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getValorTerreno()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setValorTerreno(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getAreaTotalConstruida()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setAreaTotalConstruida(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getOrigemInscricao()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setOrigemInscricao(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCondicaoPessoaImovel()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCondicaoPessoaImovel(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getNumero()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setNumero(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getComplemento()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setComplemento(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getCep()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCep(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getDataInclusao()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setDataInclusao(arg_0));
        Optional.ofNullable(cadastroRuralEntity.getDataAlteracao()).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setDataAlteracao(arg_0));
        Optional.ofNullable(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroRuralEntity.getExclusaoLogica())).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setExclusaoLogica(arg_0));
        Optional.ofNullable(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroRuralEntity.getCorrespondenciaLocal())).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setCorrespondenciaLocal(arg_0));
        Optional.ofNullable(BooleanToStringUtils.getBooleanAsString((Boolean)cadastroRuralEntity.getEnglobado())).ifPresent(arg_0 -> cadastroRuralElogeoDTO.setEnglobado(arg_0));
        return cadastroRuralElogeoDTO;
    }

    @Generated
    public CadastroRuralElogeoDTO() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoCadastro getTipo() {
        return this.tipo;
    }

    @Generated
    public Long getCodigo() {
        return this.codigo;
    }

    @Generated
    public Long getCadastroGeralAnterior() {
        return this.cadastroGeralAnterior;
    }

    @Generated
    public String getEndereco() {
        return this.endereco;
    }

    @Generated
    public String getLote() {
        return this.lote;
    }

    @Generated
    public String getMatricula() {
        return this.matricula;
    }

    @Generated
    public Long getOficio() {
        return this.oficio;
    }

    @Generated
    public Boolean getResideImovel() {
        return this.resideImovel;
    }

    @Generated
    public Long getNumeroImovelReceita() {
        return this.numeroImovelReceita;
    }

    @Generated
    public String getCodigoIncra() {
        return this.codigoIncra;
    }

    @Generated
    public String getNomePropriedade() {
        return this.nomePropriedade;
    }

    @Generated
    public BigDecimal getQuantidadeAlqueires() {
        return this.quantidadeAlqueires;
    }

    @Generated
    public BigDecimal getQuantidadeHectares() {
        return this.quantidadeHectares;
    }

    @Generated
    public BigDecimal getValorTerreno() {
        return this.valorTerreno;
    }

    @Generated
    public BigDecimal getAreaArrendada() {
        return this.areaArrendada;
    }

    @Generated
    public BigDecimal getAreaCultivo() {
        return this.areaCultivo;
    }

    @Generated
    public BigDecimal getAreaPasto() {
        return this.areaPasto;
    }

    @Generated
    public BigDecimal getAreaTotal() {
        return this.areaTotal;
    }

    @Generated
    public BigDecimal getAreaTotalConstruida() {
        return this.areaTotalConstruida;
    }

    @Generated
    public TipoOrigemInscricao getOrigemInscricao() {
        return this.origemInscricao;
    }

    @Generated
    public TipoCondicaoPessoaImovel getCondicaoPessoaImovel() {
        return this.condicaoPessoaImovel;
    }

    @Generated
    public String getNumero() {
        return this.numero;
    }

    @Generated
    public String getComplemento() {
        return this.complemento;
    }

    @Generated
    public Long getCep() {
        return this.cep;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public String getExclusaoLogica() {
        return this.exclusaoLogica;
    }

    @Generated
    public String getEnglobado() {
        return this.englobado;
    }

    @Generated
    public String getCorrespondenciaLocal() {
        return this.correspondenciaLocal;
    }

    @Generated
    public PessoaGeomaisDTO getPessoa() {
        return this.pessoa;
    }

    @Generated
    public LogradouroGeomaisDTO getLogradouro() {
        return this.logradouro;
    }

    @Generated
    public BairroGeomaisDTO getBairro() {
        return this.bairro;
    }

    @Generated
    public CidadeGeomaisDTO getCidade() {
        return this.cidade;
    }

    @Generated
    public DistritoGeomaisDTO getDistrito() {
        return this.distrito;
    }

    @Generated
    public SetorGeomaisDTO getSetor() {
        return this.setor;
    }

    @Generated
    public List<ProprietarioGeomaisDTO> getProprietarios() {
        return this.proprietarios;
    }

    @Generated
    public List<BoletimGeomaisDTO> getBoletim() {
        return this.boletim;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipo(TipoCadastro tipo) {
        this.tipo = tipo;
    }

    @Generated
    public void setCodigo(Long codigo) {
        this.codigo = codigo;
    }

    @Generated
    public void setCadastroGeralAnterior(Long cadastroGeralAnterior) {
        this.cadastroGeralAnterior = cadastroGeralAnterior;
    }

    @Generated
    public void setEndereco(String endereco) {
        this.endereco = endereco;
    }

    @Generated
    public void setLote(String lote) {
        this.lote = lote;
    }

    @Generated
    public void setMatricula(String matricula) {
        this.matricula = matricula;
    }

    @Generated
    public void setOficio(Long oficio) {
        this.oficio = oficio;
    }

    @Generated
    public void setResideImovel(Boolean resideImovel) {
        this.resideImovel = resideImovel;
    }

    @Generated
    public void setNumeroImovelReceita(Long numeroImovelReceita) {
        this.numeroImovelReceita = numeroImovelReceita;
    }

    @Generated
    public void setCodigoIncra(String codigoIncra) {
        this.codigoIncra = codigoIncra;
    }

    @Generated
    public void setNomePropriedade(String nomePropriedade) {
        this.nomePropriedade = nomePropriedade;
    }

    @Generated
    public void setQuantidadeAlqueires(BigDecimal quantidadeAlqueires) {
        this.quantidadeAlqueires = quantidadeAlqueires;
    }

    @Generated
    public void setQuantidadeHectares(BigDecimal quantidadeHectares) {
        this.quantidadeHectares = quantidadeHectares;
    }

    @Generated
    public void setValorTerreno(BigDecimal valorTerreno) {
        this.valorTerreno = valorTerreno;
    }

    @Generated
    public void setAreaArrendada(BigDecimal areaArrendada) {
        this.areaArrendada = areaArrendada;
    }

    @Generated
    public void setAreaCultivo(BigDecimal areaCultivo) {
        this.areaCultivo = areaCultivo;
    }

    @Generated
    public void setAreaPasto(BigDecimal areaPasto) {
        this.areaPasto = areaPasto;
    }

    @Generated
    public void setAreaTotal(BigDecimal areaTotal) {
        this.areaTotal = areaTotal;
    }

    @Generated
    public void setAreaTotalConstruida(BigDecimal areaTotalConstruida) {
        this.areaTotalConstruida = areaTotalConstruida;
    }

    @Generated
    public void setOrigemInscricao(TipoOrigemInscricao origemInscricao) {
        this.origemInscricao = origemInscricao;
    }

    @Generated
    public void setCondicaoPessoaImovel(TipoCondicaoPessoaImovel condicaoPessoaImovel) {
        this.condicaoPessoaImovel = condicaoPessoaImovel;
    }

    @Generated
    public void setNumero(String numero) {
        this.numero = numero;
    }

    @Generated
    public void setComplemento(String complemento) {
        this.complemento = complemento;
    }

    @Generated
    public void setCep(Long cep) {
        this.cep = cep;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setExclusaoLogica(String exclusaoLogica) {
        this.exclusaoLogica = exclusaoLogica;
    }

    @Generated
    public void setEnglobado(String englobado) {
        this.englobado = englobado;
    }

    @Generated
    public void setCorrespondenciaLocal(String correspondenciaLocal) {
        this.correspondenciaLocal = correspondenciaLocal;
    }

    @Generated
    public void setPessoa(PessoaGeomaisDTO pessoa) {
        this.pessoa = pessoa;
    }

    @Generated
    public void setLogradouro(LogradouroGeomaisDTO logradouro) {
        this.logradouro = logradouro;
    }

    @Generated
    public void setBairro(BairroGeomaisDTO bairro) {
        this.bairro = bairro;
    }

    @Generated
    public void setCidade(CidadeGeomaisDTO cidade) {
        this.cidade = cidade;
    }

    @Generated
    public void setDistrito(DistritoGeomaisDTO distrito) {
        this.distrito = distrito;
    }

    @JsonIgnoreProperties(value={"quadras"})
    @Generated
    public void setSetor(SetorGeomaisDTO setor) {
        this.setor = setor;
    }

    @Generated
    public void setProprietarios(List<ProprietarioGeomaisDTO> proprietarios) {
        this.proprietarios = proprietarios;
    }

    @Generated
    public void setBoletim(List<BoletimGeomaisDTO> boletim) {
        this.boletim = boletim;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroRuralElogeoDTO)) {
            return false;
        }
        CadastroRuralElogeoDTO other = (CadastroRuralElogeoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Long this$codigo = this.getCodigo();
        Long other$codigo = other.getCodigo();
        if (this$codigo == null ? other$codigo != null : !((Object)this$codigo).equals(other$codigo)) {
            return false;
        }
        Long this$cadastroGeralAnterior = this.getCadastroGeralAnterior();
        Long other$cadastroGeralAnterior = other.getCadastroGeralAnterior();
        if (this$cadastroGeralAnterior == null ? other$cadastroGeralAnterior != null : !((Object)this$cadastroGeralAnterior).equals(other$cadastroGeralAnterior)) {
            return false;
        }
        Long this$oficio = this.getOficio();
        Long other$oficio = other.getOficio();
        if (this$oficio == null ? other$oficio != null : !((Object)this$oficio).equals(other$oficio)) {
            return false;
        }
        Boolean this$resideImovel = this.getResideImovel();
        Boolean other$resideImovel = other.getResideImovel();
        if (this$resideImovel == null ? other$resideImovel != null : !((Object)this$resideImovel).equals(other$resideImovel)) {
            return false;
        }
        Long this$numeroImovelReceita = this.getNumeroImovelReceita();
        Long other$numeroImovelReceita = other.getNumeroImovelReceita();
        if (this$numeroImovelReceita == null ? other$numeroImovelReceita != null : !((Object)this$numeroImovelReceita).equals(other$numeroImovelReceita)) {
            return false;
        }
        Long this$cep = this.getCep();
        Long other$cep = other.getCep();
        if (this$cep == null ? other$cep != null : !((Object)this$cep).equals(other$cep)) {
            return false;
        }
        TipoCadastro this$tipo = this.getTipo();
        TipoCadastro other$tipo = other.getTipo();
        if (this$tipo == null ? other$tipo != null : !this$tipo.equals(other$tipo)) {
            return false;
        }
        String this$endereco = this.getEndereco();
        String other$endereco = other.getEndereco();
        if (this$endereco == null ? other$endereco != null : !this$endereco.equals(other$endereco)) {
            return false;
        }
        String this$lote = this.getLote();
        String other$lote = other.getLote();
        if (this$lote == null ? other$lote != null : !this$lote.equals(other$lote)) {
            return false;
        }
        String this$matricula = this.getMatricula();
        String other$matricula = other.getMatricula();
        if (this$matricula == null ? other$matricula != null : !this$matricula.equals(other$matricula)) {
            return false;
        }
        String this$codigoIncra = this.getCodigoIncra();
        String other$codigoIncra = other.getCodigoIncra();
        if (this$codigoIncra == null ? other$codigoIncra != null : !this$codigoIncra.equals(other$codigoIncra)) {
            return false;
        }
        String this$nomePropriedade = this.getNomePropriedade();
        String other$nomePropriedade = other.getNomePropriedade();
        if (this$nomePropriedade == null ? other$nomePropriedade != null : !this$nomePropriedade.equals(other$nomePropriedade)) {
            return false;
        }
        BigDecimal this$quantidadeAlqueires = this.getQuantidadeAlqueires();
        BigDecimal other$quantidadeAlqueires = other.getQuantidadeAlqueires();
        if (this$quantidadeAlqueires == null ? other$quantidadeAlqueires != null : !((Object)this$quantidadeAlqueires).equals(other$quantidadeAlqueires)) {
            return false;
        }
        BigDecimal this$quantidadeHectares = this.getQuantidadeHectares();
        BigDecimal other$quantidadeHectares = other.getQuantidadeHectares();
        if (this$quantidadeHectares == null ? other$quantidadeHectares != null : !((Object)this$quantidadeHectares).equals(other$quantidadeHectares)) {
            return false;
        }
        BigDecimal this$valorTerreno = this.getValorTerreno();
        BigDecimal other$valorTerreno = other.getValorTerreno();
        if (this$valorTerreno == null ? other$valorTerreno != null : !((Object)this$valorTerreno).equals(other$valorTerreno)) {
            return false;
        }
        BigDecimal this$areaArrendada = this.getAreaArrendada();
        BigDecimal other$areaArrendada = other.getAreaArrendada();
        if (this$areaArrendada == null ? other$areaArrendada != null : !((Object)this$areaArrendada).equals(other$areaArrendada)) {
            return false;
        }
        BigDecimal this$areaCultivo = this.getAreaCultivo();
        BigDecimal other$areaCultivo = other.getAreaCultivo();
        if (this$areaCultivo == null ? other$areaCultivo != null : !((Object)this$areaCultivo).equals(other$areaCultivo)) {
            return false;
        }
        BigDecimal this$areaPasto = this.getAreaPasto();
        BigDecimal other$areaPasto = other.getAreaPasto();
        if (this$areaPasto == null ? other$areaPasto != null : !((Object)this$areaPasto).equals(other$areaPasto)) {
            return false;
        }
        BigDecimal this$areaTotal = this.getAreaTotal();
        BigDecimal other$areaTotal = other.getAreaTotal();
        if (this$areaTotal == null ? other$areaTotal != null : !((Object)this$areaTotal).equals(other$areaTotal)) {
            return false;
        }
        BigDecimal this$areaTotalConstruida = this.getAreaTotalConstruida();
        BigDecimal other$areaTotalConstruida = other.getAreaTotalConstruida();
        if (this$areaTotalConstruida == null ? other$areaTotalConstruida != null : !((Object)this$areaTotalConstruida).equals(other$areaTotalConstruida)) {
            return false;
        }
        TipoOrigemInscricao this$origemInscricao = this.getOrigemInscricao();
        TipoOrigemInscricao other$origemInscricao = other.getOrigemInscricao();
        if (this$origemInscricao == null ? other$origemInscricao != null : !this$origemInscricao.equals(other$origemInscricao)) {
            return false;
        }
        TipoCondicaoPessoaImovel this$condicaoPessoaImovel = this.getCondicaoPessoaImovel();
        TipoCondicaoPessoaImovel other$condicaoPessoaImovel = other.getCondicaoPessoaImovel();
        if (this$condicaoPessoaImovel == null ? other$condicaoPessoaImovel != null : !this$condicaoPessoaImovel.equals(other$condicaoPessoaImovel)) {
            return false;
        }
        String this$numero = this.getNumero();
        String other$numero = other.getNumero();
        if (this$numero == null ? other$numero != null : !this$numero.equals(other$numero)) {
            return false;
        }
        String this$complemento = this.getComplemento();
        String other$complemento = other.getComplemento();
        if (this$complemento == null ? other$complemento != null : !this$complemento.equals(other$complemento)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        LocalDate this$dataAlteracao = this.getDataAlteracao();
        LocalDate other$dataAlteracao = other.getDataAlteracao();
        if (this$dataAlteracao == null ? other$dataAlteracao != null : !((Object)this$dataAlteracao).equals(other$dataAlteracao)) {
            return false;
        }
        String this$exclusaoLogica = this.getExclusaoLogica();
        String other$exclusaoLogica = other.getExclusaoLogica();
        if (this$exclusaoLogica == null ? other$exclusaoLogica != null : !this$exclusaoLogica.equals(other$exclusaoLogica)) {
            return false;
        }
        String this$englobado = this.getEnglobado();
        String other$englobado = other.getEnglobado();
        if (this$englobado == null ? other$englobado != null : !this$englobado.equals(other$englobado)) {
            return false;
        }
        String this$correspondenciaLocal = this.getCorrespondenciaLocal();
        String other$correspondenciaLocal = other.getCorrespondenciaLocal();
        if (this$correspondenciaLocal == null ? other$correspondenciaLocal != null : !this$correspondenciaLocal.equals(other$correspondenciaLocal)) {
            return false;
        }
        PessoaGeomaisDTO this$pessoa = this.getPessoa();
        PessoaGeomaisDTO other$pessoa = other.getPessoa();
        if (this$pessoa == null ? other$pessoa != null : !this$pessoa.equals(other$pessoa)) {
            return false;
        }
        LogradouroGeomaisDTO this$logradouro = this.getLogradouro();
        LogradouroGeomaisDTO other$logradouro = other.getLogradouro();
        if (this$logradouro == null ? other$logradouro != null : !this$logradouro.equals(other$logradouro)) {
            return false;
        }
        BairroGeomaisDTO this$bairro = this.getBairro();
        BairroGeomaisDTO other$bairro = other.getBairro();
        if (this$bairro == null ? other$bairro != null : !this$bairro.equals(other$bairro)) {
            return false;
        }
        CidadeGeomaisDTO this$cidade = this.getCidade();
        CidadeGeomaisDTO other$cidade = other.getCidade();
        if (this$cidade == null ? other$cidade != null : !this$cidade.equals(other$cidade)) {
            return false;
        }
        DistritoGeomaisDTO this$distrito = this.getDistrito();
        DistritoGeomaisDTO other$distrito = other.getDistrito();
        if (this$distrito == null ? other$distrito != null : !this$distrito.equals(other$distrito)) {
            return false;
        }
        SetorGeomaisDTO this$setor = this.getSetor();
        SetorGeomaisDTO other$setor = other.getSetor();
        if (this$setor == null ? other$setor != null : !this$setor.equals(other$setor)) {
            return false;
        }
        List this$proprietarios = this.getProprietarios();
        List other$proprietarios = other.getProprietarios();
        if (this$proprietarios == null ? other$proprietarios != null : !((Object)this$proprietarios).equals(other$proprietarios)) {
            return false;
        }
        List this$boletim = this.getBoletim();
        List other$boletim = other.getBoletim();
        return !(this$boletim == null ? other$boletim != null : !((Object)this$boletim).equals(other$boletim));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroRuralElogeoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Long $codigo = this.getCodigo();
        result = result * 59 + ($codigo == null ? 43 : ((Object)$codigo).hashCode());
        Long $cadastroGeralAnterior = this.getCadastroGeralAnterior();
        result = result * 59 + ($cadastroGeralAnterior == null ? 43 : ((Object)$cadastroGeralAnterior).hashCode());
        Long $oficio = this.getOficio();
        result = result * 59 + ($oficio == null ? 43 : ((Object)$oficio).hashCode());
        Boolean $resideImovel = this.getResideImovel();
        result = result * 59 + ($resideImovel == null ? 43 : ((Object)$resideImovel).hashCode());
        Long $numeroImovelReceita = this.getNumeroImovelReceita();
        result = result * 59 + ($numeroImovelReceita == null ? 43 : ((Object)$numeroImovelReceita).hashCode());
        Long $cep = this.getCep();
        result = result * 59 + ($cep == null ? 43 : ((Object)$cep).hashCode());
        TipoCadastro $tipo = this.getTipo();
        result = result * 59 + ($tipo == null ? 43 : $tipo.hashCode());
        String $endereco = this.getEndereco();
        result = result * 59 + ($endereco == null ? 43 : $endereco.hashCode());
        String $lote = this.getLote();
        result = result * 59 + ($lote == null ? 43 : $lote.hashCode());
        String $matricula = this.getMatricula();
        result = result * 59 + ($matricula == null ? 43 : $matricula.hashCode());
        String $codigoIncra = this.getCodigoIncra();
        result = result * 59 + ($codigoIncra == null ? 43 : $codigoIncra.hashCode());
        String $nomePropriedade = this.getNomePropriedade();
        result = result * 59 + ($nomePropriedade == null ? 43 : $nomePropriedade.hashCode());
        BigDecimal $quantidadeAlqueires = this.getQuantidadeAlqueires();
        result = result * 59 + ($quantidadeAlqueires == null ? 43 : ((Object)$quantidadeAlqueires).hashCode());
        BigDecimal $quantidadeHectares = this.getQuantidadeHectares();
        result = result * 59 + ($quantidadeHectares == null ? 43 : ((Object)$quantidadeHectares).hashCode());
        BigDecimal $valorTerreno = this.getValorTerreno();
        result = result * 59 + ($valorTerreno == null ? 43 : ((Object)$valorTerreno).hashCode());
        BigDecimal $areaArrendada = this.getAreaArrendada();
        result = result * 59 + ($areaArrendada == null ? 43 : ((Object)$areaArrendada).hashCode());
        BigDecimal $areaCultivo = this.getAreaCultivo();
        result = result * 59 + ($areaCultivo == null ? 43 : ((Object)$areaCultivo).hashCode());
        BigDecimal $areaPasto = this.getAreaPasto();
        result = result * 59 + ($areaPasto == null ? 43 : ((Object)$areaPasto).hashCode());
        BigDecimal $areaTotal = this.getAreaTotal();
        result = result * 59 + ($areaTotal == null ? 43 : ((Object)$areaTotal).hashCode());
        BigDecimal $areaTotalConstruida = this.getAreaTotalConstruida();
        result = result * 59 + ($areaTotalConstruida == null ? 43 : ((Object)$areaTotalConstruida).hashCode());
        TipoOrigemInscricao $origemInscricao = this.getOrigemInscricao();
        result = result * 59 + ($origemInscricao == null ? 43 : $origemInscricao.hashCode());
        TipoCondicaoPessoaImovel $condicaoPessoaImovel = this.getCondicaoPessoaImovel();
        result = result * 59 + ($condicaoPessoaImovel == null ? 43 : $condicaoPessoaImovel.hashCode());
        String $numero = this.getNumero();
        result = result * 59 + ($numero == null ? 43 : $numero.hashCode());
        String $complemento = this.getComplemento();
        result = result * 59 + ($complemento == null ? 43 : $complemento.hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        LocalDate $dataAlteracao = this.getDataAlteracao();
        result = result * 59 + ($dataAlteracao == null ? 43 : ((Object)$dataAlteracao).hashCode());
        String $exclusaoLogica = this.getExclusaoLogica();
        result = result * 59 + ($exclusaoLogica == null ? 43 : $exclusaoLogica.hashCode());
        String $englobado = this.getEnglobado();
        result = result * 59 + ($englobado == null ? 43 : $englobado.hashCode());
        String $correspondenciaLocal = this.getCorrespondenciaLocal();
        result = result * 59 + ($correspondenciaLocal == null ? 43 : $correspondenciaLocal.hashCode());
        PessoaGeomaisDTO $pessoa = this.getPessoa();
        result = result * 59 + ($pessoa == null ? 43 : $pessoa.hashCode());
        LogradouroGeomaisDTO $logradouro = this.getLogradouro();
        result = result * 59 + ($logradouro == null ? 43 : $logradouro.hashCode());
        BairroGeomaisDTO $bairro = this.getBairro();
        result = result * 59 + ($bairro == null ? 43 : $bairro.hashCode());
        CidadeGeomaisDTO $cidade = this.getCidade();
        result = result * 59 + ($cidade == null ? 43 : $cidade.hashCode());
        DistritoGeomaisDTO $distrito = this.getDistrito();
        result = result * 59 + ($distrito == null ? 43 : $distrito.hashCode());
        SetorGeomaisDTO $setor = this.getSetor();
        result = result * 59 + ($setor == null ? 43 : $setor.hashCode());
        List $proprietarios = this.getProprietarios();
        result = result * 59 + ($proprietarios == null ? 43 : ((Object)$proprietarios).hashCode());
        List $boletim = this.getBoletim();
        result = result * 59 + ($boletim == null ? 43 : ((Object)$boletim).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CadastroRuralElogeoDTO(id=" + this.getId() + ", tipo=" + this.getTipo() + ", codigo=" + this.getCodigo() + ", cadastroGeralAnterior=" + this.getCadastroGeralAnterior() + ", endereco=" + this.getEndereco() + ", lote=" + this.getLote() + ", matricula=" + this.getMatricula() + ", oficio=" + this.getOficio() + ", resideImovel=" + this.getResideImovel() + ", numeroImovelReceita=" + this.getNumeroImovelReceita() + ", codigoIncra=" + this.getCodigoIncra() + ", nomePropriedade=" + this.getNomePropriedade() + ", quantidadeAlqueires=" + this.getQuantidadeAlqueires() + ", quantidadeHectares=" + this.getQuantidadeHectares() + ", valorTerreno=" + this.getValorTerreno() + ", areaArrendada=" + this.getAreaArrendada() + ", areaCultivo=" + this.getAreaCultivo() + ", areaPasto=" + this.getAreaPasto() + ", areaTotal=" + this.getAreaTotal() + ", areaTotalConstruida=" + this.getAreaTotalConstruida() + ", origemInscricao=" + this.getOrigemInscricao() + ", condicaoPessoaImovel=" + this.getCondicaoPessoaImovel() + ", numero=" + this.getNumero() + ", complemento=" + this.getComplemento() + ", cep=" + this.getCep() + ", dataInclusao=" + this.getDataInclusao() + ", dataAlteracao=" + this.getDataAlteracao() + ", exclusaoLogica=" + this.getExclusaoLogica() + ", englobado=" + this.getEnglobado() + ", correspondenciaLocal=" + this.getCorrespondenciaLocal() + ", pessoa=" + this.getPessoa() + ", logradouro=" + this.getLogradouro() + ", bairro=" + this.getBairro() + ", cidade=" + this.getCidade() + ", distrito=" + this.getDistrito() + ", setor=" + this.getSetor() + ", proprietarios=" + this.getProprietarios() + ", boletim=" + this.getBoletim() + ")";
    }
}

