/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto.integracaogeomais;

import br.com.elotech.tributos.domain.BoletimLogradouro;
import br.com.elotech.tributos.domain.ModeloResposta;
import br.com.elotech.tributos.domain.camposdinamicos.Alternativa;
import br.com.elotech.tributos.domain.camposdinamicos.Campo;
import br.com.elotech.tributos.domain.camposdinamicos.Resposta;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaRural;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaSegmento;
import br.com.elotech.tributos.domain.camposdinamicos.RespostaTerreno;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioSegmento;
import br.com.elotech.tributos.domain.imobiliario.BoletimImobiliarioTerreno;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliario;
import br.com.elotech.tributos.domain.imobiliario.CadastroImobiliarioSegmento;
import br.com.elotech.tributos.domain.rural.BoletimRural;
import br.com.elotech.tributos.domain.rural.CadastroRural;
import br.com.elotech.tributos.dto.integracaogeomais.ModeloRespostaGeomaisDTO;
import java.util.Objects;
import javax.validation.Valid;
import javax.validation.constraints.NotNull;
import lombok.Generated;

public class BoletimGeomaisDTO {
    private String descricao;
    @NotNull
    @Valid
    protected ModeloRespostaGeomaisDTO resposta;

    public static BoletimGeomaisDTO from(BoletimImobiliarioTerreno boletimImobiliarioTerreno) {
        BoletimGeomaisDTO boletimGeomaisDTO = new BoletimGeomaisDTO();
        boletimGeomaisDTO.setDescricao(boletimImobiliarioTerreno.getDescricaoResposta());
        boletimGeomaisDTO.setResposta(ModeloRespostaGeomaisDTO.from((ModeloResposta)boletimImobiliarioTerreno.getModeloResposta()));
        return boletimGeomaisDTO;
    }

    public static BoletimGeomaisDTO from(BoletimImobiliarioSegmento boletimImobiliarioSegmento) {
        BoletimGeomaisDTO boletimGeomaisDTO = new BoletimGeomaisDTO();
        boletimGeomaisDTO.setDescricao(boletimImobiliarioSegmento.getDescricaoResposta());
        boletimGeomaisDTO.setResposta(ModeloRespostaGeomaisDTO.from((ModeloResposta)boletimImobiliarioSegmento.getModeloResposta()));
        return boletimGeomaisDTO;
    }

    public static BoletimGeomaisDTO from(BoletimLogradouro boletimLogradouro) {
        BoletimGeomaisDTO boletimGeomaisDTO = new BoletimGeomaisDTO();
        boletimGeomaisDTO.setDescricao(boletimLogradouro.getDescricaoResposta());
        boletimGeomaisDTO.setResposta(ModeloRespostaGeomaisDTO.from((ModeloResposta)boletimLogradouro.getModeloResposta()));
        return boletimGeomaisDTO;
    }

    public static BoletimGeomaisDTO from(Resposta resposta) {
        BoletimGeomaisDTO boletimGeomaisDTO = new BoletimGeomaisDTO();
        boletimGeomaisDTO.setDescricao(resposta.getValor());
        boletimGeomaisDTO.setResposta(ModeloRespostaGeomaisDTO.from((Resposta)resposta));
        return boletimGeomaisDTO;
    }

    public BoletimImobiliarioTerreno toEntityTerreno(Long idCadastroImobiliario, ModeloResposta modeloResposta) {
        BoletimImobiliarioTerreno entity = new BoletimImobiliarioTerreno();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdCadastroImobiliario(idCadastroImobiliario);
        return entity;
    }

    public RespostaTerreno toEntityRespostaTerreno(CadastroImobiliario cadastroImobiliario, Alternativa alternativa, Campo campo) {
        RespostaTerreno entity = new RespostaTerreno();
        entity.setCadastroImobiliario(cadastroImobiliario);
        entity.setAlternativa(alternativa);
        entity.setCampo(campo);
        entity.setValor(Objects.nonNull(alternativa) ? alternativa.getDescricao() : this.getDescricao());
        return entity;
    }

    public BoletimImobiliarioSegmento toEntitySegmento(Long idImobiliarioSegmento, ModeloResposta modeloResposta) {
        BoletimImobiliarioSegmento entity = new BoletimImobiliarioSegmento();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdImobiliarioSegmento(idImobiliarioSegmento);
        return entity;
    }

    public RespostaSegmento toEntityRespotaSegmento(CadastroImobiliarioSegmento cadastroImobiliarioSegmento, Alternativa alternativa, Campo campo) {
        RespostaSegmento entity = new RespostaSegmento();
        entity.setSegmento(cadastroImobiliarioSegmento);
        entity.setAlternativa(alternativa);
        entity.setCampo(campo);
        if (Objects.nonNull(alternativa)) {
            entity.setValor(alternativa.getDescricao());
            return entity;
        }
        entity.setValor(this.getDescricao());
        return entity;
    }

    public RespostaRural toEntityRespostaRural(CadastroRural cadastroRural, Alternativa alternativa, Campo campo, Long id) {
        RespostaRural entity = new RespostaRural();
        entity.setCadastroRural(cadastroRural);
        entity.setId(id);
        entity.setAlternativa(alternativa);
        entity.setCampo(campo);
        if (Objects.nonNull(alternativa)) {
            entity.setValor(alternativa.getDescricao());
            return entity;
        }
        entity.setValor(this.getDescricao());
        return entity;
    }

    public BoletimLogradouro toEntityLogradouro(Long idLogradouroTestada, ModeloResposta modeloResposta) {
        BoletimLogradouro entity = new BoletimLogradouro();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdLogradouroTestada(idLogradouroTestada);
        return entity;
    }

    public BoletimRural toEntityRural(Long idCadastroRural, ModeloResposta modeloResposta) {
        BoletimRural entity = new BoletimRural();
        entity.setDescricaoResposta(this.getDescricao());
        entity.setModeloResposta(modeloResposta);
        entity.setIdCadastroRural(idCadastroRural);
        return entity;
    }

    public static BoletimGeomaisDTO from(BoletimRural boletimRural) {
        BoletimGeomaisDTO boletimGeomaisDTO = new BoletimGeomaisDTO();
        boletimGeomaisDTO.setDescricao(boletimRural.getDescricaoResposta());
        boletimGeomaisDTO.setResposta(ModeloRespostaGeomaisDTO.from((ModeloResposta)boletimRural.getModeloResposta()));
        return boletimGeomaisDTO;
    }

    @Generated
    public BoletimGeomaisDTO() {
    }

    @Generated
    public String getDescricao() {
        return this.descricao;
    }

    @Generated
    public ModeloRespostaGeomaisDTO getResposta() {
        return this.resposta;
    }

    @Generated
    public void setDescricao(String descricao) {
        this.descricao = descricao;
    }

    @Generated
    public void setResposta(ModeloRespostaGeomaisDTO resposta) {
        this.resposta = resposta;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof BoletimGeomaisDTO)) {
            return false;
        }
        BoletimGeomaisDTO other = (BoletimGeomaisDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        String this$descricao = this.getDescricao();
        String other$descricao = other.getDescricao();
        if (this$descricao == null ? other$descricao != null : !this$descricao.equals(other$descricao)) {
            return false;
        }
        ModeloRespostaGeomaisDTO this$resposta = this.getResposta();
        ModeloRespostaGeomaisDTO other$resposta = other.getResposta();
        return !(this$resposta == null ? other$resposta != null : !this$resposta.equals(other$resposta));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof BoletimGeomaisDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $descricao = this.getDescricao();
        result = result * 59 + ($descricao == null ? 43 : $descricao.hashCode());
        ModeloRespostaGeomaisDTO $resposta = this.getResposta();
        result = result * 59 + ($resposta == null ? 43 : $resposta.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "BoletimGeomaisDTO(descricao=" + this.getDescricao() + ", resposta=" + this.getResposta() + ")";
    }
}

