/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.util.MultiValueFilter;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Objects;
import lombok.Generated;
import org.springframework.jdbc.core.namedparam.MapSqlParameterSource;

public class FiltroAlteracaoVencimentosDTO
implements Serializable {
    private static final String EXERCICIO = "exercicio";
    private static final String TIPO_CADASTRO = "tipoCadastro";
    private static final String CADASTRO_GERAL = "cadastroGeral";
    private static final String SITUACAO_LEGAL = "situacaoLegal";
    private static final String DIVIDA = "divida";
    private static final String SUB_DIVIDA = "subDivida";
    private static final String PARCELA = "parcela";
    private static final String DATA_VENCIMENTO = "dataVencimento";
    private static final String DATA_VENCIMENTO_INICIAL = "dataVencimentoInicial";
    private static final String DATA_VENCIMENTO_FINAL = "dataVencimentoFinal";
    private String tipoCadastro;
    private String cadastroGeral;
    private Long parcela;
    private LocalDate dataVencimentoInicial;
    private LocalDate dataVencimentoFinal;
    private Long situacaoLegal;
    private String exercicio;
    private String divida;
    private String subDivida;
    private Boolean alterarVencimentoBoletoRegistradoViaWebService;
    private LocalDate dataVencimento;

    private String addAND(String clausula) {
        return " AND " + clausula;
    }

    public String buildFiltro() {
        StringBuilder where = new StringBuilder();
        if (Objects.nonNull(this.tipoCadastro) && !this.tipoCadastro.isEmpty()) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.tipoCadastro, (String)"debitoParcela.tipoCadastro")));
        }
        if (Objects.nonNull(this.cadastroGeral) && !this.cadastroGeral.isEmpty()) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.cadastroGeral, (String)"debitoParcela.cadastroGeral")));
        }
        if (Objects.nonNull(this.parcela)) {
            where.append(this.addAND("debitoParcela.parcela = :parcela"));
        }
        if (Objects.nonNull(this.dataVencimentoInicial)) {
            where.append(this.addAND("debitoParcela.datavencimento >= :dataVencimentoInicial"));
        }
        if (Objects.nonNull(this.dataVencimentoFinal)) {
            where.append(this.addAND("debitoParcela.datavencimento <= :dataVencimentoFinal"));
        }
        if (Objects.nonNull(this.situacaoLegal)) {
            where.append(this.addAND("debitoParcela.situacaolegal = :situacaoLegal"));
        }
        if (Objects.nonNull(this.exercicio)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.exercicio, (String)"debitoParcela.exercicio")));
        }
        if (Objects.nonNull(this.divida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.divida, (String)"debitoParcela.guiarecolhimento")));
        }
        if (Objects.nonNull(this.subDivida)) {
            where.append(this.addAND(MultiValueFilter.generateFilters((String)this.subDivida, (String)"debitoParcela.subdivida")));
        }
        return where.toString();
    }

    public MapSqlParameterSource buildParameters() {
        MapSqlParameterSource parameters = new MapSqlParameterSource();
        if (Objects.nonNull(this.getDataVencimento())) {
            parameters.addValue(DATA_VENCIMENTO, (Object)this.getDataVencimento(), 91);
        }
        parameters.addValue(PARCELA, (Object)this.getParcela(), 2);
        parameters.addValue(DATA_VENCIMENTO_INICIAL, (Object)this.getDataVencimentoInicial(), 91);
        parameters.addValue(DATA_VENCIMENTO_FINAL, (Object)this.getDataVencimentoFinal(), 91);
        parameters.addValue(SITUACAO_LEGAL, (Object)this.getSituacaoLegal(), 2);
        return parameters;
    }

    @Generated
    public FiltroAlteracaoVencimentosDTO(String tipoCadastro, String cadastroGeral, Long parcela, LocalDate dataVencimentoInicial, LocalDate dataVencimentoFinal, Long situacaoLegal, String exercicio, String divida, String subDivida, Boolean alterarVencimentoBoletoRegistradoViaWebService, LocalDate dataVencimento) {
        this.tipoCadastro = tipoCadastro;
        this.cadastroGeral = cadastroGeral;
        this.parcela = parcela;
        this.dataVencimentoInicial = dataVencimentoInicial;
        this.dataVencimentoFinal = dataVencimentoFinal;
        this.situacaoLegal = situacaoLegal;
        this.exercicio = exercicio;
        this.divida = divida;
        this.subDivida = subDivida;
        this.alterarVencimentoBoletoRegistradoViaWebService = alterarVencimentoBoletoRegistradoViaWebService;
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public FiltroAlteracaoVencimentosDTO() {
    }

    @Generated
    public String getTipoCadastro() {
        return this.tipoCadastro;
    }

    @Generated
    public String getCadastroGeral() {
        return this.cadastroGeral;
    }

    @Generated
    public Long getParcela() {
        return this.parcela;
    }

    @Generated
    public LocalDate getDataVencimentoInicial() {
        return this.dataVencimentoInicial;
    }

    @Generated
    public LocalDate getDataVencimentoFinal() {
        return this.dataVencimentoFinal;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public String getExercicio() {
        return this.exercicio;
    }

    @Generated
    public String getDivida() {
        return this.divida;
    }

    @Generated
    public String getSubDivida() {
        return this.subDivida;
    }

    @Generated
    public Boolean getAlterarVencimentoBoletoRegistradoViaWebService() {
        return this.alterarVencimentoBoletoRegistradoViaWebService;
    }

    @Generated
    public LocalDate getDataVencimento() {
        return this.dataVencimento;
    }

    @Generated
    public void setTipoCadastro(String tipoCadastro) {
        this.tipoCadastro = tipoCadastro;
    }

    @Generated
    public void setCadastroGeral(String cadastroGeral) {
        this.cadastroGeral = cadastroGeral;
    }

    @Generated
    public void setParcela(Long parcela) {
        this.parcela = parcela;
    }

    @Generated
    public void setDataVencimentoInicial(LocalDate dataVencimentoInicial) {
        this.dataVencimentoInicial = dataVencimentoInicial;
    }

    @Generated
    public void setDataVencimentoFinal(LocalDate dataVencimentoFinal) {
        this.dataVencimentoFinal = dataVencimentoFinal;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setExercicio(String exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setDivida(String divida) {
        this.divida = divida;
    }

    @Generated
    public void setSubDivida(String subDivida) {
        this.subDivida = subDivida;
    }

    @Generated
    public void setAlterarVencimentoBoletoRegistradoViaWebService(Boolean alterarVencimentoBoletoRegistradoViaWebService) {
        this.alterarVencimentoBoletoRegistradoViaWebService = alterarVencimentoBoletoRegistradoViaWebService;
    }

    @Generated
    public void setDataVencimento(LocalDate dataVencimento) {
        this.dataVencimento = dataVencimento;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FiltroAlteracaoVencimentosDTO)) {
            return false;
        }
        FiltroAlteracaoVencimentosDTO other = (FiltroAlteracaoVencimentosDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$parcela = this.getParcela();
        Long other$parcela = other.getParcela();
        if (this$parcela == null ? other$parcela != null : !((Object)this$parcela).equals(other$parcela)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Boolean this$alterarVencimentoBoletoRegistradoViaWebService = this.getAlterarVencimentoBoletoRegistradoViaWebService();
        Boolean other$alterarVencimentoBoletoRegistradoViaWebService = other.getAlterarVencimentoBoletoRegistradoViaWebService();
        if (this$alterarVencimentoBoletoRegistradoViaWebService == null ? other$alterarVencimentoBoletoRegistradoViaWebService != null : !((Object)this$alterarVencimentoBoletoRegistradoViaWebService).equals(other$alterarVencimentoBoletoRegistradoViaWebService)) {
            return false;
        }
        String this$tipoCadastro = this.getTipoCadastro();
        String other$tipoCadastro = other.getTipoCadastro();
        if (this$tipoCadastro == null ? other$tipoCadastro != null : !this$tipoCadastro.equals(other$tipoCadastro)) {
            return false;
        }
        String this$cadastroGeral = this.getCadastroGeral();
        String other$cadastroGeral = other.getCadastroGeral();
        if (this$cadastroGeral == null ? other$cadastroGeral != null : !this$cadastroGeral.equals(other$cadastroGeral)) {
            return false;
        }
        LocalDate this$dataVencimentoInicial = this.getDataVencimentoInicial();
        LocalDate other$dataVencimentoInicial = other.getDataVencimentoInicial();
        if (this$dataVencimentoInicial == null ? other$dataVencimentoInicial != null : !((Object)this$dataVencimentoInicial).equals(other$dataVencimentoInicial)) {
            return false;
        }
        LocalDate this$dataVencimentoFinal = this.getDataVencimentoFinal();
        LocalDate other$dataVencimentoFinal = other.getDataVencimentoFinal();
        if (this$dataVencimentoFinal == null ? other$dataVencimentoFinal != null : !((Object)this$dataVencimentoFinal).equals(other$dataVencimentoFinal)) {
            return false;
        }
        String this$exercicio = this.getExercicio();
        String other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !this$exercicio.equals(other$exercicio)) {
            return false;
        }
        String this$divida = this.getDivida();
        String other$divida = other.getDivida();
        if (this$divida == null ? other$divida != null : !this$divida.equals(other$divida)) {
            return false;
        }
        String this$subDivida = this.getSubDivida();
        String other$subDivida = other.getSubDivida();
        if (this$subDivida == null ? other$subDivida != null : !this$subDivida.equals(other$subDivida)) {
            return false;
        }
        LocalDate this$dataVencimento = this.getDataVencimento();
        LocalDate other$dataVencimento = other.getDataVencimento();
        return !(this$dataVencimento == null ? other$dataVencimento != null : !((Object)this$dataVencimento).equals(other$dataVencimento));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FiltroAlteracaoVencimentosDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $parcela = this.getParcela();
        result = result * 59 + ($parcela == null ? 43 : ((Object)$parcela).hashCode());
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Boolean $alterarVencimentoBoletoRegistradoViaWebService = this.getAlterarVencimentoBoletoRegistradoViaWebService();
        result = result * 59 + ($alterarVencimentoBoletoRegistradoViaWebService == null ? 43 : ((Object)$alterarVencimentoBoletoRegistradoViaWebService).hashCode());
        String $tipoCadastro = this.getTipoCadastro();
        result = result * 59 + ($tipoCadastro == null ? 43 : $tipoCadastro.hashCode());
        String $cadastroGeral = this.getCadastroGeral();
        result = result * 59 + ($cadastroGeral == null ? 43 : $cadastroGeral.hashCode());
        LocalDate $dataVencimentoInicial = this.getDataVencimentoInicial();
        result = result * 59 + ($dataVencimentoInicial == null ? 43 : ((Object)$dataVencimentoInicial).hashCode());
        LocalDate $dataVencimentoFinal = this.getDataVencimentoFinal();
        result = result * 59 + ($dataVencimentoFinal == null ? 43 : ((Object)$dataVencimentoFinal).hashCode());
        String $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : $exercicio.hashCode());
        String $divida = this.getDivida();
        result = result * 59 + ($divida == null ? 43 : $divida.hashCode());
        String $subDivida = this.getSubDivida();
        result = result * 59 + ($subDivida == null ? 43 : $subDivida.hashCode());
        LocalDate $dataVencimento = this.getDataVencimento();
        result = result * 59 + ($dataVencimento == null ? 43 : ((Object)$dataVencimento).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "FiltroAlteracaoVencimentosDTO(tipoCadastro=" + this.getTipoCadastro() + ", cadastroGeral=" + this.getCadastroGeral() + ", parcela=" + this.getParcela() + ", dataVencimentoInicial=" + this.getDataVencimentoInicial() + ", dataVencimentoFinal=" + this.getDataVencimentoFinal() + ", situacaoLegal=" + this.getSituacaoLegal() + ", exercicio=" + this.getExercicio() + ", divida=" + this.getDivida() + ", subDivida=" + this.getSubDivida() + ", alterarVencimentoBoletoRegistradoViaWebService=" + this.getAlterarVencimentoBoletoRegistradoViaWebService() + ", dataVencimento=" + this.getDataVencimento() + ")";
    }
}

