/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.dto;

import br.com.elotech.tributos.domain.DebitoParcelaId;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.dto.CancelamentoDebitoParcelaDTO;
import br.com.elotech.tributos.dto.CancelamentoDebitoTributoDTO;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.lang3.ObjectUtils;

public class CancelamentoDebitoDTO {
    Long entidade;
    Long exercicio;
    Long id;
    Boolean alterado;
    Boolean cancelamentoAutomatico;
    LocalDate dataCancelamento;
    LocalDate dataInclusao;
    String motivo;
    String situacao;
    Long motivoCancelamento;
    String motivoCancelamentoDescricao;
    Long situacaoLegal;
    Long tipoDeducao;
    String tipoDeducaoDescricao;
    String usuario;
    Boolean porTributo;
    List<CancelamentoDebitoParcelaDTO> parcelas = new ArrayList();
    List<CancelamentoDebitoTributoDTO> tributos = new ArrayList();

    public static CancelamentoDebitoDTO from(CancelamentoDebito cancelamentoDebito) {
        CancelamentoDebitoDTO dto = new CancelamentoDebitoDTO();
        dto.setEntidade(cancelamentoDebito.getId().getEntidade());
        dto.setExercicio(cancelamentoDebito.getId().getExercicio());
        dto.setId(cancelamentoDebito.getId().getId());
        dto.setAlterado(cancelamentoDebito.getAlterado());
        dto.setCancelamentoAutomatico(cancelamentoDebito.getCancelamentoAutomatico());
        dto.setDataCancelamento(cancelamentoDebito.getDataCancelamento());
        dto.setDataInclusao(cancelamentoDebito.getDataInclusao());
        dto.setSituacao(cancelamentoDebito.getSituacao());
        dto.setMotivo(cancelamentoDebito.getMotivo());
        dto.setMotivoCancelamento(Objects.nonNull(cancelamentoDebito.getMotivoCancelamento()) ? cancelamentoDebito.getMotivoCancelamento().getId() : null);
        dto.setMotivoCancelamentoDescricao(Objects.nonNull(cancelamentoDebito.getMotivoCancelamento()) ? cancelamentoDebito.getMotivoCancelamento().getDescricao() : null);
        dto.setSituacaoLegal(cancelamentoDebito.getSituacaoLegal());
        dto.setTipoDeducao(Objects.nonNull(cancelamentoDebito.getTipoDeducao()) ? cancelamentoDebito.getTipoDeducao().getId() : null);
        dto.setTipoDeducaoDescricao(Objects.nonNull(cancelamentoDebito.getTipoDeducao()) ? cancelamentoDebito.getTipoDeducao().getDescricao() : null);
        dto.setUsuario(cancelamentoDebito.getUsuario());
        dto.setPorTributo(cancelamentoDebito.getPorTributo());
        if (Objects.nonNull(cancelamentoDebito.getItens())) {
            if (((Boolean)ObjectUtils.defaultIfNull((Object)cancelamentoDebito.getPorTributo(), (Object)Boolean.FALSE)).booleanValue()) {
                dto.setTributos(cancelamentoDebito.getItens().stream().map(CancelamentoDebitoTributoDTO::from).collect(Collectors.toList()));
            } else {
                dto.setParcelas(cancelamentoDebito.getItens().stream().map(CancelamentoDebitoParcelaDTO::from).collect(Collectors.toList()));
                dto.agrupaCancelamentoDebitoParcelaDTOPorParcela();
            }
        }
        return dto;
    }

    private void agrupaCancelamentoDebitoParcelaDTOPorParcela() {
        ArrayList parcelasCancelamento = new ArrayList();
        Map listaAgrupadaPorParcela = this.agrupaPorParcela();
        listaAgrupadaPorParcela.forEach((debitoParcelaId, parcelasDTO) -> {
            CancelamentoDebitoParcelaDTO cancelamentoDebitoParcelaDTO = (CancelamentoDebitoParcelaDTO)parcelasDTO.get(0);
            CancelamentoDebitoParcelaDTO acumulado = this.getValorAcumulado(parcelasDTO);
            cancelamentoDebitoParcelaDTO.setValor(acumulado.getValor());
            cancelamentoDebitoParcelaDTO.setValorJuros(acumulado.getValorJuros());
            cancelamentoDebitoParcelaDTO.setValorMulta(acumulado.getValorMulta());
            cancelamentoDebitoParcelaDTO.setValorCorrecao(acumulado.getValorCorrecao());
            parcelasCancelamento.add(cancelamentoDebitoParcelaDTO);
        });
        this.getParcelas().clear();
        this.setParcelas(parcelasCancelamento);
        this.getParcelas().sort(this.getComparatorParcela());
    }

    private Map<DebitoParcelaId, List<CancelamentoDebitoParcelaDTO>> agrupaPorParcela() {
        return this.getParcelas().stream().collect(Collectors.groupingBy(cancelamentoDebitoParcelaDTO -> DebitoParcelaId.builder().entidade(cancelamentoDebitoParcelaDTO.getEntidade()).exercicio(cancelamentoDebitoParcelaDTO.getExercicio()).tipoCadastro(cancelamentoDebitoParcelaDTO.getTipoCadastro()).cadastroGeral(cancelamentoDebitoParcelaDTO.getCadastroGeral()).divida(cancelamentoDebitoParcelaDTO.getDivida()).subDivida(cancelamentoDebitoParcelaDTO.getSubDivida()).parcela(cancelamentoDebitoParcelaDTO.getParcela()).build(), Collectors.toList()));
    }

    private CancelamentoDebitoParcelaDTO getValorAcumulado(List<CancelamentoDebitoParcelaDTO> parcelasDTO) {
        return parcelasDTO.stream().reduce(new CancelamentoDebitoParcelaDTO(), (a, b) -> {
            a.setValor(a.getValor().add(b.getValor()));
            a.setValorJuros(a.getValorJuros().add(b.getValorJuros()));
            a.setValorMulta(a.getValorMulta().add(b.getValorMulta()));
            a.setValorCorrecao(a.getValorCorrecao().add(b.getValorCorrecao()));
            return a;
        });
    }

    private Comparator<CancelamentoDebitoParcelaDTO> getComparatorParcela() {
        return Comparator.comparing(CancelamentoDebitoParcelaDTO::getEntidade).thenComparing(CancelamentoDebitoParcelaDTO::getExercicio).thenComparing(CancelamentoDebitoParcelaDTO::getTipoCadastro).thenComparing(CancelamentoDebitoParcelaDTO::getCadastroGeral).thenComparing(CancelamentoDebitoParcelaDTO::getDivida).thenComparing(CancelamentoDebitoParcelaDTO::getSubDivida).thenComparing(CancelamentoDebitoParcelaDTO::getParcela);
    }

    @Generated
    public CancelamentoDebitoDTO() {
    }

    @Generated
    public Long getEntidade() {
        return this.entidade;
    }

    @Generated
    public Long getExercicio() {
        return this.exercicio;
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Boolean getAlterado() {
        return this.alterado;
    }

    @Generated
    public Boolean getCancelamentoAutomatico() {
        return this.cancelamentoAutomatico;
    }

    @Generated
    public LocalDate getDataCancelamento() {
        return this.dataCancelamento;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getMotivo() {
        return this.motivo;
    }

    @Generated
    public String getSituacao() {
        return this.situacao;
    }

    @Generated
    public Long getMotivoCancelamento() {
        return this.motivoCancelamento;
    }

    @Generated
    public String getMotivoCancelamentoDescricao() {
        return this.motivoCancelamentoDescricao;
    }

    @Generated
    public Long getSituacaoLegal() {
        return this.situacaoLegal;
    }

    @Generated
    public Long getTipoDeducao() {
        return this.tipoDeducao;
    }

    @Generated
    public String getTipoDeducaoDescricao() {
        return this.tipoDeducaoDescricao;
    }

    @Generated
    public String getUsuario() {
        return this.usuario;
    }

    @Generated
    public Boolean getPorTributo() {
        return this.porTributo;
    }

    @Generated
    public List<CancelamentoDebitoParcelaDTO> getParcelas() {
        return this.parcelas;
    }

    @Generated
    public List<CancelamentoDebitoTributoDTO> getTributos() {
        return this.tributos;
    }

    @Generated
    public void setEntidade(Long entidade) {
        this.entidade = entidade;
    }

    @Generated
    public void setExercicio(Long exercicio) {
        this.exercicio = exercicio;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setAlterado(Boolean alterado) {
        this.alterado = alterado;
    }

    @Generated
    public void setCancelamentoAutomatico(Boolean cancelamentoAutomatico) {
        this.cancelamentoAutomatico = cancelamentoAutomatico;
    }

    @Generated
    public void setDataCancelamento(LocalDate dataCancelamento) {
        this.dataCancelamento = dataCancelamento;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setMotivo(String motivo) {
        this.motivo = motivo;
    }

    @Generated
    public void setSituacao(String situacao) {
        this.situacao = situacao;
    }

    @Generated
    public void setMotivoCancelamento(Long motivoCancelamento) {
        this.motivoCancelamento = motivoCancelamento;
    }

    @Generated
    public void setMotivoCancelamentoDescricao(String motivoCancelamentoDescricao) {
        this.motivoCancelamentoDescricao = motivoCancelamentoDescricao;
    }

    @Generated
    public void setSituacaoLegal(Long situacaoLegal) {
        this.situacaoLegal = situacaoLegal;
    }

    @Generated
    public void setTipoDeducao(Long tipoDeducao) {
        this.tipoDeducao = tipoDeducao;
    }

    @Generated
    public void setTipoDeducaoDescricao(String tipoDeducaoDescricao) {
        this.tipoDeducaoDescricao = tipoDeducaoDescricao;
    }

    @Generated
    public void setUsuario(String usuario) {
        this.usuario = usuario;
    }

    @Generated
    public void setPorTributo(Boolean porTributo) {
        this.porTributo = porTributo;
    }

    @Generated
    public void setParcelas(List<CancelamentoDebitoParcelaDTO> parcelas) {
        this.parcelas = parcelas;
    }

    @Generated
    public void setTributos(List<CancelamentoDebitoTributoDTO> tributos) {
        this.tributos = tributos;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CancelamentoDebitoDTO)) {
            return false;
        }
        CancelamentoDebitoDTO other = (CancelamentoDebitoDTO)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$entidade = this.getEntidade();
        Long other$entidade = other.getEntidade();
        if (this$entidade == null ? other$entidade != null : !((Object)this$entidade).equals(other$entidade)) {
            return false;
        }
        Long this$exercicio = this.getExercicio();
        Long other$exercicio = other.getExercicio();
        if (this$exercicio == null ? other$exercicio != null : !((Object)this$exercicio).equals(other$exercicio)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$alterado = this.getAlterado();
        Boolean other$alterado = other.getAlterado();
        if (this$alterado == null ? other$alterado != null : !((Object)this$alterado).equals(other$alterado)) {
            return false;
        }
        Boolean this$cancelamentoAutomatico = this.getCancelamentoAutomatico();
        Boolean other$cancelamentoAutomatico = other.getCancelamentoAutomatico();
        if (this$cancelamentoAutomatico == null ? other$cancelamentoAutomatico != null : !((Object)this$cancelamentoAutomatico).equals(other$cancelamentoAutomatico)) {
            return false;
        }
        Long this$motivoCancelamento = this.getMotivoCancelamento();
        Long other$motivoCancelamento = other.getMotivoCancelamento();
        if (this$motivoCancelamento == null ? other$motivoCancelamento != null : !((Object)this$motivoCancelamento).equals(other$motivoCancelamento)) {
            return false;
        }
        Long this$situacaoLegal = this.getSituacaoLegal();
        Long other$situacaoLegal = other.getSituacaoLegal();
        if (this$situacaoLegal == null ? other$situacaoLegal != null : !((Object)this$situacaoLegal).equals(other$situacaoLegal)) {
            return false;
        }
        Long this$tipoDeducao = this.getTipoDeducao();
        Long other$tipoDeducao = other.getTipoDeducao();
        if (this$tipoDeducao == null ? other$tipoDeducao != null : !((Object)this$tipoDeducao).equals(other$tipoDeducao)) {
            return false;
        }
        Boolean this$porTributo = this.getPorTributo();
        Boolean other$porTributo = other.getPorTributo();
        if (this$porTributo == null ? other$porTributo != null : !((Object)this$porTributo).equals(other$porTributo)) {
            return false;
        }
        LocalDate this$dataCancelamento = this.getDataCancelamento();
        LocalDate other$dataCancelamento = other.getDataCancelamento();
        if (this$dataCancelamento == null ? other$dataCancelamento != null : !((Object)this$dataCancelamento).equals(other$dataCancelamento)) {
            return false;
        }
        LocalDate this$dataInclusao = this.getDataInclusao();
        LocalDate other$dataInclusao = other.getDataInclusao();
        if (this$dataInclusao == null ? other$dataInclusao != null : !((Object)this$dataInclusao).equals(other$dataInclusao)) {
            return false;
        }
        String this$motivo = this.getMotivo();
        String other$motivo = other.getMotivo();
        if (this$motivo == null ? other$motivo != null : !this$motivo.equals(other$motivo)) {
            return false;
        }
        String this$situacao = this.getSituacao();
        String other$situacao = other.getSituacao();
        if (this$situacao == null ? other$situacao != null : !this$situacao.equals(other$situacao)) {
            return false;
        }
        String this$motivoCancelamentoDescricao = this.getMotivoCancelamentoDescricao();
        String other$motivoCancelamentoDescricao = other.getMotivoCancelamentoDescricao();
        if (this$motivoCancelamentoDescricao == null ? other$motivoCancelamentoDescricao != null : !this$motivoCancelamentoDescricao.equals(other$motivoCancelamentoDescricao)) {
            return false;
        }
        String this$tipoDeducaoDescricao = this.getTipoDeducaoDescricao();
        String other$tipoDeducaoDescricao = other.getTipoDeducaoDescricao();
        if (this$tipoDeducaoDescricao == null ? other$tipoDeducaoDescricao != null : !this$tipoDeducaoDescricao.equals(other$tipoDeducaoDescricao)) {
            return false;
        }
        String this$usuario = this.getUsuario();
        String other$usuario = other.getUsuario();
        if (this$usuario == null ? other$usuario != null : !this$usuario.equals(other$usuario)) {
            return false;
        }
        List this$parcelas = this.getParcelas();
        List other$parcelas = other.getParcelas();
        if (this$parcelas == null ? other$parcelas != null : !((Object)this$parcelas).equals(other$parcelas)) {
            return false;
        }
        List this$tributos = this.getTributos();
        List other$tributos = other.getTributos();
        return !(this$tributos == null ? other$tributos != null : !((Object)this$tributos).equals(other$tributos));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CancelamentoDebitoDTO;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $entidade = this.getEntidade();
        result = result * 59 + ($entidade == null ? 43 : ((Object)$entidade).hashCode());
        Long $exercicio = this.getExercicio();
        result = result * 59 + ($exercicio == null ? 43 : ((Object)$exercicio).hashCode());
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $alterado = this.getAlterado();
        result = result * 59 + ($alterado == null ? 43 : ((Object)$alterado).hashCode());
        Boolean $cancelamentoAutomatico = this.getCancelamentoAutomatico();
        result = result * 59 + ($cancelamentoAutomatico == null ? 43 : ((Object)$cancelamentoAutomatico).hashCode());
        Long $motivoCancelamento = this.getMotivoCancelamento();
        result = result * 59 + ($motivoCancelamento == null ? 43 : ((Object)$motivoCancelamento).hashCode());
        Long $situacaoLegal = this.getSituacaoLegal();
        result = result * 59 + ($situacaoLegal == null ? 43 : ((Object)$situacaoLegal).hashCode());
        Long $tipoDeducao = this.getTipoDeducao();
        result = result * 59 + ($tipoDeducao == null ? 43 : ((Object)$tipoDeducao).hashCode());
        Boolean $porTributo = this.getPorTributo();
        result = result * 59 + ($porTributo == null ? 43 : ((Object)$porTributo).hashCode());
        LocalDate $dataCancelamento = this.getDataCancelamento();
        result = result * 59 + ($dataCancelamento == null ? 43 : ((Object)$dataCancelamento).hashCode());
        LocalDate $dataInclusao = this.getDataInclusao();
        result = result * 59 + ($dataInclusao == null ? 43 : ((Object)$dataInclusao).hashCode());
        String $motivo = this.getMotivo();
        result = result * 59 + ($motivo == null ? 43 : $motivo.hashCode());
        String $situacao = this.getSituacao();
        result = result * 59 + ($situacao == null ? 43 : $situacao.hashCode());
        String $motivoCancelamentoDescricao = this.getMotivoCancelamentoDescricao();
        result = result * 59 + ($motivoCancelamentoDescricao == null ? 43 : $motivoCancelamentoDescricao.hashCode());
        String $tipoDeducaoDescricao = this.getTipoDeducaoDescricao();
        result = result * 59 + ($tipoDeducaoDescricao == null ? 43 : $tipoDeducaoDescricao.hashCode());
        String $usuario = this.getUsuario();
        result = result * 59 + ($usuario == null ? 43 : $usuario.hashCode());
        List $parcelas = this.getParcelas();
        result = result * 59 + ($parcelas == null ? 43 : ((Object)$parcelas).hashCode());
        List $tributos = this.getTributos();
        result = result * 59 + ($tributos == null ? 43 : ((Object)$tributos).hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "CancelamentoDebitoDTO(entidade=" + this.getEntidade() + ", exercicio=" + this.getExercicio() + ", id=" + this.getId() + ", alterado=" + this.getAlterado() + ", cancelamentoAutomatico=" + this.getCancelamentoAutomatico() + ", dataCancelamento=" + this.getDataCancelamento() + ", dataInclusao=" + this.getDataInclusao() + ", motivo=" + this.getMotivo() + ", situacao=" + this.getSituacao() + ", motivoCancelamento=" + this.getMotivoCancelamento() + ", motivoCancelamentoDescricao=" + this.getMotivoCancelamentoDescricao() + ", situacaoLegal=" + this.getSituacaoLegal() + ", tipoDeducao=" + this.getTipoDeducao() + ", tipoDeducaoDescricao=" + this.getTipoDeducaoDescricao() + ", usuario=" + this.getUsuario() + ", porTributo=" + this.getPorTributo() + ", parcelas=" + this.getParcelas() + ", tributos=" + this.getTributos() + ")";
    }
}

