/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain.mobiliario;

import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.tributos.domain.Cbo;
import java.time.LocalDate;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.JoinColumns;
import javax.persistence.ManyToOne;
import javax.persistence.Table;
import lombok.Generated;
import org.springframework.beans.BeanUtils;

@Entity
@Table(name="TRIBMOBILIARIOCBO")
public class CadastroMobiliarioCbo
implements EloEntity<Long> {
    @Id
    @Column(name="idMobiliarioCbo")
    @EloSequence(applyOnMerge=true, sequenceName="S05MOBILIARIOCBO")
    private Long id;
    @ManyToOne
    @JoinColumns(value={@JoinColumn(name="sequenciacbo", referencedColumnName="sequenciacbo")})
    private Cbo cbo;
    @Column(length=20)
    private String numeroRegistro;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean principal = Boolean.FALSE;
    private LocalDate dataInicio;
    private LocalDate dataFim;

    public void merge(CadastroMobiliarioCbo cadastroMobiliarioCbo) {
        this.cbo = cadastroMobiliarioCbo.getCbo();
        this.principal = cadastroMobiliarioCbo.getPrincipal();
        this.dataInicio = cadastroMobiliarioCbo.getDataInicio();
        this.dataFim = cadastroMobiliarioCbo.getDataFim();
        this.numeroRegistro = cadastroMobiliarioCbo.getNumeroRegistro();
    }

    public CadastroMobiliarioCbo copy() {
        CadastroMobiliarioCbo cadastroMobiliarioCbo = new CadastroMobiliarioCbo();
        BeanUtils.copyProperties((Object)this, (Object)cadastroMobiliarioCbo, (String[])new String[]{"id"});
        return cadastroMobiliarioCbo;
    }

    @Generated
    public String toString() {
        return "CadastroMobiliarioCbo(id=" + this.getId() + ", cbo=" + this.getCbo() + ", numeroRegistro=" + this.getNumeroRegistro() + ", principal=" + this.getPrincipal() + ", dataInicio=" + this.getDataInicio() + ", dataFim=" + this.getDataFim() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CadastroMobiliarioCbo)) {
            return false;
        }
        CadastroMobiliarioCbo other = (CadastroMobiliarioCbo)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        if (this$id == null ? other$id != null : !((Object)this$id).equals(other$id)) {
            return false;
        }
        Boolean this$principal = this.getPrincipal();
        Boolean other$principal = other.getPrincipal();
        if (this$principal == null ? other$principal != null : !((Object)this$principal).equals(other$principal)) {
            return false;
        }
        Cbo this$cbo = this.getCbo();
        Cbo other$cbo = other.getCbo();
        if (this$cbo == null ? other$cbo != null : !this$cbo.equals(other$cbo)) {
            return false;
        }
        String this$numeroRegistro = this.getNumeroRegistro();
        String other$numeroRegistro = other.getNumeroRegistro();
        if (this$numeroRegistro == null ? other$numeroRegistro != null : !this$numeroRegistro.equals(other$numeroRegistro)) {
            return false;
        }
        LocalDate this$dataInicio = this.getDataInicio();
        LocalDate other$dataInicio = other.getDataInicio();
        if (this$dataInicio == null ? other$dataInicio != null : !((Object)this$dataInicio).equals(other$dataInicio)) {
            return false;
        }
        LocalDate this$dataFim = this.getDataFim();
        LocalDate other$dataFim = other.getDataFim();
        return !(this$dataFim == null ? other$dataFim != null : !((Object)this$dataFim).equals(other$dataFim));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof CadastroMobiliarioCbo;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        Boolean $principal = this.getPrincipal();
        result = result * 59 + ($principal == null ? 43 : ((Object)$principal).hashCode());
        Cbo $cbo = this.getCbo();
        result = result * 59 + ($cbo == null ? 43 : $cbo.hashCode());
        String $numeroRegistro = this.getNumeroRegistro();
        result = result * 59 + ($numeroRegistro == null ? 43 : $numeroRegistro.hashCode());
        LocalDate $dataInicio = this.getDataInicio();
        result = result * 59 + ($dataInicio == null ? 43 : ((Object)$dataInicio).hashCode());
        LocalDate $dataFim = this.getDataFim();
        result = result * 59 + ($dataFim == null ? 43 : ((Object)$dataFim).hashCode());
        return result;
    }

    @Generated
    public CadastroMobiliarioCbo() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public Cbo getCbo() {
        return this.cbo;
    }

    @Generated
    public String getNumeroRegistro() {
        return this.numeroRegistro;
    }

    @Generated
    public Boolean getPrincipal() {
        return this.principal;
    }

    @Generated
    public LocalDate getDataInicio() {
        return this.dataInicio;
    }

    @Generated
    public LocalDate getDataFim() {
        return this.dataFim;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setCbo(Cbo cbo) {
        this.cbo = cbo;
    }

    @Generated
    public void setNumeroRegistro(String numeroRegistro) {
        this.numeroRegistro = numeroRegistro;
    }

    @Generated
    public void setPrincipal(Boolean principal) {
        this.principal = principal;
    }

    @Generated
    public void setDataInicio(LocalDate dataInicio) {
        this.dataInicio = dataInicio;
    }

    @Generated
    public void setDataFim(LocalDate dataFim) {
        this.dataFim = dataFim;
    }
}

