/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.domain;

import br.com.elotech.audit.reader.DiffRevisionIgnore;
import br.com.elotech.core.annotation.EloSequence;
import br.com.elotech.core.converter.BooleanToStringConverter;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.enumerable.common.TipoPessoa;
import br.com.elotech.core.metamodel.annotation.Caption;
import br.com.elotech.tributos.domain.BancoPessoa;
import br.com.elotech.tributos.domain.ContatoPessoa;
import br.com.elotech.tributos.domain.EnderecoPessoa;
import br.com.elotech.tributos.util.CnpjCpfValidator;
import br.com.elotech.tributos.util.HibernateSearchDummyStringBridge;
import com.fasterxml.jackson.annotation.JsonIgnore;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import javax.persistence.CascadeType;
import javax.persistence.Column;
import javax.persistence.Convert;
import javax.persistence.Entity;
import javax.persistence.FetchType;
import javax.persistence.Id;
import javax.persistence.JoinColumn;
import javax.persistence.OneToMany;
import javax.persistence.Table;
import lombok.Generated;
import org.hibernate.annotations.DynamicInsert;
import org.hibernate.annotations.DynamicUpdate;
import org.hibernate.search.annotations.Analyze;
import org.hibernate.search.annotations.Analyzer;
import org.hibernate.search.annotations.Field;
import org.hibernate.search.annotations.FieldBridge;
import org.hibernate.search.annotations.Fields;
import org.hibernate.search.annotations.SortableField;
import org.hibernate.search.bridge.builtin.LongBridge;
import org.hibernate.validator.constraints.Length;

@Entity
@Table(name="PESSOA")
@DynamicInsert
@DynamicUpdate
public class Pessoa
implements EloEntity<Long>,
Serializable {
    private static final long serialVersionUID = 1L;
    @Field(name="idPessoa", analyze=Analyze.NO)
    @FieldBridge(impl=LongBridge.class)
    @Id
    @Column(name="PESSOA")
    @EloSequence(sequenceName="s90Pessoa")
    private Long id;
    @Caption(value="Tipo de Pessoa")
    private TipoPessoa tipoPessoa;
    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco_index")), @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco_query"), bridge=@FieldBridge(impl=HibernateSearchDummyStringBridge.class)), @Field(name="nome_sort", analyze=Analyze.YES, analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco_query"))})
    @Length(max=150)
    @SortableField(forField="nome_sort")
    @Caption(value="Nome")
    private @Length(max=150) String nome;
    @Fields(value={@Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco_index")), @Field(analyzer=@Analyzer(definition="dividePalavrasNoEspacoEmBranco_query"), bridge=@FieldBridge(impl=HibernateSearchDummyStringBridge.class))})
    @Length(max=150)
    @Caption(value="Nome Fantasia")
    @SortableField
    private @Length(max=150) String nomeFantasia;
    @JsonIgnore
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Caption(value="Endere\u00e7os")
    private final List<EnderecoPessoa> enderecos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Caption(value="Bancos")
    private final List<BancoPessoa> bancos = new ArrayList();
    @OneToMany(cascade={CascadeType.ALL}, orphanRemoval=true, fetch=FetchType.LAZY)
    @JoinColumn(name="pessoa", updatable=false, nullable=false)
    @Caption(value="Contatos")
    private final List<ContatoPessoa> contatos = new ArrayList();
    @Field(analyzer=@Analyzer(definition="removeCaracteresEspeciais"))
    @Column(name="CNPJ_CPF")
    @Length(max=20)
    @SortableField
    @Caption(value="CPF/CNPJ")
    private @Length(max=20) String cnpjCpf;
    @Field(analyzer=@Analyzer(definition="removeCaracteresEspeciais"))
    @Length(max=20)
    @Caption(value="RG")
    @SortableField
    private @Length(max=20) String rg;
    @Length(max=20)
    @Caption(value="\u00d3rg\u00e3o emissor do RG")
    private @Length(max=20) String orgaoEmissor;
    @Caption(value="Data de emiss\u00e3o do RG")
    private LocalDate dataEmissao;
    @Length(max=20)
    private @Length(max=20) String inscricaoEstadual;
    private Long sequenciaEndereco;
    private Long sequenciaContato;
    private Long sequenciaBanco;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean contribuinte;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean fornecedor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean pessoal;
    private LocalDate dataInclusao;
    @Length(max=1000)
    private @Length(max=1000) String observacao;
    @Length(max=250)
    private @Length(max=250) String usuarioInclusao;
    @Column(length=2)
    @Caption(value="Estado Emissor")
    private String estadoEmissor;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean microEmpresa;
    private LocalDate dataAlteracao;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean estrangeiro;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean autonomo;
    @Length(max=1000)
    private @Length(max=1000) String atividadePrincipal;
    @Column(name="inscricaoissqn")
    @Length(max=20)
    private @Length(max=20) String inscricaoMunicipal;
    private LocalDate dataIssqn;
    private Long fornecedorSiscop;
    @Length(max=18)
    private @Length(max=18) String codigoSistemaAnterior;
    @Convert(converter=BooleanToStringConverter.class)
    private Boolean inativo;
    private Long sequenciaImagem;
    @Length(max=60)
    private @Length(max=60) String activeFormOrigem;
    private LocalDate dataNascimento;
    @Length(max=12)
    private @Length(max=12) String nit;
    @Length(max=11)
    private @Length(max=11) String nire;
    @Column(name="pispasep")
    @Length(max=20)
    private @Length(max=20) String pis;
    private LocalDate dataAberturaCnpj;
    @Column(name="codigotce")
    @Length(max=20)
    private @Length(max=20) String idTcePR;
    private Long idUnico;

    public EnderecoPessoa getEnderecoPrincipal() {
        return this.enderecos.stream().filter(e -> e.getCodigo() != null && e.getCodigo().equals(this.sequenciaEndereco)).findFirst().orElse(null);
    }

    public void setEnderecoPrincipal(EnderecoPessoa enderecoPrincipal) {
        this.sequenciaEndereco = null;
        if (enderecoPrincipal != null) {
            this.sequenciaEndereco = enderecoPrincipal.getCodigo();
        }
    }

    public ContatoPessoa getContatoPrincipal() {
        return this.contatos.stream().filter(c -> c.getCodigo() != null && c.getCodigo().equals(this.sequenciaContato)).findFirst().orElse(null);
    }

    public void setContaBancariaPrincipal(BancoPessoa contaBancariaPrincipal) {
        this.sequenciaBanco = null;
        if (contaBancariaPrincipal != null) {
            this.sequenciaBanco = contaBancariaPrincipal.getCodigo();
        }
    }

    public BancoPessoa getContaBancariaPrincipal() {
        return this.bancos.stream().filter(b -> b.getCodigo() != null && b.getCodigo().equals(this.sequenciaBanco)).findFirst().orElse(null);
    }

    public void setContatoPrincipal(ContatoPessoa contatoPrincipal) {
        this.sequenciaContato = null;
        if (contatoPrincipal != null) {
            this.sequenciaContato = contatoPrincipal.getCodigo();
        }
    }

    public static Pessoa of(Long id) {
        return new Pessoa().withId(id);
    }

    public Pessoa withId(Long id) {
        this.setId(id);
        return this;
    }

    @DiffRevisionIgnore
    public Boolean isValidCnpjCpf() {
        return CnpjCpfValidator.isValidCnpjCpf((String)this.getCnpjCpf());
    }

    public String getCnpjCpfSemMascara() {
        if (Objects.isNull(this.cnpjCpf)) {
            return null;
        }
        return this.cnpjCpf.replaceAll("[^0-9]", "");
    }

    @Generated
    public Pessoa() {
    }

    @Generated
    public Long getId() {
        return this.id;
    }

    @Generated
    public TipoPessoa getTipoPessoa() {
        return this.tipoPessoa;
    }

    @Generated
    public String getNome() {
        return this.nome;
    }

    @Generated
    public String getNomeFantasia() {
        return this.nomeFantasia;
    }

    @Generated
    public List<EnderecoPessoa> getEnderecos() {
        return this.enderecos;
    }

    @Generated
    public List<BancoPessoa> getBancos() {
        return this.bancos;
    }

    @Generated
    public List<ContatoPessoa> getContatos() {
        return this.contatos;
    }

    @Generated
    public String getCnpjCpf() {
        return this.cnpjCpf;
    }

    @Generated
    public String getRg() {
        return this.rg;
    }

    @Generated
    public String getOrgaoEmissor() {
        return this.orgaoEmissor;
    }

    @Generated
    public LocalDate getDataEmissao() {
        return this.dataEmissao;
    }

    @Generated
    public String getInscricaoEstadual() {
        return this.inscricaoEstadual;
    }

    @Generated
    public Long getSequenciaEndereco() {
        return this.sequenciaEndereco;
    }

    @Generated
    public Long getSequenciaContato() {
        return this.sequenciaContato;
    }

    @Generated
    public Long getSequenciaBanco() {
        return this.sequenciaBanco;
    }

    @Generated
    public Boolean getContribuinte() {
        return this.contribuinte;
    }

    @Generated
    public Boolean getFornecedor() {
        return this.fornecedor;
    }

    @Generated
    public Boolean getPessoal() {
        return this.pessoal;
    }

    @Generated
    public LocalDate getDataInclusao() {
        return this.dataInclusao;
    }

    @Generated
    public String getObservacao() {
        return this.observacao;
    }

    @Generated
    public String getUsuarioInclusao() {
        return this.usuarioInclusao;
    }

    @Generated
    public String getEstadoEmissor() {
        return this.estadoEmissor;
    }

    @Generated
    public Boolean getMicroEmpresa() {
        return this.microEmpresa;
    }

    @Generated
    public LocalDate getDataAlteracao() {
        return this.dataAlteracao;
    }

    @Generated
    public Boolean getEstrangeiro() {
        return this.estrangeiro;
    }

    @Generated
    public Boolean getAutonomo() {
        return this.autonomo;
    }

    @Generated
    public String getAtividadePrincipal() {
        return this.atividadePrincipal;
    }

    @Generated
    public String getInscricaoMunicipal() {
        return this.inscricaoMunicipal;
    }

    @Generated
    public LocalDate getDataIssqn() {
        return this.dataIssqn;
    }

    @Generated
    public Long getFornecedorSiscop() {
        return this.fornecedorSiscop;
    }

    @Generated
    public String getCodigoSistemaAnterior() {
        return this.codigoSistemaAnterior;
    }

    @Generated
    public Boolean getInativo() {
        return this.inativo;
    }

    @Generated
    public Long getSequenciaImagem() {
        return this.sequenciaImagem;
    }

    @Generated
    public String getActiveFormOrigem() {
        return this.activeFormOrigem;
    }

    @Generated
    public LocalDate getDataNascimento() {
        return this.dataNascimento;
    }

    @Generated
    public String getNit() {
        return this.nit;
    }

    @Generated
    public String getNire() {
        return this.nire;
    }

    @Generated
    public String getPis() {
        return this.pis;
    }

    @Generated
    public LocalDate getDataAberturaCnpj() {
        return this.dataAberturaCnpj;
    }

    @Generated
    public String getIdTcePR() {
        return this.idTcePR;
    }

    @Generated
    public Long getIdUnico() {
        return this.idUnico;
    }

    @Generated
    public void setId(Long id) {
        this.id = id;
    }

    @Generated
    public void setTipoPessoa(TipoPessoa tipoPessoa) {
        this.tipoPessoa = tipoPessoa;
    }

    @Generated
    public void setNome(String nome) {
        this.nome = nome;
    }

    @Generated
    public void setNomeFantasia(String nomeFantasia) {
        this.nomeFantasia = nomeFantasia;
    }

    @Generated
    public void setCnpjCpf(String cnpjCpf) {
        this.cnpjCpf = cnpjCpf;
    }

    @Generated
    public void setRg(String rg) {
        this.rg = rg;
    }

    @Generated
    public void setOrgaoEmissor(String orgaoEmissor) {
        this.orgaoEmissor = orgaoEmissor;
    }

    @Generated
    public void setDataEmissao(LocalDate dataEmissao) {
        this.dataEmissao = dataEmissao;
    }

    @Generated
    public void setInscricaoEstadual(String inscricaoEstadual) {
        this.inscricaoEstadual = inscricaoEstadual;
    }

    @Generated
    public void setSequenciaEndereco(Long sequenciaEndereco) {
        this.sequenciaEndereco = sequenciaEndereco;
    }

    @Generated
    public void setSequenciaContato(Long sequenciaContato) {
        this.sequenciaContato = sequenciaContato;
    }

    @Generated
    public void setSequenciaBanco(Long sequenciaBanco) {
        this.sequenciaBanco = sequenciaBanco;
    }

    @Generated
    public void setContribuinte(Boolean contribuinte) {
        this.contribuinte = contribuinte;
    }

    @Generated
    public void setFornecedor(Boolean fornecedor) {
        this.fornecedor = fornecedor;
    }

    @Generated
    public void setPessoal(Boolean pessoal) {
        this.pessoal = pessoal;
    }

    @Generated
    public void setDataInclusao(LocalDate dataInclusao) {
        this.dataInclusao = dataInclusao;
    }

    @Generated
    public void setObservacao(String observacao) {
        this.observacao = observacao;
    }

    @Generated
    public void setUsuarioInclusao(String usuarioInclusao) {
        this.usuarioInclusao = usuarioInclusao;
    }

    @Generated
    public void setEstadoEmissor(String estadoEmissor) {
        this.estadoEmissor = estadoEmissor;
    }

    @Generated
    public void setMicroEmpresa(Boolean microEmpresa) {
        this.microEmpresa = microEmpresa;
    }

    @Generated
    public void setDataAlteracao(LocalDate dataAlteracao) {
        this.dataAlteracao = dataAlteracao;
    }

    @Generated
    public void setEstrangeiro(Boolean estrangeiro) {
        this.estrangeiro = estrangeiro;
    }

    @Generated
    public void setAutonomo(Boolean autonomo) {
        this.autonomo = autonomo;
    }

    @Generated
    public void setAtividadePrincipal(String atividadePrincipal) {
        this.atividadePrincipal = atividadePrincipal;
    }

    @Generated
    public void setInscricaoMunicipal(String inscricaoMunicipal) {
        this.inscricaoMunicipal = inscricaoMunicipal;
    }

    @Generated
    public void setDataIssqn(LocalDate dataIssqn) {
        this.dataIssqn = dataIssqn;
    }

    @Generated
    public void setFornecedorSiscop(Long fornecedorSiscop) {
        this.fornecedorSiscop = fornecedorSiscop;
    }

    @Generated
    public void setCodigoSistemaAnterior(String codigoSistemaAnterior) {
        this.codigoSistemaAnterior = codigoSistemaAnterior;
    }

    @Generated
    public void setInativo(Boolean inativo) {
        this.inativo = inativo;
    }

    @Generated
    public void setSequenciaImagem(Long sequenciaImagem) {
        this.sequenciaImagem = sequenciaImagem;
    }

    @Generated
    public void setActiveFormOrigem(String activeFormOrigem) {
        this.activeFormOrigem = activeFormOrigem;
    }

    @Generated
    public void setDataNascimento(LocalDate dataNascimento) {
        this.dataNascimento = dataNascimento;
    }

    @Generated
    public void setNit(String nit) {
        this.nit = nit;
    }

    @Generated
    public void setNire(String nire) {
        this.nire = nire;
    }

    @Generated
    public void setPis(String pis) {
        this.pis = pis;
    }

    @Generated
    public void setDataAberturaCnpj(LocalDate dataAberturaCnpj) {
        this.dataAberturaCnpj = dataAberturaCnpj;
    }

    @Generated
    public void setIdTcePR(String idTcePR) {
        this.idTcePR = idTcePR;
    }

    @Generated
    public void setIdUnico(Long idUnico) {
        this.idUnico = idUnico;
    }

    @Generated
    public String toString() {
        return "Pessoa(id=" + this.getId() + ", tipoPessoa=" + this.getTipoPessoa() + ", nome=" + this.getNome() + ", cnpjCpf=" + this.getCnpjCpf() + ")";
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof Pessoa)) {
            return false;
        }
        Pessoa other = (Pessoa)o;
        if (!other.canEqual((Object)this)) {
            return false;
        }
        Long this$id = this.getId();
        Long other$id = other.getId();
        return !(this$id == null ? other$id != null : !((Object)this$id).equals(other$id));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof Pessoa;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        Long $id = this.getId();
        result = result * 59 + ($id == null ? 43 : ((Object)$id).hashCode());
        return result;
    }
}

