/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.calculo.dto;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.calculo.domain.Calculo;
import br.com.elotech.tributos.calculo.dto.CalculoContext;
import br.com.elotech.tributos.calculo.dto.CalculoImobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoMobiliarioContext;
import br.com.elotech.tributos.calculo.dto.CalculoRuralContext;
import br.com.elotech.tributos.domain.TipoCadastro;
import br.com.elotech.tributos.domain.TipoDivida;
import java.util.Map;

public class CalculoContextFactory {
    private CalculoContextFactory() {
    }

    public static CalculoContext getContext(TipoDivida tipoDivida, TipoCadastro tipoCadastro) {
        TipoCadastro tipoCadastroParaContext = Calculo.getTipoCadastroByTipoDivida((TipoDivida)tipoDivida, (TipoCadastro)tipoCadastro);
        Map<TipoCadastro, CalculoRuralContext> contextMap = Map.of(TipoCadastro.IMOBILIARIO, new CalculoImobiliarioContext(), TipoCadastro.MOBILIARIO, new CalculoMobiliarioContext(), TipoCadastro.RURAL, new CalculoRuralContext());
        CalculoContext context = contextMap.getOrDefault(tipoCadastroParaContext, null);
        if (context == null) {
            throw new EloValidationException(String.format("N\u00e3o h\u00e1 implementa\u00e7\u00e3o de c\u00e1lculo para o tipo de d\u00edvida %s.", tipoDivida));
        }
        return context;
    }
}

