/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.supersimples.processamento;

import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoCnpj;
import br.com.elotech.tributos.domain.supersimples.SuperSimplesSolicitacaoSituacao;
import br.com.elotech.tributos.repository.supersimples.SuperSimplesSolicitacaoSituacaoRepository;
import java.util.List;
import javax.persistence.EntityManager;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.AfterWrite;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@StepScope
@Component
public class ProcessamentoVarreduraSuperSimplesWriter
implements ItemWriter<SuperSimplesSolicitacaoSituacao> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ProcessamentoVarreduraSuperSimplesWriter.class);
    private final SuperSimplesSolicitacaoSituacaoRepository superSimplesSolicitacaoSituacaoRepository;
    private final EntityManager entityManager;
    private StepExecution stepExecution;

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends SuperSimplesSolicitacaoSituacao> items) throws Exception {
        this.superSimplesSolicitacaoSituacaoRepository.saveAll(items);
        this.entityManager.flush();
    }

    @AfterWrite
    public void afterWrite(List<? extends SuperSimplesSolicitacaoCnpj> items) {
        Long idSolicitacao = this.stepExecution.getJobExecution().getJobParameters().getLong("idSolicitacao");
        Long sequenciaVarredura = this.stepExecution.getJobExecution().getJobParameters().getLong("sequenciaVarredura");
        int quantidadeProcessada = this.stepExecution.getReadCount() + items.size();
        log.info("Finalizado chunk da varredura {} da solicita\u00e7\u00e3o {}. Itens processados at\u00e9 o momento {}", new Object[]{sequenciaVarredura, idSolicitacao, quantidadeProcessada});
    }

    @Generated
    public ProcessamentoVarreduraSuperSimplesWriter(SuperSimplesSolicitacaoSituacaoRepository superSimplesSolicitacaoSituacaoRepository, EntityManager entityManager) {
        this.superSimplesSolicitacaoSituacaoRepository = superSimplesSolicitacaoSituacaoRepository;
        this.entityManager = entityManager;
    }
}

