/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.protesto.importacaoretornoremessa;

import br.com.elotech.tributos.domain.protesto.CartorioProtesto;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaIrregular;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaItem;
import br.com.elotech.tributos.domain.protesto.ProtestoRemessaOcorrencia;
import br.com.elotech.tributos.dto.RetornoRemessaItemDTO;
import br.com.elotech.tributos.repository.CartorioProtestoRepository;
import br.com.elotech.tributos.repository.ProtestoRemessaIrregularRepository;
import br.com.elotech.tributos.repository.ProtestoRemessaItemRepository;
import br.com.elotech.tributos.repository.ProtestoRemessaOcorrenciaRepository;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.format.DateTimeFormatter;
import java.util.function.Function;
import java.util.function.LongFunction;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ImportacaoRetornoRemessaBatchProcessor
implements ItemProcessor<RetornoRemessaItemDTO, ProtestoRemessaItem> {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(ImportacaoRetornoRemessaBatchProcessor.class);
    private final ProtestoRemessaItemRepository protestoRemessaItemRepository;
    private final CartorioProtestoRepository cartorioProtestoRepository;
    private final ProtestoRemessaOcorrenciaRepository protestoRemessaOcorrenciaRepository;
    private final ProtestoRemessaIrregularRepository protestoRemessaIrregularRepository;

    public ProtestoRemessaItem process(RetornoRemessaItemDTO retornoRemessaItemDTO) throws Exception {
        if (retornoRemessaItemDTO.getIdProtestoRemessaItem() == null) {
            return null;
        }
        ProtestoRemessaItem protestoRemessaItem = (ProtestoRemessaItem)this.protestoRemessaItemRepository.findOne((Object)retornoRemessaItemDTO.getIdProtestoRemessaItem());
        protestoRemessaItem.setCartorio(this.getCartorioProtesto(retornoRemessaItemDTO.getCodigoCartorio()));
        protestoRemessaItem.setProtocolo(this.convertToLong(retornoRemessaItemDTO.getNumeroProtocoloCartorio(), "protocolo"));
        protestoRemessaItem.setDataProtocolo(this.convertToDate(retornoRemessaItemDTO.getDataProtocolo(), "dataProtocolo"));
        protestoRemessaItem.setOcorrencia(this.getOcorrencia(retornoRemessaItemDTO.getTipoOcorrencia()));
        protestoRemessaItem.setDataOcorrencia(this.convertToDate(retornoRemessaItemDTO.getDataOcorrencia(), "dataOcorrencia"));
        protestoRemessaItem.setIrregularidade0(this.getIrregularidade(retornoRemessaItemDTO.getCodigoIrregularidade(), "irregularidade0"));
        protestoRemessaItem.setIrregularidade1(this.getIrregularidade(retornoRemessaItemDTO.getIrregularidade1(), "irregularidade1"));
        protestoRemessaItem.setIrregularidade2(this.getIrregularidade(retornoRemessaItemDTO.getIrregularidade2(), "irregularidade2"));
        protestoRemessaItem.setIrregularidade3(this.getIrregularidade(retornoRemessaItemDTO.getIrregularidade3(), "irregularidade3"));
        protestoRemessaItem.setIrregularidade4(this.getIrregularidade(retornoRemessaItemDTO.getIrregularidade4(), "irregularidade4"));
        protestoRemessaItem.setValorCustasCartorio(this.convertToBigDecimal(retornoRemessaItemDTO.getValorCustasCartorio(), "valorCustasCartorio"));
        protestoRemessaItem.setValorCustasDistribuidor(this.convertToBigDecimal(retornoRemessaItemDTO.getValorCustasDistribuidor(), "valorCustasDistribuidor"));
        protestoRemessaItem.setValorDemaisDespesas(this.convertToBigDecimal(retornoRemessaItemDTO.getValorDemaisDespesas(), "valorDemaisDespesas"));
        return protestoRemessaItem;
    }

    private CartorioProtesto getCartorioProtesto(String codigoCartorioStr) {
        return (CartorioProtesto)this.getEntityById(codigoCartorioStr, arg_0 -> ((CartorioProtestoRepository)this.cartorioProtestoRepository).findOne(arg_0), "Cart\u00f3rio");
    }

    private ProtestoRemessaOcorrencia getOcorrencia(String ocorrenciaStr) {
        return (ProtestoRemessaOcorrencia)this.getEntityById(ocorrenciaStr, arg_0 -> ((ProtestoRemessaOcorrenciaRepository)this.protestoRemessaOcorrenciaRepository).findOne(arg_0), "Ocorr\u00eancia");
    }

    private ProtestoRemessaIrregular getIrregularidade(String value, String fieldName) {
        if (this.isNullOrEmptyOrZero(value)) {
            return null;
        }
        try {
            return (ProtestoRemessaIrregular)this.protestoRemessaIrregularRepository.findOne((Object)value);
        }
        catch (Exception e) {
            log.warn("Falha ao buscar a irregularidade com o valor '{}' no campo '{}'.", (Object)value, (Object)fieldName);
            return null;
        }
    }

    private <T> T getEntityById(String value, LongFunction<T> repositoryMethod, String entityName) {
        if (this.isNullOrEmptyOrZero(value)) {
            return null;
        }
        try {
            long id = Long.parseLong(value);
            return repositoryMethod.apply(id);
        }
        catch (NumberFormatException e) {
            log.warn("Falha ao converter o valor '{}' para Long ao buscar entidade '{}'.", (Object)value, (Object)entityName);
            return null;
        }
    }

    private Long convertToLong(String value, String fieldName) {
        return (Long)this.convertToType(value, Long::valueOf, fieldName, "Long");
    }

    private BigDecimal convertToBigDecimal(String value, String fieldName) {
        return (BigDecimal)this.convertToType(value, BigDecimal::new, fieldName, "BigDecimal");
    }

    private LocalDate convertToDate(String value, String fieldName) {
        return (LocalDate)this.convertToType(value, arg_0 -> this.parseDate(arg_0), fieldName, "LocalDate");
    }

    private LocalDate parseDate(String value) {
        return LocalDate.parse(value, DateTimeFormatter.ofPattern("ddMMyyyy"));
    }

    private <T> T convertToType(String value, Function<String, T> converter, String fieldName, String typeName) {
        if (this.isNullOrEmptyOrZero(value)) {
            return null;
        }
        try {
            return converter.apply(value);
        }
        catch (Exception e) {
            log.warn("Falha ao converter o campo '{}' com valor '{}' para {}.", new Object[]{fieldName, value, typeName});
            return null;
        }
    }

    private boolean isNullOrEmptyOrZero(String value) {
        return value == null || value.trim().isEmpty() || value.matches("0+");
    }

    @Generated
    public ImportacaoRetornoRemessaBatchProcessor(ProtestoRemessaItemRepository protestoRemessaItemRepository, CartorioProtestoRepository cartorioProtestoRepository, ProtestoRemessaOcorrenciaRepository protestoRemessaOcorrenciaRepository, ProtestoRemessaIrregularRepository protestoRemessaIrregularRepository) {
        this.protestoRemessaItemRepository = protestoRemessaItemRepository;
        this.cartorioProtestoRepository = cartorioProtestoRepository;
        this.protestoRemessaOcorrenciaRepository = protestoRemessaOcorrenciaRepository;
        this.protestoRemessaIrregularRepository = protestoRemessaIrregularRepository;
    }
}

