/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.consultadebito;

import br.com.elotech.tributos.domain.ConsultaDebitoItem;
import br.com.elotech.tributos.repository.ConsultaDebitoItemRepository;
import java.util.List;
import javax.persistence.EntityManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ItemWriter;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ConsultaDebitoBatchWriter
implements ItemWriter<List<ConsultaDebitoItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsultaDebitoBatchWriter.class);
    private StepExecution stepExecution;
    private final ConsultaDebitoItemRepository consultaDebitoItemRepository;
    private final EntityManager entityManager;

    public ConsultaDebitoBatchWriter(ConsultaDebitoItemRepository consultaDebitoItemRepository, EntityManager entityManager) {
        this.consultaDebitoItemRepository = consultaDebitoItemRepository;
        this.entityManager = entityManager;
    }

    @BeforeStep
    void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
    }

    public void write(List<? extends List<ConsultaDebitoItem>> items) {
        LOGGER.debug("Salvando os itens. Read count {}. Job Id {}.", (Object)this.stepExecution.getReadCount(), (Object)this.stepExecution.getJobExecution().getId());
        items.forEach(debito -> {
            this.consultaDebitoItemRepository.saveAll((Iterable)debito);
            LOGGER.debug("Read Count: {}. {} registros salvos.", (Object)this.stepExecution.getReadCount(), (Object)debito.size());
        });
        this.entityManager.flush();
    }
}

