/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.consultadebito;

import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.ConsultaDebitoItem;
import br.com.elotech.tributos.domain.FormaPagamento;
import br.com.elotech.tributos.dto.DebitoConstituidoItemDTO;
import br.com.elotech.tributos.dto.FiltroConsultaDebitoDTO;
import br.com.elotech.tributos.dto.ListasNecessariasCalculaAcrescimoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.annotation.BeforeStep;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.ExecutionContext;
import org.springframework.batch.item.ItemProcessor;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ConsultaDebitoBatchProcessor
implements ItemProcessor<Long, List<ConsultaDebitoItem>> {
    private static final Logger LOGGER = LoggerFactory.getLogger(ConsultaDebitoBatchProcessor.class);
    private StepExecution stepExecution;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;
    private final CalculoAcrescimoService calculoAcrescimoService;
    private final DebitoRepository debitoRepository;
    private FiltroConsultaDebitoDTO filtro;
    private FormaPagamento formaPagamento;
    private ListasNecessariasCalculaAcrescimoDTO parametrosAcrescimos;

    public ConsultaDebitoBatchProcessor(ConsultaDebitoBatchService consultaDebitoBatchService, DebitoRepository debitoRepository, CalculoAcrescimoService calculoAcrescimoService) {
        this.consultaDebitoBatchService = consultaDebitoBatchService;
        this.calculoAcrescimoService = calculoAcrescimoService;
        this.debitoRepository = debitoRepository;
    }

    @BeforeStep
    public void beforeStep(StepExecution stepExecution) {
        this.stepExecution = stepExecution;
        ExecutionContext executionContext = this.stepExecution.getJobExecution().getExecutionContext();
        this.filtro = (FiltroConsultaDebitoDTO)executionContext.get("filtro");
        this.formaPagamento = (FormaPagamento)executionContext.get("formaPagamentoPadrao");
        this.parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimoBatch();
    }

    public List<ConsultaDebitoItem> process(Long idDebito) {
        LOGGER.debug("Iniciando o processamento do d\u00e9bito. ID: {}. Job ID: {}. Read Count: {}.", new Object[]{idDebito, this.stepExecution.getJobExecution().getId(), this.stepExecution.getReadCount()});
        ExecutionContext executionContext = this.stepExecution.getJobExecution().getExecutionContext();
        ConsultaDebito consultaDebito = (ConsultaDebito)executionContext.get("consultaDebito");
        LOGGER.debug("Processando d\u00e9bito com ID: {}. ID do Debito Consulta: {}", (Object)idDebito, (Object)Objects.requireNonNull(consultaDebito).getId());
        long startTime = System.currentTimeMillis();
        List debitosConstituidos = this.debitoRepository.findAllDebitoConstituidoById(this.filtro, idDebito);
        long endTime = System.currentTimeMillis();
        LOGGER.debug("Registros filhos buscados em {} ms", (Object)(endTime - startTime));
        if (Boolean.TRUE.equals(this.filtro.getCalcularAcrescimos())) {
            startTime = System.currentTimeMillis();
            this.consultaDebitoBatchService.calcularAcrescimos(debitosConstituidos, this.formaPagamento, this.filtro.getDataReferencia(), this.parametrosAcrescimos);
            endTime = System.currentTimeMillis();
            LOGGER.debug("Acr\u00e9scimos calculados em {} ms", (Object)(endTime - startTime));
            LOGGER.debug("Read Count: {}. {} registros calculado acr\u00e9scimo.", (Object)this.stepExecution.getReadCount(), (Object)debitosConstituidos.size());
        }
        ArrayList<ConsultaDebitoItem> consultaDebitoItems = new ArrayList<ConsultaDebitoItem>();
        debitosConstituidos.forEach(debito -> consultaDebitoItems.add(ConsultaDebitoItem.of((DebitoConstituidoItemDTO)debito, (ConsultaDebito)consultaDebito)));
        return consultaDebitoItems;
    }
}

