/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicadolivroda;

import br.com.elotech.core.domain.support.ElotechBeanPropertyRowMapper;
import br.com.elotech.core.utils.FileUtils;
import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import java.time.LocalDate;
import java.util.Map;
import javax.sql.DataSource;
import org.apache.commons.lang3.StringUtils;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.batch.item.database.JdbcCursorItemReader;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.jdbc.core.RowMapper;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoLivroDABatchReader
extends JdbcCursorItemReader<ComunicadoDebitoConsultaDTO> {
    private String SQLPATH = "sql/batch/comunicado/comunicadoLivroDaBatchReader.sql";
    private String SQLGROUPBY = "group by tlr.entidade,           tlr.exercicio,           tlr.livro,           tlr.pessoacontribuinte,           tlr.nomecontribuinte,           tlr.tipocadastro,           tlr.cadastrogeral,       tcg.idkey,        td.iddebito     order by tlr.tipocadastro,           tlr.cadastrogeral; ";
    private final String ANDVALIDACAODUPLICADO = " and not exists (                            select t.cadastrogeral  from tribcomunicadocadastro t  join tribcomunicado tc on t.exercicio = tc.exercicio and t.entidade = tc.entidade and t.idcomunicado = tc.idcomunicado  where t.tipocadastro = tcg.tipocadastro  and t.cadastrogeral = tcg.cadastrogeral  and tc.datavalidade >= :dataReferencia ) ";

    public ComunicadoLivroDABatchReader(@Value(value="#{jobParameters}") Map<String, Object> jobParameters, DataSource dataSource) {
        Long livro = (Long)jobParameters.get("livro");
        Long exercicio = (Long)jobParameters.get("exercicio");
        Long entidade = (Long)jobParameters.get("entidade");
        BooleanSimNao validacaoComunicadoDuplicado = BooleanSimNao.fromValue((String)((String)jobParameters.get("VALIDACOMUNICADODUPLICADO")));
        this.setFetchSize(1000);
        this.setName("comunicadoDebitoId");
        this.setDataSource(dataSource);
        this.setVerifyCursorPosition(Boolean.FALSE.booleanValue());
        this.setRowMapper((RowMapper)new ElotechBeanPropertyRowMapper(ComunicadoDebitoConsultaDTO.class));
        StringBuilder sql = new StringBuilder(FileUtils.readResourceAsString((String)this.SQLPATH));
        if (BooleanSimNao.SIM.equals((Object)validacaoComunicadoDuplicado)) {
            sql.append(" and not exists (                            select t.cadastrogeral  from tribcomunicadocadastro t  join tribcomunicado tc on t.exercicio = tc.exercicio and t.entidade = tc.entidade and t.idcomunicado = tc.idcomunicado  where t.tipocadastro = tcg.tipocadastro  and t.cadastrogeral = tcg.cadastrogeral  and tc.datavalidade >= :dataReferencia ) ".replace(":dataReferencia", StringUtils.wrap((String)LocalDate.now().toString(), (String)"'")));
        }
        sql.append(this.SQLGROUPBY);
        this.setSql(String.format(sql.toString(), entidade, exercicio, livro));
    }
}

