/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch.comunicado.simulacaocalculo;

import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.Comunicado;
import br.com.elotech.tributos.domain.ComunicadoId;
import br.com.elotech.tributos.domain.batch.BatchJobExecution;
import br.com.elotech.tributos.repository.ComunicadoRepository;
import br.com.elotech.tributos.service.NotificacaoService;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import lombok.Generated;
import org.springframework.batch.core.BatchStatus;
import org.springframework.batch.core.JobExecution;
import org.springframework.batch.core.JobParameters;
import org.springframework.batch.core.listener.JobExecutionListenerSupport;
import org.springframework.stereotype.Component;

@Component
public class ComunicadoSimulacaoCalculoJobListener
extends JobExecutionListenerSupport {
    private static final String ID_CALCULO = "idCalculo";
    private final NotificacaoService notificacaoService;
    private final ComunicadoRepository comunicadoRepository;

    public void beforeJob(JobExecution jobExecution) {
        super.beforeJob(jobExecution);
        ComunicadoId comunicadoId = new ComunicadoId();
        JobParameters jobParameters = Objects.requireNonNull(jobExecution.getJobParameters());
        comunicadoId.setEntidade(jobParameters.getLong("entidade"));
        comunicadoId.setExercicio(jobParameters.getLong("exercicioComunicado"));
        comunicadoId.setIdComunicado(jobParameters.getLong("idComunicado"));
        Comunicado comunicado = (Comunicado)this.comunicadoRepository.findOne((Object)comunicadoId);
        comunicado.setBatchJobExecutionComunicado(BatchJobExecution.of((JobExecution)jobExecution));
        this.comunicadoRepository.save((Object)comunicado);
        Optional notificacaoId = this.notificacaoService.send("Comunicado Simula\u00e7\u00e3o de C\u00e1lculo - iniciada", String.format("Foi iniciada a rotina de comunicado de simula\u00e7\u00e3o de c\u00e1lculo %d/%d", comunicadoId.getIdComunicado(), comunicadoId.getExercicio()), jobExecution, Optional.empty(), NotificationStatus.STARTED);
        jobExecution.getExecutionContext().put(ID_CALCULO, notificacaoId.map(UUID::toString).orElse(null));
    }

    public void afterJob(JobExecution jobExecution) {
        super.afterJob(jobExecution);
        Long idComunicado = jobExecution.getJobParameters().getLong("idComunicado");
        Long exercicioComunicado = jobExecution.getJobParameters().getLong("exercicioComunicado");
        UUID notificacaoId = UUID.fromString(Objects.requireNonNull(jobExecution.getExecutionContext().get(ID_CALCULO)).toString());
        if (BatchStatus.COMPLETED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Comunicado Simula\u00e7\u00e3o de C\u00e1lculo - finalizado com sucesso", String.format("Os dados referentes ao Comunicado a partir da Simula\u00e7\u00e3o de C\u00e1lculo foram gerados com sucesso. %d/%d", idComunicado, exercicioComunicado), jobExecution, Optional.of(notificacaoId), NotificationStatus.COMPLETED);
        }
        if (BatchStatus.FAILED.equals((Object)jobExecution.getStatus())) {
            this.notificacaoService.send("Comunicado Simula\u00e7\u00e3o de C\u00e1lculo - finalizado com erro", String.format("Ocorreu um erro ao gerar os dados referentes ao Comunicado a partir da Simula\u00e7\u00e3o de C\u00e1lculo. %d/%d", idComunicado, exercicioComunicado), jobExecution, Optional.of(notificacaoId), NotificationStatus.FAILED);
        }
    }

    @Generated
    public ComunicadoSimulacaoCalculoJobListener(NotificacaoService notificacaoService, ComunicadoRepository comunicadoRepository) {
        this.notificacaoService = notificacaoService;
        this.comunicadoRepository = comunicadoRepository;
    }
}

