/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.batch;

import br.com.elotech.tributos.batch.ComunicadoGeracaoBatchProcessor;
import br.com.elotech.tributos.domain.ComunicadoCadastro;
import br.com.elotech.tributos.domain.ConsultaDebito;
import br.com.elotech.tributos.domain.TipoFiltroNotificacaoComunicado;
import br.com.elotech.tributos.dto.ComunicadoConsultaReceitas;
import br.com.elotech.tributos.dto.ComunicadoDebitoConsultaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.repository.DebitoRepository;
import br.com.elotech.tributos.service.ConsultaDebitoBatchService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.acrescimo.calculo.CalculoAcrescimoService;
import br.com.elotech.tributos.service.comunicado.ComunicadoCadastroService;
import br.com.elotech.tributos.service.comunicado.ComunicadoService;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.Serializable;
import java.util.List;
import javax.persistence.EntityManager;
import org.springframework.batch.core.StepExecution;
import org.springframework.batch.core.configuration.annotation.StepScope;
import org.springframework.stereotype.Component;

@Component
@StepScope
public class ComunicadoByConsultaDebitoBatchProcessor
extends ComunicadoGeracaoBatchProcessor {
    private final DebitoRepository debitoRepository;
    private final ConsultaDebitoBatchService consultaDebitoBatchService;
    private ConsultaDebito consultaDebito;

    protected ComunicadoByConsultaDebitoBatchProcessor(ComunicadoCadastroService comunicadoCadastroService, ComunicadoService comunicadoService, GeraBoletoService geraBoletoService, CalculoAcrescimoService calculoAcrescimoService, EntityManager em, DebitoRepository debitoRepository, ObjectMapper objectMapper, ConsultaDebitoBatchService consultaDebitoBatchService) {
        super(comunicadoCadastroService, comunicadoService, geraBoletoService, calculoAcrescimoService, em, objectMapper);
        this.debitoRepository = debitoRepository;
        this.consultaDebitoBatchService = consultaDebitoBatchService;
    }

    protected void loadContext(StepExecution stepExecution) {
        super.loadContext(stepExecution);
        Long idConsultaDebito = this.stepExecution.getJobExecution().getJobParameters().getLong("idConsultaDebito");
        this.parametrosAcrescimos = this.calculoAcrescimoService.createNecessariasCalculaAcrescimoBatch();
        this.consultaDebito = (ConsultaDebito)this.consultaDebitoBatchService.findOne((Serializable)idConsultaDebito);
    }

    protected List<ComunicadoConsultaReceitas> findReceitas(ComunicadoDebitoConsultaDTO consulta) {
        return this.debitoRepository.findReceitasIdConsultaDebito(consulta.getId(), consulta.getTipocadastro(), consulta.getCadastrogeral());
    }

    protected boolean shouldGenerateBoleto(ComunicadoCadastro comunicadoCadastro) {
        return this.tipoFiltroNotificacaoComunicado.equals((Object)TipoFiltroNotificacaoComunicado.DEBITOS_COM_BLOQUETO) && this.consultaDebito.getDataReferencia() != null && !comunicadoCadastro.getComunicadoDebitos().isEmpty();
    }

    protected GeraBoletoDTO buildGeraBoletoDTO(ComunicadoCadastro comunicadoCadastro) {
        GeraBoletoDTO dto = super.buildGeraBoletoDTO(comunicadoCadastro);
        dto.setDataReferencia(this.consultaDebito.getDataReferencia());
        return dto;
    }
}

