select 06                     as codigoArquivo,
       'Estorno de Dedução dos Créditos' as arquivo,
       'CREDITO'               as tipoArquivo,
       arquivo.valor          as valorArquivo,
       integracao.valor       as valorIntegracao,
       0                      as valorRetencao,
       (select
        case when count(teis.idregistro) > 0 then 'true' else 'false' end
        from tcededucaocreditoest tdce
        join triberrosimportacaosimam teis on
        teis.idregistro = tdce.idtcededucaocreditoest
        and teis.identificadorarquivo = 'ESTORNO_DEDUCAO_CREDITO'
        where tdce.dtestorno between :dataInicial and :dataFinal) as temerroimportacao
from (select sum(filtro.vlDeducao) as valor
         from (select coalesce(tdce.vlestorno, 0) as vlDeducao
               from tcededucaocreditoest tdce
               where tdce.dtestorno between :dataInicial and :dataFinal) filtro) as arquivo
cross join (select sum(valor) as valor
            from (select iip.valor as valor
                  from integracaopatrimonial ip
                           left join itemintegracaopatrimonial iip on ip.id = iip.idintegracaopatrimonial
                           left join tribreceita r
                                     on r.receita = iip.tributo and r.exercicio = ip.exercicio and
                                        r.entidade = ip.entidade
                           JOIN tribreceitatipo trt
                                ON trt.tiporeceita = r.tiporeceita
                  where ip.entidade = :entidade
                    and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                    and ip.datamovimento between :dataInicial and :dataFinal
                    and iip.tipomovimento in ('ESTORNO_CANCELAMENTO', 'ESTORNO_DACAO_PAGAMENTO', 'ESTORNO_DESCONTO_PARCELAMENTO')
                    and iip.situacaolegal = 0
                    and ip.situacaointegracaopatrimonial != 'ESTORNADO_CONTABILIDADE'
                  union all
                  select liic.valordeducao
                  from loteintegracaocontabil lic
                      left join loteitemintegracaocontabil liic
                  on lic.id = liic.idlote
                      left join tribreceita tr on liic.idtributo = tr.id
                      left JOIN tribreceitatipo trt ON trt.tiporeceita = tr.tiporeceita
                      left join tribmotivodesconto tmd on liic.idmotivodeducao = tmd.motivodesconto
                  where lic.datalote between :dataInicial and :dataFinal
                    and trt.classificacaoreceitatipo IN (1, 2, 3, 4, 5, 7)
                    and liic.situacaolegal = 0
                    and lic.situacaointegracaocontabil != 'ESTORNADO_CONTABILIDADE'
                    and lic.tipolote = 'ESTORNO_PAGAMENTO'
                    and liic.valordeducao > 0) as dados) as integracao