select tp.entidade,
       tep.dataestorno           as datamovimentacao,
       tr.receita                as tributo,
       tr.descricao              as descricaotributo,
       tr.tiporeceita            as tipoTributo,
       case
         when tr.classificacao = 'F'
         then 'J'
         else tr.classificacao
       end                       classificacaotributo,
       case
         when acrescimo.situacaolegal <> 0 and ( acrescimo.datadividaativa is null or acrescimo.datadividaativa <= tep.dataestorno )
         then acrescimo.situacaolegal
         else 0
       end                       situacaolegal,
       ttot.codigotce                    as tipooperacaodeducao,
       'ESTORNO_ACRESCIMOS_PARCELAMENTO' as tipomovimento,
       td.iddebito,
       p.idunico as idunicopessoa,
       acrescimo.iddebitoparcelareceita,
       acrescimo.valor      as valor
from   tribestornoparcelamento tep
       left outer join tribparcelamento tp
                    on tp.idparcelamento = tep.idparcelamento
       left outer join tribparamparcelamento tpp
                    on tp.idparametroparcelamento = tpp.idparametroparcelamento
       left outer join tribmotivodesconto tmd
                    on tpp.motivoestorno = tmd.motivodesconto
       left outer join tribtipooperacaotce ttot
                    on tmd.idtipooperacaotce = ttot.idtipooperacaotce
         left join (select
                           x.idparcelamento,
                           case
                               when x.parcela = x.max_parcela then
                                       x.valorjuros -
                                       coalesce((select sum(y.rateio_juros)
                                                 from vw_atualizacao_parcelamento y
                                                 where y.idparcelamento = x.idparcelamento
                                                   and y.iddebito = x.iddebito
                                                   and y.receitaorigem = x.receitaorigem
                                                   and y.parcela <> x.max_parcela
                                                   and y.idestornoparcelamento = x.idestornoparcelamento), 0)
                               else x.rateio_juros end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.jurosdestino as receita,
                           x.guiarecolhimento,
                           x.situacaolegal,
                           x.datadividaativa
                      from vw_atualizacao_parcelamento x
                      where x.rateio_juros > 0
                      and x.dataestorno in (:datasMovimento)
                      union
                      select
                           x.idparcelamento,
                           case
                               when x.parcela = x.max_parcela then
                                       x.valormulta -
                                       coalesce((select sum(y.rateio_multa)
                                                 from vw_atualizacao_parcelamento y
                                                 where y.idparcelamento = x.idparcelamento
                                                   and y.iddebito = x.iddebito
                                                   and y.receitaorigem = x.receitaorigem
                                                   and y.parcela <> x.max_parcela
                                                   and y.idestornoparcelamento = x.idestornoparcelamento), 0)
                               else x.rateio_multa end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.multadestino as receita,
                           x.guiarecolhimento,
                           x.situacaolegal,
                           x.datadividaativa
                      from vw_atualizacao_parcelamento x
                      where x.rateio_multa > 0
                      and x.dataestorno in (:datasMovimento)
                      union
                      select
                           x.idparcelamento,
                           case
                               when x.parcela = x.max_parcela then
                                       x.valorcorrecao -
                                       coalesce((select sum(y.rateio_correcao)
                                                 from vw_atualizacao_parcelamento y
                                                 where y.idparcelamento = x.idparcelamento
                                                   and y.iddebito = x.iddebito
                                                   and y.receitaorigem = x.receitaorigem
                                                   and y.parcela <> x.max_parcela
                                                   and y.idestornoparcelamento = x.idestornoparcelamento), 0)
                               else x.rateio_correcao end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.correcaodestino as receita,
                           x.guiarecolhimento,
                           x.situacaolegal,
                           x.datadividaativa
                      from vw_atualizacao_parcelamento x
                      where x.rateio_correcao > 0
                      and x.dataestorno in (:datasMovimento)
                      union
                      select
                           x.idparcelamento,
                           case
                               when x.parcela = x.max_parcela then
                                           x.valorjurosfinan + x.juros_financiamento_extra -
                                           coalesce((select sum(y.rateio_juros_financiamento)
                                                     from vw_atualizacao_parcelamento y
                                                     where y.idparcelamento = x.idparcelamento
                                                       and y.iddebito = x.iddebito
                                                       and y.receitaorigem = x.receitaorigem
                                                       and y.parcela <> x.max_parcela
                                                       and y.idestornoparcelamento = x.idestornoparcelamento), 0)
                               else x.rateio_juros_financiamento + x.juros_financiamento_extra end as valor,
                           x.iddebitoparcelareceita,
                           x.iddebito,
                           x.jurosfinandestino as receita,
                           x.guiarecolhimento,
                           x.situacaolegal,
                           x.datadividaativa
                      from vw_atualizacao_parcelamento x
                      where x.rateio_juros_financiamento > 0
                      and x.dataestorno in (:datasMovimento)
                      ) as acrescimo
                    on acrescimo.idparcelamento = tp.idparcelamento
       left outer join tribdebito td
                    on td.iddebito = acrescimo.iddebito
                  join tribcadastrogeral tcg
                    on td.tipocadastro = tcg.tipocadastro
                   and td.cadastrogeral = tcg.cadastrogeral
                  join pessoa p
                    on tcg.pessoa = p.pessoa
       left outer join tribreceita tr
                    on td.entidade = tr.entidade
                   and :exercicio = tr.exercicio
                   and acrescimo.receita = tr.receita
where  td.constituido = 'S'
  and  tp.anocontrato = :exercicio
  and  (tep.datareabilitacao is null or tep.datareabilitacao != tep.dataestorno)
  and  exists(select 1 from tribestornoparcelamentodebito tepd
                      where tepd.idestornoparcelamento = tep.idestornoparcelamento
                        and tepd.iddebitoorigem > tepd.iddebitodestino)