Select distinct TribParcelamento.IdParcelamento,
       TribParcelamento.Numerocontrato,
       TribParcelamento.Anocontrato,
       TribParcelamento.DataParcelamento,
       TribParcelamento.Tipocadastro,
       TribParcelamento.Cadastrogeral,
       situacao.descricao as situacao,
       Pessoa.Nome,
      (select SUM(DPR.VALOR)
                from tribdebito d
                join tribdebitoparcelareceita dpr
                  on dpr.entidade = d.entidade
                 and dpr.exercicio = d.exercicio
                 and dpr.tipocadastro = d.tipocadastro
                 and dpr.cadastrogeral = d.cadastrogeral
                 and dpr.guiarecolhimento = d.guiarecolhimento
                 and dpr.subdivida = d.subdivida
                join tribreceita tr
                  on tr.entidade = dpr.entidade
                 and tr.exercicio = dpr.exercicio
                 and tr.receita = dpr.receita
               WHERE D.IDPARCELAMENTO = TribParcelamento.Idparcelamento
                 and tr.classificacao <> 'F') AS valorcontrato,
       (select count(distinct b.bloqueto) as total
        from Tribparcelamentodebitoorigem Tribparcelamentodebitoorigem
        left outer join TribDebito TribDebito
                on TribDebito.Iddebito = Tribparcelamentodebitoorigem.Iddebitonovo
        left outer join TribDebitoParcelaReceita dpr
                on TribDebito.Entidade = dpr.entidade and
                   TribDebito.Exercicio = dpr.Exercicio and
                   TribDebito.Tipocadastro = dpr.tipocadastro and
                   TribDebito.Cadastrogeral = dpr.Cadastrogeral and
                   TribDebito.Guiarecolhimento = dpr.guiarecolhimento and
                   TribDebito.Subdivida = dpr.subdivida
        left outer join TribBloquetoDebito bd
                on dpr.iddebitoparcelareceita = bd.iddebitoparcelareceita
        left outer join TribBloqueto b
                on bd.entidade = b.entidade and
                   bd.exerciciobloqueto = b.exerciciobloqueto and
                   bd.bloqueto = b.bloqueto
        left outer join TribCadastroGeral cg
                on b.Tipocadastro = cg.Tipocadastro and
                   b.Cadastrogeral = cg.Cadastrogeral
        left outer join Pessoa p
                on cg.Pessoa = p.Pessoa
        Where b.Entidade = :entidade
          and (:exercicio = :exercicio)
          and b.DATAVENCIMENTO >= :DataVencimento
          and Tribparcelamentodebitoorigem.Idparcelamento = TribParcelamento.Idparcelamento) as TotalBloquetoEmitido
  from TribParcelamento TribParcelamento
  left outer join TribCadastroGeral TribCadastroGeral
          on TribParcelamento.Tipocadastro = TribCadastroGeral.Tipocadastro and
             TribParcelamento.Cadastrogeral = TribCadastroGeral.Cadastrogeral
  left outer join Pessoa Pessoa
          on TribCadastroGeral.Pessoa = Pessoa.Pessoa
  left outer join Tribsituacaoparcelamento situacao
          		on TribParcelamento.situacao = situacao.situacao
  where TribParcelamento.Estornado = 'N'
    $[FiltroDesfazerParcelamento]
    and not exists(
    select
    	distinct 1
    from
    	tribdebitoparcela tdp
    left join tribdebito td on
    	td.entidade = tdp.entidade
    	and td.exercicio = tdp.exercicio
           and td.Tipocadastro = tdp.tipocadastro
    	and td.cadastrogeral = tdp.cadastrogeral
    	and td.guiarecolhimento = tdp.guiarecolhimento
    	and td.subdivida = tdp.subdivida
    left join tribsituacaoparcela tsp on
    	tsp.situacaoparcela = tdp.situacaodebito
    where
    	td.idparcelamento = TribParcelamento.IdParcelamento
    	and tsp.tiposituacaoparcela = 22 )
        and exists(select TribDebito.Entidade
                   from Tribparcelamentodebito Tribparcelamentodebito
                  left outer join TribDebito TribDebito
                          on TribDebito.Iddebito = Tribparcelamentodebito.Iddebito
                  left outer join TribDebitoParcela tdp
                          on TribDebito.Entidade = tdp.Entidade and
                             TribDebito.Exercicio = tdp.Exercicio and
                             TribDebito.Tipocadastro = tdp.Tipocadastro and
                             TribDebito.Cadastrogeral = tdp.Cadastrogeral and
                             TribDebito.Guiarecolhimento = tdp.Guiarecolhimento and
                             TribDebito.Subdivida = tdp.Subdivida
                  Left Outer Join tribSituacaoParcela y
                          on y.SituacaoParcela = tdp.SituacaoDebito
                  Left Outer Join tribTipoSituacaoParcela z
                          on z.TipoSituacaoParcela = y.TipoSituacaoParcela
                  Where Tribparcelamentodebito.Idparcelamento = TribParcelamento.Idparcelamento
                    And z.Tipo = 'A'
                    $[FiltroParcelasVencer]
                   and ( ( ( (
                    select
                    	Count(TribDebitoParcela.Parcela)
                    from
                    	tribDebitoParcela TribDebitoParcela
                    left outer join tribSituacaoParcela on
                    	tribSituacaoParcela.SituacaoParcela = TribDebitoParcela.SituacaoDebito
                    left outer join tribTipoSituacaoParcela on
                    	tribTipoSituacaoParcela.TipoSituacaoParcela = tribSituacaoParcela.TipoSituacaoParcela
                    where
                    	TribDebitoParcela.Entidade = tribDebito.Entidade
                    	and TribDebitoParcela.Exercicio = tribDebito.Exercicio
                    	and TribDebitoParcela.TipoCadastro = tribDebito.TipoCadastro
                    	and TribDebitoParcela.CadastroGeral = tribDebito.CadastroGeral
                    	and TribDebitoParcela.GuiaRecolhimento = tribDebito.GuiaRecolhimento
                    	and TribDebitoParcela.SubDivida = tribDebito.SubDivida
                    	and TribDebitoParcela.DataVencimento < cast(:DataVencimento as date)
                    	and tribTipoSituacaoParcela.Tipo = 'A'  ) >=
                    ( select
                    	tpp.numeroparcelasvencidas
                    from
                    	tribparcelamento par
                    inner join tribparamparcelamento tpp on
                    	( par.idparametroparcelamento = tpp.idparametroparcelamento )
                    where
                    	par.idparcelamento = tribparcelamento.idparcelamento ) ) )
                    	$[FiltroParcelasDesfazerParcelamento] ) )


