/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.ws.oxy;

import br.com.elotech.core.exception.EloValidationException;
import br.com.elotech.tributos.domain.Bloqueto;
import br.com.elotech.tributos.domain.BoletoDebito;
import br.com.elotech.tributos.domain.Debito;
import br.com.elotech.tributos.domain.OrigemEmissao;
import br.com.elotech.tributos.domain.TipoBloqueto;
import br.com.elotech.tributos.dto.BloquetoDTO;
import br.com.elotech.tributos.dto.DebitoBloquetoMobileDTO;
import br.com.elotech.tributos.dto.DebitoDTO;
import br.com.elotech.tributos.dto.DebitoParcelaDTO;
import br.com.elotech.tributos.dto.GeraBoletoDTO;
import br.com.elotech.tributos.dto.GeraBoletoPorFormaPagamentoDTO;
import br.com.elotech.tributos.service.AiseBloquetoService;
import br.com.elotech.tributos.service.DebitoService;
import br.com.elotech.tributos.service.GeraBoletoService;
import br.com.elotech.tributos.service.exception.DebitoNotFoundException;
import br.com.elotech.tributos.service.ws.AisePdfService;
import br.com.elotech.tributos.util.DateUtils;
import br.com.elotech.tributos.ws.rest.dto.DebitoItbiDTO;
import java.io.Serializable;
import java.time.LocalDate;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.context.annotation.Profile;
import org.springframework.stereotype.Service;

/*
 * Exception performing whole class analysis ignored.
 */
@Service
@Profile(value={"!onpremise"})
public class OxyAiseBloquetoService
implements AiseBloquetoService {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(OxyAiseBloquetoService.class);
    private final GeraBoletoService geraBoletoService;
    private final DebitoService debitoService;
    private final AisePdfService aisePdfService;

    private static void setValoresDesconto(Bloqueto bloqueto, BloquetoDTO bloquetoDTO) {
        BoletoDebito valoresAcumulados = bloqueto.getDebitos().stream().reduce(new BoletoDebito(), BoletoDebito::add);
        bloquetoDTO.setValorDescontoPrincipal(valoresAcumulados.getValorDescontoPrincipal());
        bloquetoDTO.setValorDescontoJuros(valoresAcumulados.getValorDescontoJuros());
        bloquetoDTO.setValorDescontoMulta(valoresAcumulados.getValorDescontoMulta());
        bloquetoDTO.setValorDescontoCorrecao(valoresAcumulados.getValorDescontoCorrecao());
    }

    public BloquetoDTO geraBloquetoPorDataPagamento(List<DebitoDTO> debitosMarcados, LocalDate dataPagamento) {
        GeraBoletoDTO geraBoletoDTO = this.buildDTO(debitosMarcados);
        geraBoletoDTO.setDataReferencia(dataPagamento);
        return this.geraBoleto(geraBoletoDTO);
    }

    public BloquetoDTO geraBloqueto(List<DebitoDTO> debitosMarcados) {
        GeraBoletoDTO geraBoletoDTO = this.buildDTO(debitosMarcados);
        return this.geraBoleto(geraBoletoDTO);
    }

    public BloquetoDTO geraBloquetoPorListaDebito(List<DebitoBloquetoMobileDTO> debitosMarcados) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setImpressaoCarne(Boolean.FALSE);
        geraBoletoDTO.setUsuario("WEB");
        geraBoletoDTO.setDebitos(this.debitosBloquetoMobileDTOToDebitoParcelaDTO(debitosMarcados));
        geraBoletoDTO.setDataReferencia(LocalDate.now());
        return this.geraBoleto(geraBoletoDTO);
    }

    private List<DebitoParcelaDTO> debitosBloquetoMobileDTOToDebitoParcelaDTO(List<DebitoBloquetoMobileDTO> debitosMarcados) {
        return debitosMarcados.stream().flatMap(debitoMarcado -> debitoMarcado.getParcelas().stream().map(parcela -> {
            DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
            debitoParcelaDTO.setIdDebito(debitoMarcado.getIdDebito());
            debitoParcelaDTO.setParcela(Long.valueOf(parcela.intValue()));
            return debitoParcelaDTO;
        })).collect(Collectors.toList());
    }

    public BloquetoDTO geraBloquetoItbi(DebitoItbiDTO debitoItbi) {
        Debito debito = (Debito)this.debitoService.findById((Serializable)debitoItbi.getIdDebito()).orElseThrow(() -> new DebitoNotFoundException(debitoItbi.getIdDebito()));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setImpressaoCarne(Boolean.FALSE);
        geraBoletoDTO.setUsuario(debitoItbi.getUsuario());
        geraBoletoDTO.setPessoa(debitoItbi.getPessoaCompradorPrincipal());
        LocalDate dataVencimentoParcela = debito.getParcela(Long.valueOf(1L)).getDataVencimento();
        LocalDate dataReferencia = DateUtils.isVencido((LocalDate)dataVencimentoParcela) != false ? LocalDate.now() : dataVencimentoParcela;
        geraBoletoDTO.setDataReferencia(dataReferencia);
        DebitoParcelaDTO de = new DebitoParcelaDTO();
        de.setIdDebito(debitoItbi.getIdDebito());
        de.setParcela(Long.valueOf(1L));
        geraBoletoDTO.setDebitos(Collections.singletonList(de));
        BloquetoDTO result = this.geraBoleto(geraBoletoDTO);
        result.setUrlImpressao(this.aisePdfService.fetchBloquetoItbi(result.getBloqueto(), debitoItbi.getIdSequencia(), debitoItbi.getTipoRelatorioBloqueto().getTipo(), debitoItbi.getRelatorioBloqueto()));
        return result;
    }

    public BloquetoDTO geraBoletoPorFormaPagamento(GeraBoletoPorFormaPagamentoDTO geraBoletoPorFormaPagamentoDTO) {
        Debito debito = (Debito)this.debitoService.findById((Serializable)geraBoletoPorFormaPagamentoDTO.getIdDebito()).orElseThrow(() -> new DebitoNotFoundException(geraBoletoPorFormaPagamentoDTO.getIdDebito()));
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.COTA_UNICA);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE_WEB);
        geraBoletoDTO.setImpressaoCarne(Boolean.FALSE);
        geraBoletoDTO.setUsuario("WEB");
        geraBoletoDTO.setDebitos(this.getDebitoParcelaDTOS(debito));
        return this.geraBoleto(geraBoletoDTO, geraBoletoPorFormaPagamentoDTO.getFormaPagamento());
    }

    private List<DebitoParcelaDTO> getDebitoParcelaDTOS(Debito debito) {
        return debito.getParcelas().stream().map(parcela -> {
            DebitoParcelaDTO dto = new DebitoParcelaDTO();
            dto.setIdDebito(debito.getId());
            dto.setParcela(parcela.getId().getParcela());
            return dto;
        }).collect(Collectors.toList());
    }

    private GeraBoletoDTO buildDTO(List<DebitoDTO> debitosMarcados) {
        GeraBoletoDTO geraBoletoDTO = new GeraBoletoDTO();
        geraBoletoDTO.setTipoBoleto(TipoBloqueto.AGRUPADO);
        geraBoletoDTO.setOrigemEmissao(OrigemEmissao.AISE);
        geraBoletoDTO.setImpressaoCarne(Boolean.FALSE);
        geraBoletoDTO.setUsuario("WEB");
        geraBoletoDTO.setDebitos(debitosMarcados.stream().map(debitoMarcado -> {
            DebitoParcelaDTO debitoParcelaDTO = new DebitoParcelaDTO();
            debitoParcelaDTO.setIdDebito(debitoMarcado.getIdDebito());
            debitoParcelaDTO.setParcela(debitoMarcado.getParcela());
            return debitoParcelaDTO;
        }).collect(Collectors.toList()));
        return geraBoletoDTO;
    }

    private BloquetoDTO geraBoleto(GeraBoletoDTO geraBoletoDTO) {
        return this.geraBoleto(geraBoletoDTO, this.geraBoletoService.getFormaPagamento());
    }

    private BloquetoDTO geraBoleto(GeraBoletoDTO geraBoletoDTO, Long formaPagamento) {
        List boletosGerados = this.geraBoletoService.geraBoleto(geraBoletoDTO, formaPagamento, Boolean.valueOf(false));
        if (boletosGerados.isEmpty()) {
            throw new EloValidationException("N\u00e3o foi gerado nenhum boleto");
        }
        if (boletosGerados.size() > 1) {
            String idsBoletosGerados = boletosGerados.stream().map(Bloqueto::getId).map(Object::toString).collect(Collectors.joining(", "));
            throw new EloValidationException(String.format("Foram gerados mais de um boleto. Boletos gerados: %s.", idsBoletosGerados));
        }
        Bloqueto boletoGerado = (Bloqueto)boletosGerados.get(0);
        return this.convert(boletoGerado);
    }

    private BloquetoDTO convert(Bloqueto bloqueto) {
        BloquetoDTO bloquetoDTO = new BloquetoDTO();
        bloquetoDTO.setId(bloqueto.getId());
        bloquetoDTO.setEntidade(bloqueto.getEntidade());
        bloquetoDTO.setExercicioBloqueto(bloqueto.getExercicioBloqueto());
        bloquetoDTO.setBloqueto(bloqueto.getBloqueto());
        bloquetoDTO.setCodigoBarras(bloqueto.getCodigoBarras());
        bloquetoDTO.setDataEmissao(bloqueto.getDataEmissao());
        bloquetoDTO.setDataVencimento(bloqueto.getDataVencimento());
        bloquetoDTO.setValorPrincipal(bloqueto.getValorPrincipal());
        bloquetoDTO.setValorJuros(bloqueto.getValorJuros());
        bloquetoDTO.setValorMulta(bloqueto.getValorMulta());
        bloquetoDTO.setValorCorrecao(bloqueto.getValorCorrecao());
        bloquetoDTO.setValorDesconto(bloqueto.getValorDesconto());
        OxyAiseBloquetoService.setValoresDesconto((Bloqueto)bloqueto, (BloquetoDTO)bloquetoDTO);
        bloquetoDTO.setCampo1(bloqueto.getCampo1());
        bloquetoDTO.setCampo2(bloqueto.getCampo2());
        bloquetoDTO.setCampo3(bloqueto.getCampo3());
        bloquetoDTO.setCampo4(bloqueto.getCampo4());
        bloquetoDTO.setCampo5(bloqueto.getCampo5());
        bloquetoDTO.setUrlImpressao(this.getUrlImpressao(bloqueto));
        bloquetoDTO.setCodigoValidacao(bloqueto.getCodigoValidacao());
        bloquetoDTO.setValorAPagar(bloqueto.getValorBloqueto());
        bloquetoDTO.setNossoNumero(bloqueto.getNossoNumero());
        bloquetoDTO.setInstrucao("N\u00e3o Receber ap\u00f3s o Vencimento.");
        bloquetoDTO.setCadastro(bloqueto.getCadastroGeral().toCadastroGeralDTOWithPessoa());
        bloquetoDTO.setLinhaDigitavel(bloqueto.getLinhaDigitavel());
        bloquetoDTO.setCadastroPessoaDTO();
        bloquetoDTO.setTextoQrCode(bloqueto.getTextoQrCode());
        return bloquetoDTO;
    }

    private String getUrlImpressao(Bloqueto boleto) {
        return this.aisePdfService.fetchBloquetoByExercicio(boleto.getBloqueto(), boleto.getExercicioBloqueto());
    }

    @Generated
    public OxyAiseBloquetoService(GeraBoletoService geraBoletoService, DebitoService debitoService, AisePdfService aisePdfService) {
        this.geraBoletoService = geraBoletoService;
        this.debitoService = debitoService;
        this.aisePdfService = aisePdfService;
    }
}

