/*
 * Decompiled with CFR 0.152.
 */
package br.com.elotech.tributos.service.solicitacaoaprovacao;

import br.com.elotech.console.dto.Modulo;
import br.com.elotech.core.domain.support.EloEntity;
import br.com.elotech.core.service.support.CrudService;
import br.com.elotech.lib.painel.dto.NotificationStatus;
import br.com.elotech.tributos.domain.ParametroGeral;
import br.com.elotech.tributos.domain.ParametroGeralEnum;
import br.com.elotech.tributos.domain.cancelamento.CancelamentoDebito;
import br.com.elotech.tributos.domain.solicitacaoaprovacao.SolicitacaoAprovacao;
import br.com.elotech.tributos.dto.BooleanSimNao;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.AproveSolicitacaoAprovacaoDTO;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.NewSolicitacaoAprovacaoDTO;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.SolicitacaoAprovacaoCancelamentoItemDTO;
import br.com.elotech.tributos.dto.solicitacaoaprovacao.SolicitacaoAprovacaoDTO;
import br.com.elotech.tributos.enums.SituacaoSolicitacaoAprovacaoEnum;
import br.com.elotech.tributos.exception.SolicitacaoAprovacaoNotFoundException;
import br.com.elotech.tributos.repository.solicitacaoaprovacao.SolicitacaoAprovacaoRepository;
import br.com.elotech.tributos.security.SecurityUtils;
import br.com.elotech.tributos.service.NotificacaoService;
import br.com.elotech.tributos.service.ParametroGeralService;
import br.com.elotech.tributos.service.cancelamento.CancelamentoDebitoService;
import br.com.elotech.tributos.service.solicitacaoaprovacao.SolicitacaoAprovacaoCancelamentoItemService;
import java.time.LocalDateTime;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.stream.Collectors;
import lombok.Generated;
import org.springframework.data.domain.Page;
import org.springframework.data.domain.Pageable;
import org.springframework.stereotype.Service;

@Service
public class SolicitacaoAprovacaoService
extends CrudService<SolicitacaoAprovacao, Long> {
    private final SolicitacaoAprovacaoCancelamentoItemService solicitacaoAprovacaoCancelamentoItemService;
    private final CancelamentoDebitoService cancelamentoDebitoService;
    private final SolicitacaoAprovacaoRepository repository;
    private final NotificacaoService notificacaoService;
    private final ParametroGeralService parametroGeralService;

    public SolicitacaoAprovacao create(NewSolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = this.createSolicitacaoAprovacao(dto);
        List itens = this.createItens(dto, solicitacaoAprovacao);
        this.createItensInDatabase(itens);
        return solicitacaoAprovacao;
    }

    private SolicitacaoAprovacao createSolicitacaoAprovacao(NewSolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = SolicitacaoAprovacao.from((SolicitacaoAprovacaoDTO)dto.getSolicitacaoAprovacao());
        return (SolicitacaoAprovacao)this.save((EloEntity)solicitacaoAprovacao, null);
    }

    private List<SolicitacaoAprovacaoCancelamentoItemDTO> createItens(NewSolicitacaoAprovacaoDTO dto, SolicitacaoAprovacao solicitacaoAprovacao) {
        List itensDTO = dto.getItens();
        return itensDTO.stream().map(itemDTO -> this.createItem(itemDTO, solicitacaoAprovacao)).collect(Collectors.toList());
    }

    private SolicitacaoAprovacaoCancelamentoItemDTO createItem(SolicitacaoAprovacaoCancelamentoItemDTO itemDTO, SolicitacaoAprovacao solicitacaoAprovacao) {
        itemDTO.setSolicitacaoAprovacao(solicitacaoAprovacao);
        return itemDTO;
    }

    private void createItensInDatabase(List<SolicitacaoAprovacaoCancelamentoItemDTO> itensDTO) {
        this.solicitacaoAprovacaoCancelamentoItemService.create(itensDTO);
    }

    public Page<SolicitacaoAprovacao> findAll(String search, Pageable pageable) {
        return this.findByRsql(search, pageable);
    }

    public SolicitacaoAprovacao buscaPorId(Long id) {
        return (SolicitacaoAprovacao)this.repository.findById((Object)id).orElseThrow(() -> new SolicitacaoAprovacaoNotFoundException(String.format("N\u00e3o foi encontrado nenhuma Solicita\u00e7o de Aprova\u00e7\u00e3o com o id %d", id)));
    }

    public SolicitacaoAprovacao aprovar(AproveSolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = this.buscaPorId(dto.getSolicitacaoAprovacao().getId());
        if (solicitacaoAprovacao.getSituacao().equals((Object)SituacaoSolicitacaoAprovacaoEnum.PENDENTE)) {
            CancelamentoDebito cancelamentoDebito = this.getCancelamentoDebito(dto);
            String identificador = this.getIdentificador(cancelamentoDebito);
            this.updateSolicitacaoAprovacao(solicitacaoAprovacao, dto, identificador);
            solicitacaoAprovacao = (SolicitacaoAprovacao)this.repository.save((Object)solicitacaoAprovacao);
            this.sendNotification(solicitacaoAprovacao);
            return solicitacaoAprovacao;
        }
        throw new SolicitacaoAprovacaoNotFoundException("A Solicita\u00e7\u00e3o n\u00e3o esta mais pendente para ser aprovada");
    }

    private CancelamentoDebito getCancelamentoDebito(AproveSolicitacaoAprovacaoDTO dto) {
        if (dto.getTipoFiltro().equals("P")) {
            return this.cancelamentoDebitoService.cancelamentoDebitoPorParcela(dto.getCancelamentoParcelasFormDTO());
        }
        if (this.validateParametroCancelamento().booleanValue()) {
            this.cancelamentoDebitoService.cancelamentoDebitoPorTributoAsync(dto.getCancelamentoTributosFormDTO(), SecurityUtils.getUserSecurityDTO());
            return null;
        }
        return this.cancelamentoDebitoService.cancelamentoDebitoPorTributo(dto.getCancelamentoTributosFormDTO());
    }

    private Boolean validateParametroCancelamento() {
        ParametroGeral parametroCancelamentoAsync = this.parametroGeralService.findByParametroAndModulo(ParametroGeralEnum.CANCELAMENTODEBITOASSINCRONO, Modulo.OXY_TRIBUTOS.getValue());
        return Objects.nonNull(parametroCancelamentoAsync) && BooleanSimNao.SIM.getValue().equals(parametroCancelamentoAsync.getValor());
    }

    private String getIdentificador(CancelamentoDebito cancelamentoDebito) {
        if (Objects.isNull(cancelamentoDebito)) {
            return null;
        }
        return cancelamentoDebito.getId().getEntidade() + "/" + cancelamentoDebito.getId().getExercicio() + "/" + cancelamentoDebito.getId().getId();
    }

    private void updateSolicitacaoAprovacao(SolicitacaoAprovacao solicitacaoAprovacao, AproveSolicitacaoAprovacaoDTO dto, String identificador) {
        solicitacaoAprovacao.setUsuarioAprovacao(SecurityUtils.getUserAise());
        solicitacaoAprovacao.setDataAprovacao(LocalDateTime.now());
        solicitacaoAprovacao.setMotivo(dto.getSolicitacaoAprovacao().getMotivo());
        solicitacaoAprovacao.setIdentificador(identificador);
        solicitacaoAprovacao.setSituacao(SituacaoSolicitacaoAprovacaoEnum.APROVADO);
    }

    private void sendNotification(SolicitacaoAprovacao solicitacaoAprovacao) {
        if (solicitacaoAprovacao.getSituacao().equals((Object)SituacaoSolicitacaoAprovacaoEnum.APROVADO)) {
            this.notificacaoService.send("Solicita\u00e7\u00e3o Aprovada", "Sua solicita\u00e7\u00e3o de " + solicitacaoAprovacao.getTipoAprovacao().getDescricao() + " foi aprovada", solicitacaoAprovacao.getUsuarioCriacao(), Optional.empty(), NotificationStatus.COMPLETED, Boolean.valueOf(false), "/tributos/solicitacoes-aprovacao/" + solicitacaoAprovacao.getId());
        } else {
            this.notificacaoService.send("Solicita\u00e7\u00e3o Rejeitada", "Sua solicita\u00e7\u00e3o de " + solicitacaoAprovacao.getTipoAprovacao().getDescricao() + " foi rejeitada", solicitacaoAprovacao.getUsuarioCriacao(), Optional.empty(), NotificationStatus.FAILED, Boolean.valueOf(false), "/tributos/solicitacoes-aprovacao/" + solicitacaoAprovacao.getId());
        }
    }

    public SolicitacaoAprovacao rejeitar(SolicitacaoAprovacaoDTO dto) {
        SolicitacaoAprovacao solicitacaoAprovacao = this.buscaPorId(dto.getId());
        solicitacaoAprovacao.setUsuarioAprovacao(SecurityUtils.getUserAise());
        solicitacaoAprovacao.setDataAprovacao(LocalDateTime.now());
        solicitacaoAprovacao.setMotivo(dto.getMotivo());
        solicitacaoAprovacao.setSituacao(SituacaoSolicitacaoAprovacaoEnum.REJEITADO);
        this.sendNotification(solicitacaoAprovacao);
        return (SolicitacaoAprovacao)this.repository.save((Object)solicitacaoAprovacao);
    }

    @Generated
    public SolicitacaoAprovacaoService(SolicitacaoAprovacaoCancelamentoItemService solicitacaoAprovacaoCancelamentoItemService, CancelamentoDebitoService cancelamentoDebitoService, SolicitacaoAprovacaoRepository repository, NotificacaoService notificacaoService, ParametroGeralService parametroGeralService) {
        this.solicitacaoAprovacaoCancelamentoItemService = solicitacaoAprovacaoCancelamentoItemService;
        this.cancelamentoDebitoService = cancelamentoDebitoService;
        this.repository = repository;
        this.notificacaoService = notificacaoService;
        this.parametroGeralService = parametroGeralService;
    }
}

